/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.ringsofascension.loot;

import com.focamacho.ringsofascension.item.ItemRingBase;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class RingsLootModifier
extends LootModifier {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> REGISTER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"ringsofascension");
    public static final RegistryObject<Codec<RingsLootModifier>> CODEC = REGISTER.register("rings_modifier", () -> RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)Codec.list((Codec)Codec.STRING).fieldOf("loot_tables").forGetter(m -> m.lootTables), (App)ForgeRegistries.ITEMS.getCodec().fieldOf("ring").forGetter(m -> m.item))).apply((Applicative)inst, RingsLootModifier::new)));
    public final List<String> lootTables;
    public final ItemRingBase item;

    public RingsLootModifier(LootItemCondition[] conditionsIn, List<String> lootTables, Item ring) {
        super(conditionsIn);
        if (!(ring instanceof ItemRingBase)) {
            throw new IllegalArgumentException("Provided item is not a ring.");
        }
        this.lootTables = lootTables;
        this.item = (ItemRingBase)ring;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.item.isEnabled.get().booleanValue() && this.lootTables.contains(context.getQueriedLootTableId().toString())) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CODEC.get();
    }
}

