/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.ringsofascension.item.rings;

import com.focamacho.ringsofascension.client.GlintRenderTypes;
import com.focamacho.ringsofascension.item.ItemRingBase;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;

public class ItemRingHealth
extends ItemRingBase {
    private static final UUID HEALTH_UUID = UUID.fromString("b29c34f3-1450-48ff-ab28-639647e11861");
    private final Supplier<Integer> hearts;

    public ItemRingHealth(Item.Properties properties, String tooltip, Supplier<Boolean> enabled, Supplier<Integer> hearts, GlintRenderTypes glintType) {
        super(properties, tooltip, enabled, glintType);
        this.hearts = hearts;
    }

    @Override
    public void onUnequippedCurio(String identifier, LivingEntity livingEntity) {
        if (livingEntity.m_21223_() > livingEntity.m_21233_()) {
            livingEntity.m_21153_(livingEntity.m_21233_());
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> curioModifiers(ItemStack stack, String identifier) {
        HashMultimap modifiers = HashMultimap.create();
        if (CuriosApi.getItemStackSlots((ItemStack)stack).containsKey(identifier) && ((Boolean)this.isEnabled.get()).booleanValue()) {
            modifiers.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(HEALTH_UUID, "Max Health", (double)(this.hearts.get() * 2), AttributeModifier.Operation.ADDITION));
        }
        return modifiers;
    }
}

