/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.blocks;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;

public class GenericChestMenu
extends AbstractContainerMenu {
    private final Container container;
    public final ChestType type;

    public GenericChestMenu(int id, Inventory inventory, ChestType type) {
        this(type.registries().getMenu().get(), id, inventory, (Container)new SimpleContainer(type.size()), type);
    }

    public GenericChestMenu(MenuType<GenericChestMenu> menuType, int id, Inventory inventory, Container container, ChestType type) {
        super(menuType, id);
        int slot;
        GenericChestMenu.m_38869_((Container)container, (int)type.size());
        this.container = container;
        this.type = type;
        container.m_5856_(inventory.f_35978_);
        for (int row = 0; row < type.rows(); ++row) {
            for (slot = 0; slot < type.length(); ++slot) {
                this.m_38897_(new ChestTypeSlot(container, slot + row * type.length(), type.menuOffset() + slot * 18, 18 + row * 18, type));
            }
        }
        int k = 1 + (type.rows() - 4) * 18;
        for (int row = 0; row < 3; ++row) {
            for (int slot2 = 0; slot2 < 9; ++slot2) {
                this.m_38897_(new Slot((Container)inventory, slot2 + row * 9 + 9, type.inventoryOffset() + slot2 * 18, 103 + row * 18 + k));
            }
        }
        for (slot = 0; slot < 9; ++slot) {
            this.m_38897_(new Slot((Container)inventory, slot, type.inventoryOffset() + slot * 18, 161 + k));
        }
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.container.m_5785_(player);
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.container.m_6542_(player);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack slotStack = slot.m_7993_();
        if (slotIndex < this.type.size() ? !this.m_38903_(slotStack, this.type.size(), this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.type.size(), false)) {
            return ItemStack.f_41583_;
        }
        if (slotStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return slotStack.m_41777_();
    }

    private static class ChestTypeSlot
    extends Slot {
        private final ChestType type;

        public ChestTypeSlot(Container container, int i, int j, int k, ChestType type) {
            super(container, i, j, k);
            this.type = type;
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return this.type.predicate().m_45049_(stack);
        }
    }
}

