/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.blocks;

import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlock;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestMenu;
import tech.thatgravyboat.ironchests.common.blocks.LockState;
import tech.thatgravyboat.ironchests.common.blocks.SyncableData;

public class GenericChestBlockEntity
extends RandomizableContainerBlockEntity
implements SyncableData,
WorldlyContainer {
    private final int[] slots;
    private NonNullList<ItemStack> items;
    private final ChestType type;
    private final MenuType<GenericChestMenu> menuType;
    private final ContainerOpenersCounter openersCounter;
    private UUID keyId;
    private float openness;
    private float lastOpenness;
    private boolean dropLock;

    public GenericChestBlockEntity(BlockPos blockPos, BlockState blockState, ChestType type) {
        this(type.registries().getMenu().get(), type.registries().getBlockEntity().get(), blockPos, blockState, type);
    }

    public GenericChestBlockEntity(MenuType<GenericChestMenu> menuType, BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState, final ChestType type) {
        super(blockEntityType, blockPos, blockState);
        this.openersCounter = new ContainerOpenersCounter(){

            protected void m_142292_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
                GenericChestBlockEntity.this.sync(level, blockPos);
                level.m_6263_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, type.blockType().getOpenSound(), SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)GenericChestBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
            }

            protected void m_142289_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
                level.m_6263_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, type.blockType().getCloseSound(), SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)GenericChestBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
            }

            protected void m_142148_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, int i, int j) {
            }

            protected boolean m_142718_(@NotNull Player player) {
                ChestMenu menu;
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                return abstractContainerMenu instanceof ChestMenu && (menu = (ChestMenu)abstractContainerMenu).m_39261_() == GenericChestBlockEntity.this;
            }
        };
        this.items = NonNullList.m_122780_((int)type.size(), (Object)ItemStack.f_41583_);
        this.type = type;
        this.menuType = menuType;
        this.slots = IntStream.range(0, type.size()).toArray();
    }

    @NotNull
    protected Component m_6820_() {
        return this.type.registries().getBlock().get().m_49954_();
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int i, @NotNull Inventory inventory) {
        return new GenericChestMenu(this.menuType, i, inventory, (Container)this, this.type);
    }

    public int m_6643_() {
        return this.type.size();
    }

    @NotNull
    public NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    public void m_6520_(NonNullList<ItemStack> items) {
        if (items.size() == this.m_6643_()) {
            this.items = items;
        } else {
            this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < items.size(); ++i) {
                this.items.set(i, (Object)((ItemStack)items.get(i)));
            }
        }
        this.m_6596_();
    }

    public boolean m_7013_(int i, @NotNull ItemStack itemStack) {
        return this.type.predicate().m_45049_(itemStack);
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (compoundTag.m_128441_("key")) {
            this.keyId = compoundTag.m_128342_("key");
        }
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
    }

    public void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        if (this.keyId != null) {
            compoundTag.m_128362_("key", this.keyId);
        }
    }

    public int viewers() {
        return this.openersCounter.m_155450_();
    }

    public void m_5856_(@NotNull Player player) {
        if (this.f_58857_ != null && !this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(@NotNull Player player) {
        if (this.f_58857_ != null && !this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public float getOpenness(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.lastOpenness, (float)this.openness);
    }

    public static void lidAnimateTick(Level level, BlockPos blockPos, BlockState blockState, GenericChestBlockEntity chestBlockEntity) {
        chestBlockEntity.lastOpenness = chestBlockEntity.openness;
        if (((Boolean)blockState.m_61143_((Property)GenericChestBlock.OPEN)).booleanValue() && chestBlockEntity.openness < 90.0f) {
            chestBlockEntity.openness = Math.min(chestBlockEntity.openness + 12.0f, 90.0f);
        } else if (!((Boolean)blockState.m_61143_((Property)GenericChestBlock.OPEN)).booleanValue() && chestBlockEntity.openness > 0.0f) {
            chestBlockEntity.openness = Math.max(chestBlockEntity.openness - 12.0f, 0.0f);
        }
    }

    public void m_6596_() {
        if (this.type.renderItems() && this.f_58857_ != null) {
            this.sync(this.f_58857_, this.f_58858_);
        }
        super.m_6596_();
    }

    @Override
    public void loadSyncTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public CompoundTag getSyncTag() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void setLockId(UUID uuid) {
        this.keyId = uuid;
    }

    public boolean isRightKey(UUID key) {
        return key.equals(this.keyId);
    }

    public UUID getKeyId() {
        return this.keyId;
    }

    public boolean canDropLock() {
        return this.dropLock;
    }

    public void setCanDropLock(boolean dropLock) {
        this.dropLock = dropLock;
    }

    public ChestType getChestType() {
        return this.type;
    }

    public int @NotNull [] m_7071_(@NotNull Direction direction) {
        return this.slots;
    }

    public boolean m_7155_(int i, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return this.keyId == null || ((LockState)((Object)this.m_58900_().m_61143_(GenericChestBlock.LOCK))).canOpen();
    }

    public boolean m_7157_(int i, @NotNull ItemStack itemStack, @NotNull Direction direction) {
        return this.keyId == null || ((LockState)((Object)this.m_58900_().m_61143_(GenericChestBlock.LOCK))).canOpen();
    }
}

