/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.util;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.entity.LivingEntity;

public abstract class TimerEntry {
    private final Map<UUID, ScheduledFuture<?>> timerMap = new ConcurrentHashMap();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(Math.max(4, Runtime.getRuntime().availableProcessors()), r -> {
        Thread thread = new Thread(r, "SkillTimerThread");
        thread.setDaemon(true);
        return thread;
    });

    public void addSkillTimer(LivingEntity living, int delay, int duration, int executionsPerSecond) {
        if (living == null || this.timerMap.containsKey(living.m_20148_())) {
            return;
        }
        UUID livingId = living.m_20148_();
        this.onSkillStart(living);
        ScheduledFuture<?> skillTask = scheduler.scheduleAtFixedRate(() -> this.executeTaskSafely(living, livingId), delay, 1000L / (long)executionsPerSecond, TimeUnit.MILLISECONDS);
        scheduler.schedule(() -> this.stopTimerSafely(living, livingId), (long)(delay + duration), TimeUnit.MILLISECONDS);
        this.timerMap.put(livingId, skillTask);
    }

    private void executeTaskSafely(LivingEntity living, UUID entityId) {
        try {
            if (living.m_6084_() && !living.m_213877_()) {
                this.onTaskRunning(living);
            } else {
                this.removeTimer(entityId);
            }
        }
        catch (Exception e) {
            this.removeTimer(entityId);
        }
    }

    public void stopTimerSafely(LivingEntity living, UUID entityId) {
        try {
            this.onSkillEnd(living);
        }
        finally {
            this.removeTimer(entityId);
        }
    }

    public boolean get(UUID uuid) {
        return this.timerMap.containsKey(uuid);
    }

    public synchronized void removeTimer(UUID livingId) {
        ScheduledFuture<?> task = this.timerMap.remove(livingId);
        if (task != null) {
            task.cancel(false);
        }
    }

    public static void shutdownAll() {
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(3L, TimeUnit.SECONDS)) {
                scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public abstract void onSkillStart(LivingEntity var1);

    public abstract void onTaskRunning(LivingEntity var1);

    public abstract void onSkillEnd(LivingEntity var1);
}

