/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.wzz.time_slow.entity.Fire2Entity;
import net.wzz.time_slow.init.ModEntities;

public class SummonManager {
    private final Map<UUID, SummonSession> activeSessions = new HashMap<UUID, SummonSession>();

    public void startSummon(Player player, LivingEntity target) {
        this.activeSessions.put(player.m_20148_(), new SummonSession(player, target));
    }

    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<UUID, SummonSession>> iter = this.activeSessions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<UUID, SummonSession> entry = iter.next();
            SummonSession session = entry.getValue();
            ++session.tick;
            if (session.shouldSummon()) {
                this.summon((LivingEntity)session.player, session.target);
                ++session.summonStage;
            }
            if (session.summonStage <= 4) continue;
            iter.remove();
        }
    }

    private void summon(LivingEntity living, LivingEntity target) {
        Level level = living.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            for (int a = 0; a <= 200; ++a) {
                Fire2Entity entity = new Fire2Entity((EntityType<Fire2Entity>)((EntityType)ModEntities.FIRE_2.get()), (Level)level2);
                double offsetX = Math.random() * 70.0 - 35.0;
                double offsetZ = Math.random() * 70.0 - 35.0;
                double offsetY = 15.0 + Math.random() * 7.0 + 5.0;
                entity.m_5602_((Entity)living);
                entity.m_7678_(target.m_20185_() + offsetX, target.m_20186_() + offsetY, target.m_20189_() + offsetZ, level2.m_213780_().m_188501_() * 360.0f, 0.0f);
                level2.m_7967_((Entity)entity);
            }
        }
    }

    private static class SummonSession {
        final Player player;
        final LivingEntity target;
        int tick = 0;
        int summonStage = 0;

        SummonSession(Player player, LivingEntity target) {
            this.player = player;
            this.target = target;
        }

        boolean shouldSummon() {
            return switch (this.summonStage) {
                case 0 -> {
                    if (this.tick % 10 == 0) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (this.tick % 20 == 0) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (this.tick % 30 == 0) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (this.tick % 40 == 0) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (this.tick % 50 == 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
    }
}

