/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class UltimateExplosionRenderer {
    private static final List<UltimateExplosion> explosions = new ArrayList<UltimateExplosion>();
    private static final RenderType SHOCKWAVE_TYPE = RenderType.m_173215_((String)"shockwave", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172811_)).m_110685_(RenderStateShard.f_110135_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110113_).m_110687_(RenderStateShard.f_110115_).m_110691_(false));
    public static final RenderType FIREBALL_TYPE = RenderType.m_173215_((String)"fireball", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172814_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("time_slow", "textures/fire.png"), false, false)).m_110685_(RenderStateShard.f_110135_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110113_).m_110687_(RenderStateShard.f_110115_).m_110691_(false));

    public static void createUltimateExplosion(Vec3 position, float duration, float radius) {
        explosions.add(new UltimateExplosion(position, duration, radius));
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            mc.f_91073_.m_7785_(position.f_82479_, position.f_82480_, position.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, 0.5f + (float)Math.random() * 0.2f, false);
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (explosions.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Camera camera = event.getCamera();
        Vec3 cameraPos = camera.m_90583_();
        float deltaTime = event.getPartialTick() * 0.016f;
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        for (UltimateExplosion explosion2 : explosions) {
            if (!explosion2.isActive()) continue;
            UltimateExplosionRenderer.renderShockwaves(poseStack, bufferSource, explosion2, cameraPos);
            UltimateExplosionRenderer.renderFireballs(poseStack, bufferSource, explosion2, cameraPos);
            UltimateExplosionRenderer.renderDebris(poseStack, bufferSource, explosion2, cameraPos);
        }
        bufferSource.m_109911_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        explosions.removeIf(explosion -> {
            explosion.update(deltaTime);
            return !explosion.isActive();
        });
    }

    private static void renderShockwaves(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, UltimateExplosion explosion, Vec3 cameraPos) {
        VertexConsumer buffer = bufferSource.m_6299_(SHOCKWAVE_TYPE);
        for (ShockwaveRing ring : explosion.shockwaves) {
            if (!ring.isVisible()) continue;
            UltimateExplosionRenderer.renderShockwaveRing(poseStack, buffer, ring, cameraPos);
        }
    }

    private static void renderShockwaveRing(PoseStack poseStack, VertexConsumer buffer, ShockwaveRing ring, Vec3 cameraPos) {
        poseStack.m_85836_();
        Vec3 relativePos = ring.center.m_82546_(cameraPos);
        poseStack.m_85837_(relativePos.f_82479_, relativePos.f_82480_, relativePos.f_82481_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        int segments = 32;
        float alpha = ring.getAlpha();
        int color = (int)(alpha * 255.0f) << 24 | 0xFF0000 | 0x6400;
        for (int i = 0; i <= segments; ++i) {
            float angle = (float)((double)(i * 2) * Math.PI / (double)segments);
            float x = Mth.m_14089_((float)angle) * ring.currentRadius;
            float z = Mth.m_14031_((float)angle) * ring.currentRadius;
            buffer.m_252986_(matrix, x, -0.1f, z).m_193479_(color).m_5752_();
            buffer.m_252986_(matrix, x, 0.1f, z).m_193479_(color).m_5752_();
        }
        poseStack.m_85849_();
    }

    private static void renderFireballs(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, UltimateExplosion explosion, Vec3 cameraPos) {
        VertexConsumer buffer = bufferSource.m_6299_(FIREBALL_TYPE);
        for (FireBall fireball : explosion.fireBalls) {
            if (!fireball.isAlive()) continue;
            UltimateExplosionRenderer.renderFireball(poseStack, buffer, fireball, cameraPos);
        }
    }

    private static void renderFireball(PoseStack poseStack, VertexConsumer buffer, FireBall fireball, Vec3 cameraPos) {
        poseStack.m_85836_();
        Vec3 relativePos = fireball.currentPos.m_82546_(cameraPos);
        poseStack.m_85837_(relativePos.f_82479_, relativePos.f_82480_, relativePos.f_82481_);
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        poseStack.m_252781_(camera.m_253121_());
        poseStack.m_252781_(Axis.f_252403_.m_252977_(fireball.rotation));
        float scale = fireball.size;
        poseStack.m_85841_(scale, scale, scale);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        int color = fireball.getColor();
        buffer.m_252986_(matrix, -1.0f, -1.0f, 0.0f).m_193479_(color).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 1.0f, -1.0f, 0.0f).m_193479_(color).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_193479_(color).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, -1.0f, 1.0f, 0.0f).m_193479_(color).m_7421_(0.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
    }

    private static void renderDebris(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, UltimateExplosion explosion, Vec3 cameraPos) {
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110504_());
        for (DebrisParticle debris : explosion.debris) {
            if (!debris.isAlive()) continue;
            UltimateExplosionRenderer.renderDebrisParticle(poseStack, buffer, debris, cameraPos);
        }
    }

    private static void renderDebrisParticle(PoseStack poseStack, VertexConsumer buffer, DebrisParticle debris, Vec3 cameraPos) {
        poseStack.m_85836_();
        Vec3 relativePos = debris.currentPos.m_82546_(cameraPos);
        poseStack.m_85837_(relativePos.f_82479_, relativePos.f_82480_, relativePos.f_82481_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float alpha = debris.getAlpha();
        int color = (int)(alpha * 255.0f) << 24 | 0x640000 | 0x3200;
        float size = debris.size;
        buffer.m_252986_(matrix, -size, 0.0f, 0.0f).m_193479_(color).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, size, 0.0f, 0.0f).m_193479_(color).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, -size, 0.0f).m_193479_(color).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, size, 0.0f).m_193479_(color).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, -size).m_193479_(color).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, size).m_193479_(color).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    public static class UltimateExplosion {
        public Vec3 position;
        public float time;
        public float maxTime;
        public float radius;
        public List<ShockwaveRing> shockwaves;
        public List<FireBall> fireBalls;
        public List<DebrisParticle> debris;
        public boolean hasScreenShake;

        public UltimateExplosion(Vec3 pos, float duration, float radius) {
            this.position = pos;
            this.time = 0.0f;
            this.maxTime = duration;
            this.radius = radius;
            this.hasScreenShake = true;
            this.shockwaves = new ArrayList<ShockwaveRing>();
            for (int i = 0; i < 3; ++i) {
                this.shockwaves.add(new ShockwaveRing(pos, radius, (float)i * 0.2f));
            }
            this.fireBalls = new ArrayList<FireBall>();
            int fireballCount = (int)(radius * 1.5f) + 5;
            for (int i = 0; i < fireballCount; ++i) {
                this.fireBalls.add(new FireBall(pos, radius));
            }
            this.debris = new ArrayList<DebrisParticle>();
            int debrisCount = (int)(radius * 3.0f) + 10;
            for (int i = 0; i < debrisCount; ++i) {
                this.debris.add(new DebrisParticle(pos, radius));
            }
        }

        public float getProgress() {
            return Mth.m_14036_((float)(this.time / this.maxTime), (float)0.0f, (float)1.0f);
        }

        public boolean isActive() {
            return this.time < this.maxTime;
        }

        public void update(float deltaTime) {
            this.time += deltaTime;
            for (ShockwaveRing ring : this.shockwaves) {
                ring.update(deltaTime);
            }
            for (FireBall ball : this.fireBalls) {
                ball.update(deltaTime);
            }
            for (DebrisParticle particle : this.debris) {
                particle.update(deltaTime);
            }
        }
    }

    public static class ShockwaveRing {
        public Vec3 center;
        public float currentRadius;
        public float maxRadius;
        public float startTime;
        public float life;
        public float maxLife;

        public ShockwaveRing(Vec3 center, float maxRadius, float delay) {
            this.center = center;
            this.currentRadius = 0.0f;
            this.maxRadius = maxRadius * 8.0f;
            this.startTime = delay;
            this.life = 0.0f;
            this.maxLife = 2.0f;
        }

        public void update(float deltaTime) {
            this.life += deltaTime;
            if (this.life > this.startTime) {
                float progress = (this.life - this.startTime) / (this.maxLife - this.startTime);
                this.currentRadius = this.maxRadius * progress;
            }
        }

        public boolean isVisible() {
            return this.life > this.startTime && this.life < this.maxLife;
        }

        public float getAlpha() {
            if (!this.isVisible()) {
                return 0.0f;
            }
            float progress = (this.life - this.startTime) / (this.maxLife - this.startTime);
            return (1.0f - progress) * 0.6f;
        }
    }

    public static class FireBall {
        public Vec3 startPos;
        public Vec3 currentPos;
        public Vec3 velocity;
        public float size;
        public float life;
        public float maxLife;
        public float rotation;
        public float rotationSpeed;
        public int colorPhase;

        public FireBall(Vec3 startPos, float explosionRadius) {
            this.startPos = startPos;
            this.currentPos = startPos;
            double theta = Math.random() * Math.PI * 2.0;
            double phi = Math.acos(2.0 * Math.random() - 1.0);
            float speed = (float)(Math.random() * 2.0 + 0.5) * explosionRadius * 0.3f;
            this.velocity = new Vec3(Math.sin(phi) * Math.cos(theta) * (double)speed, Math.cos(phi) * (double)speed + Math.random() * 0.5, Math.sin(phi) * Math.sin(theta) * (double)speed);
            this.size = (float)(Math.random() * 0.8 + 0.4) * explosionRadius * 0.2f;
            this.life = 0.0f;
            this.maxLife = (float)(Math.random() * 1.5 + 1.0);
            this.rotation = (float)(Math.random() * 360.0);
            this.rotationSpeed = (float)(Math.random() * 360.0 - 180.0);
            this.colorPhase = 0;
        }

        public void update(float deltaTime) {
            this.life += deltaTime;
            this.currentPos = this.currentPos.m_82549_(this.velocity.m_82490_((double)deltaTime));
            this.velocity = this.velocity.m_82520_(0.0, (double)(-9.8f * deltaTime * 0.2f), 0.0);
            this.velocity = this.velocity.m_82490_((double)0.95f);
            this.rotation += this.rotationSpeed * deltaTime;
            float progress = this.life / this.maxLife;
            this.colorPhase = progress < 0.2f ? 0 : (progress < 0.4f ? 1 : (progress < 0.7f ? 2 : 3));
        }

        public boolean isAlive() {
            return this.life < this.maxLife;
        }

        public float getAlpha() {
            float progress = this.life / this.maxLife;
            if (progress < 0.1f) {
                return progress / 0.1f;
            }
            return 1.0f - (progress - 0.1f) / 0.9f;
        }

        public int getColor() {
            int green;
            int red;
            float alpha = this.getAlpha();
            return (int)(alpha * 255.0f) << 24 | red << 16 | green << 8 | (switch (this.colorPhase) {
                case 0 -> {
                    red = 255;
                    green = 255;
                    yield 255;
                }
                case 1 -> {
                    red = 255;
                    green = 255;
                    yield 100;
                }
                case 2 -> {
                    red = 255;
                    green = 150;
                    yield 0;
                }
                default -> {
                    red = 255;
                    green = 50;
                    yield 0;
                }
            });
        }
    }

    public static class DebrisParticle {
        public Vec3 currentPos;
        public Vec3 velocity;
        public float size;
        public float life;
        public float maxLife;
        public Vec3 rotationAxis;
        public float rotationAngle;
        public float rotationSpeed;

        public DebrisParticle(Vec3 startPos, float explosionRadius) {
            this.currentPos = startPos;
            double theta = Math.random() * Math.PI * 2.0;
            double phi = Math.acos(2.0 * Math.random() - 1.0);
            float speed = (float)(Math.random() * 3.0 + 1.0) * explosionRadius * 0.4f;
            this.velocity = new Vec3(Math.sin(phi) * Math.cos(theta) * (double)speed, Math.cos(phi) * (double)speed, Math.sin(phi) * Math.sin(theta) * (double)speed);
            this.size = (float)(Math.random() * 0.3 + 0.1);
            this.life = 0.0f;
            this.maxLife = (float)(Math.random() * 3.0 + 2.0);
            this.rotationAxis = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).m_82541_();
            this.rotationAngle = 0.0f;
            this.rotationSpeed = (float)(Math.random() * 720.0 - 360.0);
        }

        public void update(float deltaTime) {
            this.life += deltaTime;
            this.currentPos = this.currentPos.m_82549_(this.velocity.m_82490_((double)deltaTime));
            this.velocity = this.velocity.m_82520_(0.0, (double)(-9.8f * deltaTime), 0.0);
            this.velocity = this.velocity.m_82490_((double)0.98f);
            this.rotationAngle += this.rotationSpeed * deltaTime;
        }

        public boolean isAlive() {
            return this.life < this.maxLife;
        }

        public float getAlpha() {
            float progress = this.life / this.maxLife;
            return Math.max(0.0f, 1.0f - progress * progress);
        }
    }
}

