/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.network;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.wzz.time_slow.event.TimeAccelerationCore;
import net.wzz.time_slow.init.ModItems;
import net.wzz.time_slow.util.CuriosUtil;
import net.wzz.time_slow.util.TimerEntry;
import net.wzz.time_slow.util.Utils;

public class TimeSpeed {
    private static final TimerEntry timerEntry = new TimerEntry(){

        @Override
        public void onSkillStart(LivingEntity living) {
            long t = -1L;
            if (!CuriosUtil.hasCurios(living, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
                timerEntry2.addSkillTimer(living, 0, 15000, 1);
            }
            Utils.playSound((LevelAccessor)living.f_19853_, "time_accel", (Entity)living);
            if (!living.f_19853_.f_46443_ && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                if (!CuriosUtil.hasCurios(living, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
                    t = (long)player.m_21223_();
                }
                player.m_5661_((Component)Component.m_237113_((String)"\u65f6\u95f4\u7684\u52a0\u62a4\u8d4b\u4e88\u4f60\u5b83\u672c\u6e90\u7684\u529b\u91cf"), false);
                TimeAccelerationCore.setIncrementalSpeedMultiplier(player.m_284548_(), 10.0f, t, 10.0f, 1L, 1000000.0f, (worldLevel, reason, finalMultiplier, duration) -> {
                    timerEntry.stopTimerSafely((LivingEntity)player, player.f_19820_);
                    living.m_21195_(MobEffects.f_19596_);
                    if (!player.f_19853_.f_46443_) {
                        player.m_5661_((Component)Component.m_237113_((String)"\u65f6\u95f4\u7684\u52a0\u62a4\u4e0e\u4f60\u6682\u65f6\u5931\u53bb\u4e86\u8054\u7cfb"), false);
                    }
                });
            }
        }

        @Override
        public void onTaskRunning(LivingEntity living) {
            if (living instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)living;
                if (living.m_21223_() <= 0.0f) {
                    TimeAccelerationCore.stopAcceleration(serverPlayer.m_284548_());
                    this.stopTimerSafely(living, living.m_20148_());
                    return;
                }
                int speedAmplifier = (int)(TimeAccelerationCore.getSpeedMultiplier(serverPlayer.m_284548_()) * 0.1f);
                if (speedAmplifier > 10) {
                    speedAmplifier = 10;
                }
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, speedAmplifier));
            }
        }

        @Override
        public void onSkillEnd(LivingEntity living) {
            Level level = living.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                TimeAccelerationCore.stopAcceleration(serverLevel);
            }
        }
    };
    private static final TimerEntry timerEntry2 = new TimerEntry(){

        @Override
        public void onSkillStart(LivingEntity living) {
            living.getPersistentData().m_128379_("noUse222", true);
        }

        @Override
        public void onTaskRunning(LivingEntity living) {
        }

        @Override
        public void onSkillEnd(LivingEntity living) {
            living.getPersistentData().m_128379_("noUse222", false);
        }
    };

    public static void execute(Entity entity) {
        Player _plr;
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity && entity instanceof Player && (CuriosUtil.hasCurios((LivingEntity)(_plr = (Player)entity), (Item)ModItems.time_slow.get()) || CuriosUtil.hasCurios((LivingEntity)_plr, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) && !_plr.f_19853_.f_46443_) {
            if (timerEntry.get(_plr.f_19820_)) {
                timerEntry.stopTimerSafely((LivingEntity)_plr, _plr.f_19820_);
                return;
            }
            if (!entity.getPersistentData().m_128471_("noUse222")) {
                timerEntry.addSkillTimer((LivingEntity)_plr, 0, 15000000, 1);
            } else {
                ((Player)entity).m_5661_((Component)Component.m_237113_((String)"\u65f6\u95f4\u7684\u52a0\u62a4\u5e76\u4e0d\u4f1a\u653e\u7eb5\u4e8e\u4f60"), false);
            }
        }
    }
}

