/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.wzz.time_slow.GuardianMod;
import net.wzz.time_slow.init.ModItems;
import net.wzz.time_slow.network.AbilityManager;
import net.wzz.time_slow.util.CuriosUtil;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TimeSlowMessage {
    int type;
    int pressedms;

    public TimeSlowMessage(int type, int pressedms) {
        this.type = type;
        this.pressedms = pressedms;
    }

    public TimeSlowMessage(FriendlyByteBuf buffer) {
        this.type = buffer.readInt();
        this.pressedms = buffer.readInt();
    }

    public static void buffer(TimeSlowMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.writeInt(message.pressedms);
    }

    public static void handler(TimeSlowMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> TimeSlowMessage.pressAction((Player)context.getSender(), message.type, message.pressedms));
        context.setPacketHandled(true);
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        int idx;
        CompoundTag tag;
        Level world = entity.f_19853_;
        if (!world.m_46805_(entity.m_20183_())) {
            return;
        }
        ArrayList<String> abilities = new ArrayList<String>();
        abilities.add("\u65f6\u95f4\u51cf\u7f13");
        abilities.add("\u65f6\u95f4\u52a0\u901f");
        abilities.add("\u56e0\u679c");
        abilities.add("\u795e\u5723");
        abilities.add("\u6cbb\u6108");
        abilities.add("\u529b\u91cf");
        abilities.add("\u738b\u8005");
        abilities.add("\u9a91\u58eb");
        abilities.add("\u65f6\u505c");
        ArrayList<String> abilities2 = new ArrayList<String>();
        abilities2.add("\u65f6\u95f4\u51cf\u7f13");
        abilities2.add("\u65f6\u95f4\u52a0\u901f");
        if (CuriosUtil.hasCurios((LivingEntity)entity, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
            tag = entity.getPersistentData();
            idx = tag.m_128451_("SaviorAbilityIndex");
            if (type == 1) {
                idx = (idx + 1) % abilities.size();
                tag.m_128405_("SaviorAbilityIndex", idx);
                entity.m_5661_((Component)Component.m_237113_((String)("\u5df2\u5207\u6362\u6280\u80fd\uff1a" + (String)abilities.get(idx))), true);
                return;
            }
            if (type == 0) {
                String ability = (String)abilities.get(idx);
                AbilityManager.invoke(ability, (Entity)entity);
                return;
            }
        }
        if (CuriosUtil.hasCurios((LivingEntity)entity, (Item)ModItems.time_slow.get())) {
            tag = entity.getPersistentData();
            idx = tag.m_128451_("SaviorAbilityIndex2");
            if (type == 1) {
                idx = (idx + 1) % abilities2.size();
                tag.m_128405_("SaviorAbilityIndex2", idx);
                String s = (String)abilities2.get(idx);
                entity.m_5661_((Component)Component.m_237113_((String)("\u5df2\u5207\u6362\u6280\u80fd\uff1a" + s)), true);
                return;
            }
            if (type == 0) {
                String ability = (String)abilities2.get(idx);
                AbilityManager.invoke(ability, (Entity)entity);
                return;
            }
        }
        if (type == 0) {
            AbilityManager.invoke("\u65f6\u95f4\u51cf\u7f13", (Entity)entity);
            AbilityManager.invoke("\u56e0\u679c", (Entity)entity);
            AbilityManager.invoke("\u795e\u5723", (Entity)entity);
            AbilityManager.invoke("\u6cbb\u6108", (Entity)entity);
            AbilityManager.invoke("\u529b\u91cf", (Entity)entity);
            AbilityManager.invoke("\u738b\u8005", (Entity)entity);
            AbilityManager.invoke("\u9a91\u58eb", (Entity)entity);
            AbilityManager.invoke("\u65f6\u505c", (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GuardianMod.addNetworkMessage(TimeSlowMessage.class, TimeSlowMessage::buffer, TimeSlowMessage::new, TimeSlowMessage::handler);
    }
}

