/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.wzz.time_slow.GuardianMod;
import net.wzz.time_slow.init.ModItems;
import net.wzz.time_slow.util.CuriosUtil;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class StartMessage {
    int type;
    int pressedms;

    public StartMessage(int type, int pressedms) {
        this.type = type;
        this.pressedms = pressedms;
    }

    public StartMessage(FriendlyByteBuf buffer) {
        this.type = buffer.readInt();
        this.pressedms = buffer.readInt();
    }

    public static void buffer(StartMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.writeInt(message.pressedms);
    }

    public static void handler(StartMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> StartMessage.pressAction((Player)context.getSender(), message.type, message.pressedms));
        context.setPacketHandled(true);
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.m_9236_();
        if (!world.m_46805_(entity.m_20183_())) {
            return;
        }
        boolean keyDown = type == 1;
        StartMessage.handleLightningKeyPress(entity, keyDown);
    }

    private static void handleLightningKeyPress(Player player, boolean keyDown) {
        if (!CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
            return;
        }
        player.getPersistentData().m_128379_("SaviorWasALTDown", keyDown);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GuardianMod.addNetworkMessage(StartMessage.class, StartMessage::buffer, StartMessage::new, StartMessage::handler);
    }
}

