/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.network;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.wzz.time_slow.GuardianMod;
import net.wzz.time_slow.entity.RainbowLightingEntity;
import net.wzz.time_slow.init.ModEntities;
import net.wzz.time_slow.init.ModItems;
import net.wzz.time_slow.util.CuriosUtil;
import net.wzz.time_slow.util.Utils;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RainbowCastMessage {
    int type;
    int pressedms;

    public RainbowCastMessage(int type, int pressedms) {
        this.type = type;
        this.pressedms = pressedms;
    }

    public RainbowCastMessage(FriendlyByteBuf buffer) {
        this.type = buffer.readInt();
        this.pressedms = buffer.readInt();
    }

    public static void buffer(RainbowCastMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.writeInt(message.pressedms);
    }

    public static void handler(RainbowCastMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> RainbowCastMessage.pressAction((Player)context.getSender(), message.type, message.pressedms));
        context.setPacketHandled(true);
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.m_9236_();
        if (!world.m_46805_(entity.m_20183_())) {
            return;
        }
        boolean keyDown = type == 1;
        RainbowCastMessage.handleLightningKeyPress(entity, keyDown);
    }

    private static void handleLightningKeyPress(Player player, boolean keyDown) {
        if (!CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
            return;
        }
        CompoundTag data = player.getPersistentData();
        if (keyDown) {
            data.m_128379_("LightningPressing", true);
            data.m_128356_("LightningStartTick", player.m_9236_().m_46467_());
            double searchRadius = 6.0;
            AABB searchArea = new AABB(player.m_20185_() - searchRadius, player.m_20186_() - searchRadius, player.m_20189_() - searchRadius, player.m_20185_() + searchRadius, player.m_20186_() + searchRadius, player.m_20189_() + searchRadius);
            List nearbyEntities = player.m_9236_().m_6443_(LivingEntity.class, searchArea, entity -> entity != player && entity.m_6084_());
            if (!nearbyEntities.isEmpty()) {
                LivingEntity closestEntity = null;
                double closestDistance = Double.MAX_VALUE;
                for (LivingEntity entity2 : nearbyEntities) {
                    double distance = player.m_20280_((Entity)entity2);
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    closestEntity = entity2;
                }
                if (closestEntity != null) {
                    Vec3 targetPos = closestEntity.m_20182_();
                    ListTag posList = new ListTag();
                    posList.add((Object)DoubleTag.m_128500_((double)targetPos.f_82479_));
                    posList.add((Object)DoubleTag.m_128500_((double)targetPos.f_82480_));
                    posList.add((Object)DoubleTag.m_128500_((double)targetPos.f_82481_));
                    data.m_128365_("LightningTargetPos", (Tag)posList);
                    data.m_128405_("LightningTargetEntityId", closestEntity.m_19879_());
                    CompoundTag entitiesData = new CompoundTag();
                    for (int i = 0; i < Math.min(nearbyEntities.size(), 10); ++i) {
                        entitiesData.m_128405_("entity_" + i, ((LivingEntity)nearbyEntities.get(i)).m_19879_());
                    }
                    entitiesData.m_128405_("count", Math.min(nearbyEntities.size(), 10));
                    data.m_128365_("LightningTargetEntities", (Tag)entitiesData);
                }
            } else {
                Vec3 lookDirection = player.m_20154_();
                Vec3 targetPos = player.m_20182_().m_82549_(lookDirection.m_82490_(5.0));
                ListTag posList = new ListTag();
                posList.add((Object)DoubleTag.m_128500_((double)targetPos.f_82479_));
                posList.add((Object)DoubleTag.m_128500_((double)targetPos.f_82480_));
                posList.add((Object)DoubleTag.m_128500_((double)targetPos.f_82481_));
                data.m_128365_("LightningTargetPos", (Tag)posList);
                data.m_128473_("LightningTargetEntityId");
                data.m_128473_("LightningTargetEntities");
            }
        } else if (data.m_128471_("LightningPressing") && data.m_128441_("LightningStartTick")) {
            long startTime = data.m_128454_("LightningStartTick");
            long currentTime = player.m_9236_().m_46467_();
            if (currentTime - startTime >= 20L) {
                RainbowCastMessage.castColorLightning(player);
            }
            data.m_128473_("LightningPressing");
            data.m_128473_("LightningStartTick");
            data.m_128473_("LightningTargetPos");
            data.m_128473_("LightningTargetEntityId");
            data.m_128473_("LightningTargetEntities");
        }
    }

    private static void castColorLightning(Player player) {
        CompoundTag data = player.getPersistentData();
        if (!data.m_128441_("LightningTargetPos")) {
            return;
        }
        ListTag posList = data.m_128437_("LightningTargetPos", 6);
        Vec3 targetPos = new Vec3(posList.m_128772_(0), posList.m_128772_(1), posList.m_128772_(2));
        for (int i = 0; i < 5; ++i) {
            RainbowLightingEntity lightning = new RainbowLightingEntity((EntityType<RainbowLightingEntity>)((EntityType)ModEntities.RAINBOW_LIGHTING.get()), player.m_9236_());
            lightning.m_146884_(targetPos);
            lightning.m_20874_(true);
            player.m_9236_().m_7967_((Entity)lightning);
        }
        if (data.m_128441_("LightningTargetEntities")) {
            CompoundTag entitiesData = data.m_128469_("LightningTargetEntities");
            int count = entitiesData.m_128451_("count");
            for (int i = 0; i < count; ++i) {
                LivingEntity living;
                int entityId = entitiesData.m_128451_("entity_" + i);
                Entity target = player.m_9236_().m_6815_(entityId);
                if (!(target instanceof LivingEntity) || !(living = (LivingEntity)target).m_6084_()) continue;
                Vec3 entityPos = target.m_20182_();
                for (int j = 0; j < 2; ++j) {
                    RainbowLightingEntity lightning = new RainbowLightingEntity((EntityType<RainbowLightingEntity>)((EntityType)ModEntities.RAINBOW_LIGHTING.get()), player.m_9236_());
                    lightning.m_146884_(entityPos.m_82520_((player.m_217043_().m_188500_() - 0.5) * 2.0, player.m_217043_().m_188500_() * 1.0, (player.m_217043_().m_188500_() - 0.5) * 2.0));
                    lightning.m_20874_(true);
                    player.m_9236_().m_7967_((Entity)lightning);
                }
                Utils.notHurtTime(living);
                target.m_6469_(target.m_269291_().m_269374_((Entity)player), 30.0f);
                Utils.notHurtTime(living);
                target.m_6469_(target.m_269291_().m_269425_(), 30.0f);
                Utils.notHurtTime(living);
                target.m_6469_(target.m_269291_().m_269264_(), 30.0f);
            }
        } else if (data.m_128441_("LightningTargetEntityId")) {
            int entityId = data.m_128451_("LightningTargetEntityId");
            Entity target = player.m_9236_().m_6815_(entityId);
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                Utils.notHurtTime(living);
                target.m_6469_(target.m_269291_().m_269374_((Entity)player), 30.0f);
                Utils.notHurtTime(living);
                target.m_6469_(target.m_269291_().m_269425_(), 30.0f);
                Utils.notHurtTime(living);
                target.m_6469_(target.m_269291_().m_269264_(), 30.0f);
            }
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GuardianMod.addNetworkMessage(RainbowCastMessage.class, RainbowCastMessage::buffer, RainbowCastMessage::new, RainbowCastMessage::handler);
    }
}

