/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.network;

import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.wzz.time_slow.init.ModItems;
import net.wzz.time_slow.init.ModParticleTypes;
import net.wzz.time_slow.util.CuriosUtil;
import net.wzz.time_slow.util.TimerEntry;
import net.wzz.time_slow.util.Utils;

public class Power {
    private static final TimerEntry timerEntry = new TimerEntry(){

        @Override
        public void onSkillStart(LivingEntity living) {
            if (!living.f_19853_.f_46443_ && living instanceof Player) {
                Player player = (Player)living;
                player.m_5661_((Component)Component.m_237113_((String)"\u529b\u91cf\u7684\u52a0\u62a4\u8d4b\u4e88\u4f60\u5b83\u672c\u6e90\u7684\u529b\u91cf"), false);
            }
            Utils.playSound((LevelAccessor)living.f_19853_, SoundEvents.f_11874_, (Entity)living);
            if (CuriosUtil.hasCurios(living, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
                living.getPersistentData().m_128379_("isStrDamage", true);
                living.m_7292_(new MobEffectInstance(MobEffects.f_19617_, Utils.effectPower(living, living.m_21233_()), -1));
            }
        }

        @Override
        public void onTaskRunning(LivingEntity living) {
            Utils.spawnParticles((Entity)living, (SimpleParticleType)ModParticleTypes.RED_ROD.get(), 10, 0.01f);
            living.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 60, 2));
            for (MobEffect mobEffect : Utils.getEffects(living, MobEffectCategory.HARMFUL)) {
                living.m_21195_(mobEffect);
            }
        }

        @Override
        public void onSkillEnd(LivingEntity living) {
            if (!living.f_19853_.f_46443_ && living instanceof Player) {
                Player player = (Player)living;
                player.m_5661_((Component)Component.m_237113_((String)"\u529b\u91cf\u7684\u52a0\u62a4\u4e0e\u4f60\u6682\u65f6\u5931\u53bb\u4e86\u8054\u7cfb"), false);
                if (!living.getPersistentData().m_128471_("hasDamagePower")) {
                    player.m_5661_((Component)Component.m_237113_((String)"\u8fc7\u5ea6\u7684\u529b\u91cf\u4f1a\u4f7f\u4eba\u75af\u72c2\u3002\u3002\u3002\u3002\u3002\u3002\u3002"), false);
                    player.m_6469_(player.f_19853_.m_269111_().m_269341_(), player.m_21233_());
                }
            }
            living.getPersistentData().m_128379_("noDamageUsePower", false);
            living.getPersistentData().m_128379_("isStrDamage", false);
        }
    };
    private static final TimerEntry timerEntry2 = new TimerEntry(){

        @Override
        public void onSkillStart(LivingEntity living) {
            living.getPersistentData().m_128379_("noUsePower", true);
        }

        @Override
        public void onTaskRunning(LivingEntity living) {
        }

        @Override
        public void onSkillEnd(LivingEntity living) {
            living.getPersistentData().m_128379_("noUsePower", false);
            living.getPersistentData().m_128379_("noDamageUsePower", false);
        }
    };

    public static void execute(Entity entity) {
        Player _plr;
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity && entity instanceof Player && (CuriosUtil.hasCurios((LivingEntity)(_plr = (Player)entity), (Item)ModItems.power_defence.get()) || CuriosUtil.hasCurios((LivingEntity)_plr, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) && !_plr.f_19853_.f_46443_) {
            if (timerEntry.get(_plr.f_19820_)) {
                timerEntry.stopTimerSafely((LivingEntity)_plr, _plr.f_19820_);
                return;
            }
            if (!entity.getPersistentData().m_128471_("noUsePower")) {
                int t = 15000;
                if (CuriosUtil.hasCurios((LivingEntity)_plr, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
                    t = 600000;
                }
                timerEntry.addSkillTimer((LivingEntity)_plr, 0, t, 1);
                entity.getPersistentData().m_128379_("noDamageUsePower", true);
                if (!CuriosUtil.hasCurios((LivingEntity)_plr, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
                    timerEntry2.addSkillTimer((LivingEntity)_plr, 0, 20000, 1);
                }
            } else {
                ((Player)entity).m_5661_((Component)Component.m_237113_((String)"\u529b\u91cf\u7684\u52a0\u62a4\u5e76\u4e0d\u4f1a\u653e\u7eb5\u4e8e\u4f60"), false);
            }
        }
    }
}

