/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.item;

import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.wzz.time_slow.GuardianMod;
import net.wzz.time_slow.entity.MagmaMeteorEntity;
import net.wzz.time_slow.entity.RainbowLightingEntity;
import net.wzz.time_slow.goal.EscapeFromStrongerPlayerGoal;
import net.wzz.time_slow.init.ModEntities;
import net.wzz.time_slow.item.BaseCuriousItem;
import net.wzz.time_slow.network.SetSaviorChargedPacket;
import net.wzz.time_slow.network.util.NetworkHandler;
import net.wzz.time_slow.util.RainbowText;
import net.wzz.time_slow.util.Utils;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class SaviorGuardianItem
extends BaseCuriousItem {
    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> list, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, list, p_41424_);
        list.add((Component)RainbowText.rgb("\u88ab\u9009\u4e2d\u4e4b\u4eba\uff0c\u4e3a\u4e16\u754c\u94a6\u5b9a\u7684\u6551\u4e16\u4e3b\uff0c\u4f60\u5c06\u88ab\u8d4b\u4e88\u51fb\u8d25\u5730\u72f1\u7684\u6076\u9b54\uff0c\u89e3\u653e\u4e16\u754c\u7684\u547d\u8fd0\u3002"));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        player.m_7292_(new MobEffectInstance(MobEffects.f_19618_, 100, 4));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 100, 4));
        if (player.m_21223_() < player.m_21233_() && player.f_19797_ % 20 == 0) {
            player.m_5634_(3.0f);
        }
        CompoundTag tag = player.getPersistentData();
        boolean wasCharging = tag.m_128471_("SaviorIsCharging");
        boolean isCharging = player.getPersistentData().m_128471_("SaviorWasALTDown");
        boolean wasShiftDown = tag.m_128471_("SaviorWasShiftDown");
        tag.m_128379_("SaviorWasShiftDown", isCharging);
        if (isCharging) {
            int chargeTick = tag.m_128451_("SaviorChargeTick");
            if (!(wasShiftDown || tag.m_128471_("SaviorIsCharging") || tag.m_128471_("SaviorCharged"))) {
                player.m_5661_((Component)RainbowText.rgb("\u5f00\u59cb\u84c4\u529b\uff01"), true);
                tag.m_128379_("SaviorIsCharging", true);
            }
            if (!tag.m_128471_("SaviorCharged")) {
                tag.m_128405_("SaviorChargeTick", ++chargeTick);
                if (chargeTick % 10 == 0) {
                    Entity[] targets;
                    Entity[] entityArray = targets = Utils.findAllEntities((Entity)player, 12.0);
                    int n = entityArray.length;
                    for (int i = 0; i < n; ++i) {
                        Entity e = entityArray[i];
                        if (e instanceof Player) continue;
                        if (Utils.countEntities((Entity)player, 20.0, RainbowLightingEntity.class) < 8) {
                            RainbowLightingEntity lightning = new RainbowLightingEntity((EntityType<RainbowLightingEntity>)((EntityType)ModEntities.RAINBOW_LIGHTING.get()), player.m_9236_());
                            lightning.m_6027_(e.m_20185_(), e.m_20186_(), e.m_20189_());
                            player.m_9236_().m_7967_((Entity)lightning);
                        }
                        e.m_20334_(0.0, 0.0, 0.0);
                        if (!(e instanceof LivingEntity)) continue;
                        LivingEntity living = (LivingEntity)e;
                        living.m_6469_(living.m_269291_().m_269425_(), 1.0f);
                    }
                }
                if (chargeTick >= 140) {
                    player.m_5661_((Component)RainbowText.rgb("\u84c4\u529b\u5b8c\u6210\uff01\u53ef\u91ca\u653e\u7ec8\u6781\u6280(R)\uff01"), true);
                    tag.m_128379_("SaviorCharged", true);
                    if (player instanceof ServerPlayer) {
                        Entity[] serverPlayer = (Entity[])player;
                        NetworkHandler.sendToPlayer(new SetSaviorChargedPacket(true), (ServerPlayer)serverPlayer);
                    }
                    tag.m_128405_("SaviorChargeTick", 0);
                    tag.m_128379_("SaviorIsCharging", false);
                }
            }
        } else if (wasShiftDown || wasCharging) {
            tag.m_128405_("SaviorChargeTick", 0);
            tag.m_128379_("SaviorIsCharging", false);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHandler.sendToPlayer(new SetSaviorChargedPacket(false), serverPlayer);
            }
            tag.m_128379_("SaviorCharged", false);
            tag.m_128379_("SaviorUltimateReady", false);
        }
        if (tag.m_128471_("SaviorCharged") && tag.m_128471_("SaviorUltimateReady")) {
            Level level;
            Entity[] targets;
            tag.m_128379_("SaviorCharged", false);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHandler.sendToPlayer(new SetSaviorChargedPacket(false), serverPlayer);
            }
            tag.m_128379_("SaviorUltimateReady", false);
            tag.m_128405_("SaviorChargeTick", 0);
            player.m_5661_((Component)RainbowText.rgb("\u6551\u4e16\u7684\u5149\u8f89\u91ca\u653e\uff01"), true);
            Utils.spawnClientDistortionField(player);
            for (Entity e : targets = Utils.findAllEntities((Entity)player, 30.0)) {
                if (!(e instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)e;
                if (e instanceof Player) continue;
                le.m_20254_(10);
                le.m_21153_(Math.max(1.0f, le.m_21223_() - le.m_21233_() * 0.2f));
            }
            if (!player.m_9236_().f_46443_ && (level = player.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                GuardianMod.summonManager.startSummon(player, (LivingEntity)player);
                MagmaMeteorEntity meteor = new MagmaMeteorEntity((EntityType<? extends MagmaMeteorEntity>)((EntityType)ModEntities.MAGMA_METEOR.get()), (Level)serverLevel);
                meteor.m_7678_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 0.0f, 0.0f);
                meteor.m_20334_(0.0, -2.0, 0.0);
                serverLevel.m_7967_((Entity)meteor);
            }
        }
        this.fearAura(player);
        this.checkFatalProtection(player, stack);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyAttributeModifiers(player, true);
            player.m_150110_().f_35936_ = true;
            player.m_6885_();
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyAttributeModifiers(player, false);
            if (!player.m_150110_().f_35937_) {
                player.m_150110_().f_35936_ = false;
                player.m_150110_().f_35935_ = false;
                player.m_6885_();
            }
        }
    }

    private void applyAttributeModifiers(Player player, boolean apply) {
        UUID movementSpeedUUID = UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B");
        UUID attackDamageUUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
        AttributeModifier speedModifier = new AttributeModifier(movementSpeedUUID, "Savior Guardian Speed", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeModifier damageModifier = new AttributeModifier(attackDamageUUID, "Savior Guardian Damage", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeMap attributes = player.m_21204_();
        AttributeInstance movementSpeed = attributes.m_22146_(Attributes.f_22279_);
        if (apply) {
            AttributeInstance attackDamage;
            if (movementSpeed != null && !movementSpeed.m_22109_(speedModifier)) {
                movementSpeed.m_22125_(speedModifier);
            }
            if ((attackDamage = attributes.m_22146_(Attributes.f_22281_)) != null && !attackDamage.m_22109_(damageModifier)) {
                attackDamage.m_22125_(damageModifier);
            }
        } else {
            AttributeInstance attackDamage;
            if (movementSpeed != null) {
                movementSpeed.m_22120_(movementSpeedUUID);
            }
            if ((attackDamage = attributes.m_22146_(Attributes.f_22281_)) != null) {
                attackDamage.m_22120_(attackDamageUUID);
            }
        }
    }

    private void fearAura(Player player) {
        Level level = player.m_9236_();
        double range = 10.0;
        List nearbyEntities = level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(range), entity -> entity != player && entity.m_6084_());
        for (LivingEntity entity2 : nearbyEntities) {
            if (!(entity2 instanceof PathfinderMob)) continue;
            PathfinderMob mob = (PathfinderMob)entity2;
            mob.f_21345_.m_25352_(0, (Goal)new EscapeFromStrongerPlayerGoal(mob, 0.5));
        }
    }

    private void checkFatalProtection(Player player, ItemStack stack) {
        if (player.m_21223_() <= player.m_21233_() * 0.1f) {
            this.triggerFatalProtection(player, stack);
        }
    }

    private void triggerFatalProtection(Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        long lastUse = tag.m_128454_("LastFatalProtection");
        long currentTime = player.m_9236_().m_46467_();
        if (currentTime - lastUse < 1200L) {
            return;
        }
        tag.m_128356_("LastFatalProtection", currentTime);
        player.m_21153_(player.m_21233_());
        CompoundTag playerTag = player.getPersistentData();
        playerTag.m_128356_("SaviorInvulnerable", currentTime + 200L);
        Level level = player.m_9236_();
        if (!level.f_46443_) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
            for (int i = 0; i < 30; ++i) {
                double d0 = player.m_217043_().m_188583_() * 0.02;
                double d1 = player.m_217043_().m_188583_() * 0.02;
                double d2 = player.m_217043_().m_188583_() * 0.02;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123767_, player.m_20185_() + player.m_217043_().m_188500_() - 0.5, player.m_20186_() + player.m_217043_().m_188500_() * 2.0, player.m_20189_() + player.m_217043_().m_188500_() - 0.5, d0, d1, d2);
            }
        }
        player.m_213846_((Component)Component.m_237113_((String)"\u00a76\u6551\u4e16\u4e3b\u7684\u5e87\u62a4\u5df2\u6fc0\u6d3b\uff01").m_130940_(ChatFormatting.GOLD));
    }
}

