/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.event;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.wzz.time_slow.network.TimeSpeedSyncPacket;
import net.wzz.time_slow.network.util.NetworkHandler;

public class TimeAccelerationCore {
    private static final Map<ServerLevel, AccelerationData> accelerationData = new ConcurrentHashMap<ServerLevel, AccelerationData>();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);

    public static void setSpeedMultiplier(ServerLevel level, float multiplier, long durationSeconds) {
        AccelerationData data = new AccelerationData(multiplier, durationSeconds);
        accelerationData.put(level, data);
        TimeAccelerationCore.syncToClients(level, multiplier);
    }

    public static void setIncrementalSpeedMultiplier(ServerLevel level, float initialMultiplier, long durationSeconds, float incrementalMultiplier, long incrementalInterval, float maxMultiplier) {
        TimeAccelerationCore.setIncrementalSpeedMultiplier(level, initialMultiplier, durationSeconds, incrementalMultiplier, incrementalInterval, maxMultiplier, null);
    }

    public static void setIncrementalSpeedMultiplier(ServerLevel level, float initialMultiplier, long durationSeconds, float incrementalMultiplier, long incrementalInterval, float maxMultiplier, AccelerationEndCallback endCallback) {
        AccelerationData data = new AccelerationData(initialMultiplier, durationSeconds, incrementalMultiplier, incrementalInterval, maxMultiplier, endCallback);
        accelerationData.put(level, data);
        TimeAccelerationCore.syncToClients(level, initialMultiplier);
    }

    public static void setSpeedMultiplier(ServerLevel level, float multiplier, long durationSeconds, AccelerationEndCallback endCallback) {
        AccelerationData data = new AccelerationData(multiplier, durationSeconds);
        data.endCallback = endCallback;
        accelerationData.put(level, data);
        TimeAccelerationCore.syncToClients(level, multiplier);
    }

    public static void setSpeedMultiplier(ServerLevel level, float multiplier) {
        TimeAccelerationCore.setSpeedMultiplier(level, multiplier, -1L);
    }

    public static float getSpeedMultiplier(ServerLevel level) {
        AccelerationData data = accelerationData.get(level);
        return data != null ? data.currentMultiplier : 1.0f;
    }

    public static AccelerationData getAccelerationData(ServerLevel level) {
        return accelerationData.get(level);
    }

    public static void stopAcceleration(ServerLevel level) {
        AccelerationData data = accelerationData.remove(level);
        if (data != null) {
            data.executeEndCallback(level, EndReason.MANUAL_STOP);
        }
        TimeAccelerationCore.syncToClients(level, 1.0f);
    }

    public static void cleanupLevel(ServerLevel level) {
        AccelerationData data = accelerationData.remove(level);
        if (data != null) {
            data.executeEndCallback(level, EndReason.WORLD_UNLOAD);
        }
        TimeAccelerationCore.syncToClients(level, 1.0f);
    }

    private static void updateAllLevels() {
        try {
            accelerationData.entrySet().removeIf(entry -> {
                ServerLevel level = (ServerLevel)entry.getKey();
                AccelerationData data = (AccelerationData)entry.getValue();
                if (data.isExpired()) {
                    TimeAccelerationCore.syncToClients(level, 1.0f);
                    data.executeEndCallback(level, EndReason.EXPIRED);
                    return true;
                }
                if (data.shouldIncrement()) {
                    float oldMultiplier = data.currentMultiplier;
                    data.performIncrement();
                    if (Math.abs(oldMultiplier - data.currentMultiplier) > 0.01f) {
                        TimeAccelerationCore.syncToClients(level, data.currentMultiplier);
                    }
                }
                return false;
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void syncToClients(ServerLevel level, float multiplier) {
        TimeSpeedSyncPacket packet = new TimeSpeedSyncPacket(level.m_46472_().m_135782_(), multiplier);
        for (ServerPlayer player : level.m_6907_()) {
            NetworkHandler.sendToPlayer(packet, player);
        }
    }

    public static void shutdown() {
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            scheduler.shutdownNow();
        }
    }

    static {
        scheduler.scheduleAtFixedRate(TimeAccelerationCore::updateAllLevels, 1L, 1L, TimeUnit.SECONDS);
    }

    public static class AccelerationData {
        public float currentMultiplier;
        public long startTime;
        public long durationSeconds;
        public float incrementalMultiplier;
        public long incrementalInterval;
        public long lastIncrementTime;
        public float maxMultiplier;
        public AccelerationEndCallback endCallback;
        public boolean callbackExecuted;

        public AccelerationData(float initialMultiplier, long durationSeconds) {
            this.currentMultiplier = initialMultiplier;
            this.startTime = System.currentTimeMillis();
            this.durationSeconds = durationSeconds;
            this.incrementalMultiplier = 0.0f;
            this.incrementalInterval = 0L;
            this.lastIncrementTime = this.startTime;
            this.maxMultiplier = -1.0f;
            this.endCallback = null;
            this.callbackExecuted = false;
        }

        public AccelerationData(float initialMultiplier, long durationSeconds, float incrementalMultiplier, long incrementalInterval, float maxMultiplier) {
            this.currentMultiplier = initialMultiplier;
            this.startTime = System.currentTimeMillis();
            this.durationSeconds = durationSeconds;
            this.incrementalMultiplier = incrementalMultiplier;
            this.incrementalInterval = incrementalInterval;
            this.lastIncrementTime = this.startTime;
            this.maxMultiplier = maxMultiplier;
            this.endCallback = null;
            this.callbackExecuted = false;
        }

        public AccelerationData(float initialMultiplier, long durationSeconds, float incrementalMultiplier, long incrementalInterval, float maxMultiplier, AccelerationEndCallback endCallback) {
            this.currentMultiplier = initialMultiplier;
            this.startTime = System.currentTimeMillis();
            this.durationSeconds = durationSeconds;
            this.incrementalMultiplier = incrementalMultiplier;
            this.incrementalInterval = incrementalInterval;
            this.lastIncrementTime = this.startTime;
            this.maxMultiplier = maxMultiplier;
            this.endCallback = endCallback;
            this.callbackExecuted = false;
        }

        public boolean isExpired() {
            if (this.durationSeconds == -1L) {
                return false;
            }
            return (System.currentTimeMillis() - this.startTime) / 1000L >= this.durationSeconds;
        }

        public boolean shouldIncrement() {
            if (this.incrementalMultiplier <= 0.0f || this.incrementalInterval <= 0L) {
                return false;
            }
            return (System.currentTimeMillis() - this.lastIncrementTime) / 1000L >= this.incrementalInterval;
        }

        public void performIncrement() {
            if (this.maxMultiplier > 0.0f && this.currentMultiplier >= this.maxMultiplier) {
                return;
            }
            this.currentMultiplier += this.incrementalMultiplier;
            if (this.maxMultiplier > 0.0f && this.currentMultiplier > this.maxMultiplier) {
                this.currentMultiplier = this.maxMultiplier;
            }
            this.lastIncrementTime = System.currentTimeMillis();
        }

        public long getRemainingSeconds() {
            if (this.durationSeconds == -1L) {
                return -1L;
            }
            long elapsed = (System.currentTimeMillis() - this.startTime) / 1000L;
            return Math.max(0L, this.durationSeconds - elapsed);
        }

        public long getTotalRunningSeconds() {
            return (System.currentTimeMillis() - this.startTime) / 1000L;
        }

        public void executeEndCallback(ServerLevel level, EndReason reason) {
            if (this.endCallback != null && !this.callbackExecuted) {
                this.callbackExecuted = true;
                try {
                    this.endCallback.onAccelerationEnd(level, reason, this.currentMultiplier, this.getTotalRunningSeconds());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @FunctionalInterface
    public static interface AccelerationEndCallback {
        public void onAccelerationEnd(ServerLevel var1, EndReason var2, float var3, long var4);
    }

    public static enum EndReason {
        EXPIRED("\u65f6\u95f4\u5230\u671f"),
        MANUAL_STOP("\u624b\u52a8\u505c\u6b62"),
        WORLD_UNLOAD("\u4e16\u754c\u5378\u8f7d"),
        ERROR("\u53d1\u751f\u9519\u8bef");

        private final String description;

        private EndReason(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

