/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.tuple.Pair;

public class KeyReferenceScreen
extends BaseScreen {
    private final Panel textPanel;
    private final PanelScrollBar scrollBar;
    private final SimpleTextButton closeButton;
    private final String[] translationKeys;
    private static final int SCROLLBAR_WIDTH = 16;
    private static final int GUTTER_SIZE = 2;

    public KeyReferenceScreen(String ... translationKeys) {
        this.translationKeys = translationKeys;
        this.textPanel = new TextPanel((Panel)this);
        this.closeButton = new SimpleTextButton((Panel)this, (Component)Component.m_237115_((String)"gui.close"), Icons.CLOSE){

            public void onClicked(MouseButton button) {
                KeyReferenceScreen.this.onBack();
            }
        };
        this.scrollBar = new PanelScrollBar((Panel)this, this.textPanel);
    }

    public boolean onInit() {
        return this.setSizeProportional(0.7f, 0.8f);
    }

    public Theme getTheme() {
        return EditConfigScreen.THEME;
    }

    public void addWidgets() {
        this.add((Widget)this.textPanel);
        this.add((Widget)this.scrollBar);
        this.add((Widget)this.closeButton);
    }

    public void alignWidgets() {
        int textPanelWidth = this.getGui().width - 6 - 16;
        this.textPanel.setPosAndSize(2, 2, textPanelWidth, this.getGui().height - 4);
        this.textPanel.alignWidgets();
        this.scrollBar.setPosAndSize(this.getGui().width - 2 - 16, this.textPanel.getPosY(), 16, this.textPanel.getHeight());
        this.closeButton.setPosAndSize(this.width + 2, 0, 20, 20);
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        Color4I.DARK_GRAY.draw(graphics, x, y, w, h);
        MutableComponent msg = Component.m_237115_((String)"ftbquests.gui.key_reference");
        int w1 = theme.getStringWidth((FormattedText)msg);
        theme.drawString(graphics, (Object)msg, x + (w - w1) / 2, y - theme.getFontHeight() - 1, Color4I.rgb((int)65535), 2);
    }

    private static List<Pair<Component, Component>> buildText(String ... translationKeys) {
        ArrayList<Pair<Component, Component>> res = new ArrayList<Pair<Component, Component>>();
        for (String translationKey : translationKeys) {
            block5: for (String line : I18n.m_118938_((String)translationKey, (Object[])new Object[0]).split("\\n")) {
                String[] parts = line.split(";", 2);
                switch (parts.length) {
                    case 0: {
                        res.add((Pair<Component, Component>)Pair.of((Object)Component.m_237119_(), (Object)Component.m_237119_()));
                        continue block5;
                    }
                    case 1: {
                        res.add((Pair<Component, Component>)Pair.of((Object)Component.m_237113_((String)parts[0]).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}), (Object)Component.m_237119_()));
                        continue block5;
                    }
                    default: {
                        res.add((Pair<Component, Component>)Pair.of((Object)Component.m_237113_((String)parts[0]), (Object)Component.m_237113_((String)parts[1]).m_130940_(ChatFormatting.GRAY)));
                    }
                }
            }
            res.add((Pair<Component, Component>)Pair.of((Object)Component.m_237119_(), (Object)Component.m_237119_()));
        }
        return res;
    }

    private class TextPanel
    extends Panel {
        private final TwoColumnList textWidget;

        public TextPanel(Panel panel) {
            super(panel);
            this.textWidget = new TwoColumnList(this, KeyReferenceScreen.buildText(KeyReferenceScreen.this.translationKeys));
        }

        public void addWidgets() {
            this.add(this.textWidget);
        }

        public void alignWidgets() {
            this.align(WidgetLayout.VERTICAL);
            this.textWidget.setPos(2, 2);
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            ((Icon)ThemeProperties.BACKGROUND.get()).draw(graphics, x, y, w, h);
        }
    }

    private static class TwoColumnList
    extends Widget {
        private final int widestL;
        private final List<Pair<Component, Component>> data;

        public TwoColumnList(Panel p, List<Pair<Component, Component>> data) {
            super(p);
            Theme theme = this.getGui().getTheme();
            this.data = data;
            int widestL = 0;
            int widestR = 0;
            int h = 0;
            for (Pair<Component, Component> entry : data) {
                boolean header = ((Component)entry.getRight()).m_214077_().equals(ComponentContents.f_237124_);
                widestL = Math.max(widestL, theme.getStringWidth((FormattedText)entry.getLeft()));
                widestR = Math.max(widestR, theme.getStringWidth((FormattedText)entry.getRight()));
                h += theme.getFontHeight() + (header ? 3 : 1);
            }
            this.widestL = widestL;
            this.width = widestL + 10 + widestR;
            this.height = h;
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            int yPos = y;
            for (Pair<Component, Component> entry : this.data) {
                boolean header = ((Component)entry.getRight()).m_214077_().equals(ComponentContents.f_237124_);
                int xOff = header ? this.widestL + 10 : this.widestL - theme.getStringWidth((FormattedText)entry.getLeft()) - 2;
                theme.drawString(graphics, entry.getLeft(), x + xOff, yPos);
                theme.drawString(graphics, entry.getRight(), x + this.widestL + 10, yPos);
                yPos += theme.getFontHeight() + (header ? 3 : 1);
            }
        }
    }
}

