/*
 * Decompiled with CFR 0.150.
 */
package com.blakebr0.extendedcrafting.tile;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.extendedcrafting.block.BlockEnderAlternator;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.endercrafter.EnderCrafterRecipeManager;
import com.blakebr0.extendedcrafting.crafting.endercrafter.IEnderCraftingRecipe;
import com.blakebr0.extendedcrafting.crafting.table.TableCrafting;
import com.blakebr0.extendedcrafting.lib.IExtendedTable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

import java.util.ArrayList;
import java.util.List;

public class TileEnderCrafter extends StandardTable implements IInventory, ITickable, IExtendedTable {
    private int progress, progressReq;

    public TileEnderCrafter() {
        super(9);
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            TableCrafting crafting = getCrafting();
            IEnderCraftingRecipe recipe = EnderCrafterRecipeManager.getInstance().findMatchingRecipe(crafting,
                    this.getWorld());
            if(recipe == null)
                return;
            ItemStack result = ((IRecipe) recipe).getCraftingResult(crafting);
            ItemStack output = this.getResult();

            if (!result.isEmpty() && (output.isEmpty() || StackHelper.canCombineStacks(output, result))) {
                List<BlockPos> alternators = this.getAlternatorPositions();
                int alternatorCount = alternators.size();
                if (alternatorCount > 0) {
                    this.progress(alternatorCount, recipe.getEnderCrafterTimeSeconds());
                    for (BlockPos pos : alternators) {
                        if (pos == null) continue;
                        ((WorldServer) this.getWorld()).spawnParticle(EnumParticleTypes.PORTAL, false,
                                pos.getX() + 0.5, pos.getY() + 1.0, pos.getZ() + 0.5, 1,
                                0, 0, 0, 0.1);
                    }
                    if (this.progress >= this.progressReq) {
                        for (int i = 0; i < this.matrix.size(); ++i) {
                            this.decrStackSize(i, 1);
                        }
                        this.updateResult(result);
                        this.progress = 0;
                    }
                    this.markDirty();
                }
            } else if (this.progress > 0 || this.progressReq > 0) {
                this.progress = 0;
                this.progressReq = 0;
                this.markDirty();
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = super.writeToNBT(tag);
        tag.setInteger("Progress", this.progress);
        tag.setInteger("ProgressReq", this.progressReq);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.progress = tag.getInteger("Progress");
        this.progressReq = tag.getInteger("ProgressReq");
    }

    public void updateResult(ItemStack result) {
        if (this.result.isEmpty()) {
            this.setResult(result);
        } else {
            this.result.grow(result.getCount());
        }
    }

    public List<BlockPos> getAlternatorPositions() {
        ArrayList<BlockPos> alternators = new ArrayList<>();
        final World world = getWorld();
        for (BlockPos.MutableBlockPos aoePos : BlockPos.getAllInBoxMutable(this.getPos().add(-3, -3, -3), this.getPos().add(3, 3, 3))) {
            if (!(world.getBlockState(aoePos).getBlock() instanceof BlockEnderAlternator)) continue;
            alternators.add(world.isAirBlock(aoePos.move(EnumFacing.UP)) ? null : aoePos.toImmutable());
        }
        return alternators;
    }

    public int getProgress() {
        return this.progress;
    }

    private void progress(int alternators, int timeRequired) {
        ++this.progress;
        int timeReq = 20 * timeRequired;
        this.progressReq =
                (int) Math.max((float) timeReq - (float) timeReq * (ModConfig.confEnderAlternatorEff * (float) alternators), 20.0f);
    }

    public int getProgressRequired() {
        return this.progressReq;
    }
}

