/*
 * Decompiled with CFR 0.150.
 *
 * Could not load the following classes:
 *  com.blakebr0.cucumber.energy.EnergyStorageCustom
 *  com.blakebr0.cucumber.helper.StackHelper
 *  com.blakebr0.cucumber.util.VanillaPacketDispatcher
 *  net.minecraft.block.Block
 *  net.minecraft.entity.player.EntityPlayer
 *  net.minecraft.item.ItemStack
 *  net.minecraft.nbt.NBTTagCompound
 *  net.minecraft.network.NetworkManager
 *  net.minecraft.network.play.server.SPacketUpdateTileEntity
 *  net.minecraft.tileentity.TileEntity
 *  net.minecraft.util.EnumFacing
 *  net.minecraft.util.EnumParticleTypes
 *  net.minecraft.util.ITickable
 *  net.minecraft.util.math.BlockPos
 *  net.minecraft.world.WorldServer
 *  net.minecraftforge.common.capabilities.Capability
 *  net.minecraftforge.energy.CapabilityEnergy
 *  net.minecraftforge.items.CapabilityItemHandler
 *  net.minecraftforge.items.IItemHandlerModifiable
 *  net.minecraftforge.items.ItemStackHandler
 *  net.minecraftforge.oredict.OreDictionary
 */
package com.blakebr0.extendedcrafting.tile;

import com.blakebr0.cucumber.energy.EnergyStorageCustom;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.tile.TileEntityBase;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.CombinationRecipe;
import com.blakebr0.extendedcrafting.crafting.CombinationRecipeManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

import java.util.ArrayList;
import java.util.List;

public class TileCraftingCore extends TileEntityBase implements ITickable {
    private final ItemStackHandler inventory = new StackHandler(this, 1);
    private final EnergyStorageCustom energy = new EnergyStorageCustom(ModConfig.confCraftingCoreRFCapacity);
    private int progress;
    private int oldEnergy;
    private int pedestalCount;

    private static List<CombinationRecipe> getValidRecipes(ItemStack stack) {
        ArrayList<CombinationRecipe> valid = new ArrayList<>();
        if (!stack.isEmpty()) {
            for (CombinationRecipe recipe : CombinationRecipeManager.getInstance().getRecipes()) {
                ItemStack input = recipe.getInput();
                if (input.isEmpty() || !input.isItemEqual(stack) || !StackHelper.compareTags(input, stack))
                    continue;
                valid.add(recipe);
            }
        }
        return valid;
    }

    public void update() {
        boolean mark = false;
        final World world = this.getWorld();
        if (!world.isRemote) {

            final Object[] recipe0 = this.getRecipe0();
            if(recipe0 == null)
                return;

            CombinationRecipe recipe = (CombinationRecipe) recipe0[0];
            final BlockPos pos = this.getPos();
            if (this.getEnergy().getEnergyStored() > 0) {
                List<TilePedestal> pedestals = (List<TilePedestal>) recipe0[1];
                boolean done = this.process(recipe);
                if (done) {
                    for (TilePedestal pedestal : pedestals) {
                        pedestal.getInventory().extractItem(0, 1, false);

                        final BlockPos pos1 = pedestal.getPos();
                        ((WorldServer) world).spawnParticle(EnumParticleTypes.SMOKE_NORMAL, false,
                                (double) pos1.getX() + 0.5, (double) pos1.getY() + 1.1,
                                (double) pos1.getZ() + 0.5, 20, 0, 0, 0, 0.1);
                    }
                    ((WorldServer) world).spawnParticle(EnumParticleTypes.END_ROD, false,
                            (double) pos.getX() + 0.5, (double) pos.getY() + 1.1,
                            (double) pos.getZ() + 0.5, 50, 0, 0, 0, 0.1);
                    inventory.setStackInSlot(0, recipe.getOutput().copy());
                    this.progress = 0;
                    mark = true;
                } else {
                    ((WorldServer) world).spawnParticle(EnumParticleTypes.SPELL, false,
                            (double) pos.getX() + 0.5, (double) pos.getY() + 1.1,
                            (double) pos.getZ() + 0.5, 2, 0, 0, 0, 0.1);
                }
            }
        }
        if (this.oldEnergy != this.energy.getEnergyStored()) {
            this.oldEnergy = this.energy.getEnergyStored();
            if (!mark) {
                mark = true;
            }
        }
        if (mark) {
            this.markDirty();
        }
    }

    private List<TilePedestal> getPedestalsWithStuff(CombinationRecipe recipe) {
        ArrayList<Object> remaining = new ArrayList<>(recipe.getPedestalItems());

        ArrayList<TilePedestal> pedestals = new ArrayList<>();

        final World world = this.getWorld();

        Iterable<BlockPos.MutableBlockPos> blocks = BlockPos.getAllInBoxMutable(getPos().add(-3, 0, -3), getPos().add(3, 0, 3));
        block0:
        for (BlockPos pos : blocks) {
            TileEntity tile = world.getTileEntity(pos);
            if (!(tile instanceof TilePedestal)) continue;

            TilePedestal pedestal = (TilePedestal) tile;
            for (Object o : remaining) {
                boolean match = false;
                ItemStack stack = pedestal.getStack();
                if (o instanceof ItemStack) {
                    ItemStack nextStack = (ItemStack) o;
                    match = OreDictionary.itemMatches(nextStack, stack, false) && (!nextStack.hasTagCompound() || StackHelper.compareTags(nextStack, stack));
                } else if (o instanceof List) {
                    for (ItemStack stack1 : ((List<ItemStack>) o)) {
                        if(match = OreDictionary.itemMatches(stack1, stack, false)) {
                            break ;
                        }
                    }
                }
                if (!match) continue;
                pedestals.add(pedestal);
                remaining.remove(o);
                continue block0;
            }
        }
        if(pedestals.isEmpty())
            return null;
        this.pedestalCount = pedestals.size();
        if (pedestals.size() != recipe.getPedestalItems().size()) {
            return null;
        }
        if (!remaining.isEmpty()) {
            return null;
        }
        return pedestals;
    }

    private boolean process(CombinationRecipe recipe) {
        int extract = recipe.getPerTick();
        long difference = recipe.getCost() - (long) this.progress;
        if (difference < (long) recipe.getPerTick()) {
            extract = (int) difference;
        }
        int extracted = this.getEnergy().extractEnergy(extract, false);
        this.progress += extracted;
        return (long) this.progress >= recipe.getCost();
    }

    private Object[] getRecipe0() {
        List<CombinationRecipe> recipes = TileCraftingCore.getValidRecipes(this.getInventory().getStackInSlot(0));
        if (!recipes.isEmpty()) {
            for (CombinationRecipe recipe : recipes) {
                List<TilePedestal> pedestals = this.getPedestalsWithStuff(recipe);
                if (pedestals == null) continue;
                return new Object[] {
                        recipe, pedestals
                };
            }
        }
        return null;
    }

    public CombinationRecipe getRecipe() {
        final Object[] recipe0 = getRecipe0();
        return recipe0 == null ? null : (CombinationRecipe) recipe0[0];
    }

    public CombinationRecipe getRecipe(List<BlockPos> locations) {
        return getRecipe();
    }

    public int getProgress() {
        return this.progress;
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public EnergyStorageCustom getEnergy() {
        return this.energy;
    }

    public int getPedestalCount() {
        return this.pedestalCount;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.inventory.deserializeNBT(tag);
        this.progress = tag.getInteger("Progress");
        this.energy.setEnergy(tag.getInteger("Energy"));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = super.writeToNBT(tag);
        tag.merge(this.inventory.serializeNBT());
        tag.setInteger("Progress", this.progress);
        tag.setInteger("Energy", this.energy.getEnergyStored());
        return tag;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return this.getCapability(capability, side) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast(this.inventory);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.cast(this.energy);
        }
        return super.getCapability(capability, side);
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.getWorld().getTileEntity(this.getPos()) == this && player.getDistanceSq(this.getPos().add(0.5,
                0.5, 0.5)) <= 64;
    }
}

