package com.blakebr0.extendedcrafting.tile;

import com.blakebr0.cucumber.tile.TileEntityBase;
import com.blakebr0.extendedcrafting.crafting.table.TableCrafting;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeManager;
import com.blakebr0.extendedcrafting.lib.EmptyContainer;
import com.blakebr0.extendedcrafting.lib.IExtendedTable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

/**
 * This file is a part of MI <br>
 * 版权没有, 仿冒不究,如有雷同,纯属活该 <br>
 *
 * @author Roj233
 * @since 2020/11/25 12:38
 */
public abstract class StandardTable extends TileEntityBase implements IInventory, IExtendedTable {
    final NonNullList<ItemStack> matrix;
    final int matrixSize;
    String customName;
    ItemStack result = ItemStack.EMPTY;
    TableCrafting crafting;

    TableCrafting getCrafting() {
        if(crafting == null) {
             crafting = new TableCrafting(new EmptyContainer(), this);
        }
        return crafting;
    }

    protected StandardTable(int mat1rix) {
        this.matrix = NonNullList.withSize(mat1rix, ItemStack.EMPTY);
        this.matrixSize = (int) Math.sqrt(mat1rix);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = super.writeToNBT(tag);
        if (customName != null && !customName.isEmpty()) tag.setString("CustomName", customName);
        return ItemStackHelper.saveAllItems(tag, this.matrix, false);
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.customName = tag.getString("CustomName");
        ItemStackHelper.loadAllItems(tag, this.matrix);
        updateResult();
    }

    public final ItemStack getResult() { return this.result; }

    public final void setResult(ItemStack result) {
        this.result = result;
        if(getWorld().isRemote)
            markDirty();
    }

    public final void setInventorySlotContents(int slot, ItemStack stack) {
        this.matrix.set(slot, stack);
        updateResult();
    }

    private void updateResult() {
        setResult(isEmpty() ? ItemStack.EMPTY : TableRecipeManager.getInstance().findMatchingRecipe(getCrafting(), getWorld()));
    }

    public final NonNullList<ItemStack> getMatrix() { return this.matrix; }

    public final int getLineSize() { return matrixSize; }

    public final String getName() { return customName; }

    public final boolean hasCustomName() { return customName != null && !customName.isEmpty(); }

    public final int getSizeInventory() { return matrixSize * matrixSize; }

    public final boolean isEmpty() {
        if(result.isEmpty())
            for (ItemStack stack : matrix) {
                if(!stack.isEmpty())
                    return false;
            }
        return true;
    }

    public final ItemStack getStackInSlot(int index) { return this.matrix.get(index); }

    public final ItemStack decrStackSize(int index, int amount) {
        ItemStack stack = ItemStackHelper.getAndSplit(this.matrix, index, amount);
        if (!stack.isEmpty()) {
            updateResult();
        }
        return stack;
    }

    public final ItemStack removeStackFromSlot(int index) {
        ItemStack stack = ItemStackHelper.getAndRemove(this.matrix, index);
        if (!stack.isEmpty()) {
            updateResult();
        }
        return stack;
    }

    public final int getInventoryStackLimit() { return 64; }

    public final boolean isUsableByPlayer(EntityPlayer player) {
        double dist = player.getEntityAttribute(EntityPlayer.REACH_DISTANCE).getAttributeValue();
        return (getWorld().getTileEntity(getPos()) == this && player.getDistanceSq(getPos()) <= dist * dist);
    }

    public final void openInventory(EntityPlayer player) {}

    public final void closeInventory(EntityPlayer player) {}

    public boolean isItemValidForSlot(int index, ItemStack stack) { return false; }

    public final int getField(int id) { return 0; }

    public final void setField(int id, int value) {}

    public final int getFieldCount() { return 0; }

    public final void clear() {
        this.matrix.clear();
        updateResult();
    }
}
