package com.blakebr0.extendedcrafting.compat;

import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.block.*;
import com.blakebr0.extendedcrafting.block.craftingtable.BlockAdvancedTable;
import com.blakebr0.extendedcrafting.block.craftingtable.BlockBasicTable;
import com.blakebr0.extendedcrafting.block.craftingtable.BlockEliteTable;
import com.blakebr0.extendedcrafting.block.craftingtable.BlockUltimateTable;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.CombinationRecipe;
import com.blakebr0.extendedcrafting.crafting.CompressorRecipe;
import com.blakebr0.extendedcrafting.tile.*;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

import java.util.List;

public class WailaDataProvider implements IWailaDataProvider {
    public static void callbackRegister(IWailaRegistrar registrar) {
        final WailaDataProvider provider = new WailaDataProvider();
        registrar.registerBodyProvider(provider, BlockLamp.class);
        registrar.registerBodyProvider(provider, BlockTrimmed.class);
        registrar.registerBodyProvider(provider, BlockBasicTable.class);
        registrar.registerBodyProvider(provider, BlockAdvancedTable.class);
        registrar.registerBodyProvider(provider, BlockEliteTable.class);
        registrar.registerBodyProvider(provider, BlockUltimateTable.class);
        registrar.registerBodyProvider(provider, BlockPedestal.class);
        registrar.registerBodyProvider(provider, BlockCraftingCore.class);
        registrar.registerBodyProvider(provider, BlockAutomationInterface.class);
        registrar.registerBodyProvider(provider, BlockEnderCrafter.class);
        registrar.registerBodyProvider(provider, BlockCompressor.class);
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tooltip, IWailaDataAccessor data, IWailaConfigHandler config) {
        Block block = data.getBlock();
        TileEntity tile = data.getTileEntity();
        if (block instanceof BlockLamp)
            tooltip.add(Utils.localize("tooltip.ec.lamp_" + BlockLamp.Type.byMetadata(data.getMetadata()).getName()));
        else if (block instanceof BlockTrimmed)
            tooltip.add(Utils.localize("tooltip.ec.trimmed_" + BlockTrimmed.Type.byMetadata(data.getMetadata()).getName()));
        if(tile == null)
            return tooltip;
        if(tile.isInvalid()) return tooltip;

        if (tile instanceof TilePedestal) {
            TilePedestal pedestal = (TilePedestal) tile;
            ItemStack result = pedestal.getStack();
            if (!result.isEmpty()) tooltip.add(result.getDisplayName());
        }
        else if (tile instanceof TileCraftingCore) {
            TileCraftingCore core = (TileCraftingCore) tile;
            if (ModConfig.confEnergyInWaila) tooltip.add(Utils.format(core.getEnergy().getEnergyStored()) + " ME");
            CombinationRecipe recipe = core.getRecipe();
            if (recipe != null) {
                ItemStack output = recipe.getOutput();
                tooltip.add(Utils.localize("tooltip.ec.crafting", output.getCount(), output.getDisplayName()));
            }
        }
        else if (tile instanceof TileEnderCrafter) {
            TileEnderCrafter crafter = (TileEnderCrafter) tile;
            ItemStack result = crafter.getResult();
            if (!result.isEmpty())
                tooltip.add(Utils.localize("tooltip.ec.output", result.getCount(),
                        result.getDisplayName()));
        }
        else if(tile instanceof StandardTable) {
            int i = (((StandardTable) tile).getLineSize() - 1) >> 1;
            tooltip.add(Utils.localize("tooltip.ec.tier", i));
            tooltip.add("此Tile由Asyncorized_MC修复");
        }
        else if (tile instanceof TileAutomationInterface) {
            TileAutomationInterface auto = (TileAutomationInterface) tile;
            if (ModConfig.confEnergyInWaila)
                tooltip.add(Utils.format(auto.getEnergy().getEnergyStored()) + " ME");
            ItemStack result = auto.getResult();
            if (!result.isEmpty())
                tooltip.add(Utils.localize("tooltip.ec.crafting", result.getCount(),
                        result.getDisplayName()));
        }
        else if (tile instanceof TileCompressor) {
            TileCompressor compressor = (TileCompressor) tile;
            if (ModConfig.confEnergyInWaila)
                tooltip.add(Utils.format(compressor.getEnergy().getEnergyStored()) + " ME");
            CompressorRecipe recipe = compressor.getRecipe();
            if (recipe != null) {
                ItemStack output = recipe.getOutput();
                tooltip.add(Utils.localize("tooltip.ec.crafting", output.getCount(),
                        output.getDisplayName()));
            }
        }
        return tooltip;
    }
}
