/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.jei;

import javax.annotation.Nonnull;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.client.gui.component.input.GuiTextFieldExtended;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientLoadButtonsEvent;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientSearchFieldUpdateEvent;
import org.cyclops.integratedterminals.client.gui.container.GuiTerminalStorage;
import org.cyclops.integratedterminals.part.PartTypes;
import org.cyclops.integratedterminalscompat.modcompat.jei.JEIModCompat;
import org.cyclops.integratedterminalscompat.modcompat.jei.terminalstorage.TerminalStorageAdvancedGuiHandler;
import org.cyclops.integratedterminalscompat.modcompat.jei.terminalstorage.TerminalStorageRecipeTransferHandler;
import org.cyclops.integratedterminalscompat.modcompat.jei.terminalstorage.button.TerminalButtonItemStackCraftingGridJeiSearchSync;

@JEIPlugin
public class JEIIntegratedTerminalsConfig
implements IModPlugin {
    private IJeiRuntime jeiRuntime;

    public void register(@Nonnull IModRegistry registry) {
        if (JEIModCompat.canBeUsed) {
            registry.getRecipeTransferRegistry().addUniversalRecipeTransferHandler((IRecipeTransferHandler)new TerminalStorageRecipeTransferHandler(registry.getJeiHelpers().recipeTransferHandlerHelper()));
            registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new TerminalStorageAdvancedGuiHandler()});
            registry.addRecipeCatalyst((Object)new ItemStack(PartTypes.TERMINAL_STORAGE.getItem()), new String[]{"minecraft.crafting"});
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.jeiRuntime = jeiRuntime;
    }

    @SubscribeEvent
    public void onTerminalStorageButtons(TerminalStorageTabClientLoadButtonsEvent event) {
        event.getButtons().add(new TerminalButtonItemStackCraftingGridJeiSearchSync(event.getContainer().getGuiState(), event.getClientTab()));
    }

    protected boolean isSearchSynced(ITerminalStorageTabClient<?> clientTab) {
        for (ITerminalButton<?, ?, ?> button : clientTab.getButtons()) {
            if (!(button instanceof TerminalButtonItemStackCraftingGridJeiSearchSync)) continue;
            return ((TerminalButtonItemStackCraftingGridJeiSearchSync)button).isActive();
        }
        return false;
    }

    @SubscribeEvent
    public void onSearchFieldUpdated(TerminalStorageTabClientSearchFieldUpdateEvent event) {
        if (this.isSearchSynced(event.getClientTab())) {
            this.jeiRuntime.getIngredientFilter().setFilterText(event.getSearchString() + "");
        }
    }

    @SubscribeEvent
    public void onKeyTyped(GuiScreenEvent.KeyboardInputEvent.Post event) {
        if (event.getGui() instanceof GuiTerminalStorage) {
            GuiTerminalStorage gui = (GuiTerminalStorage)event.getGui();
            if (this.jeiRuntime.getIngredientListOverlay().hasKeyboardFocus()) {
                gui.getSelectedClientTab().ifPresent(tab -> {
                    if (this.isSearchSynced((ITerminalStorageTabClient<?>)tab)) {
                        GuiTextFieldExtended fieldSearch = gui.getFieldSearch();
                        fieldSearch.func_146180_a(this.jeiRuntime.getIngredientFilter().getFilterText());
                        tab.setInstanceFilter(gui.getContainer().getSelectedChannel(), fieldSearch.func_146179_b() + "");
                    }
                });
            }
        }
    }
}

