/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.part;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.part.PartStateEmpty;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.client.gui.container.GuiTerminalStorage;
import org.cyclops.integratedterminals.core.part.PartTypeTerminal;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorage;

public class PartTypeTerminalStorage
extends PartTypeTerminal<PartTypeTerminalStorage, State> {
    public PartTypeTerminalStorage(String name) {
        super(name);
    }

    public int getConsumptionRate(State state) {
        return GeneralConfig.terminalStorageBaseConsumption;
    }

    protected State constructDefaultState() {
        return new State();
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> getGui() {
        return GuiTerminalStorage.class;
    }

    public Class<? extends Container> getContainer() {
        return ContainerTerminalStorage.class;
    }

    public void addDrops(PartTarget target, State state, List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        for (Map.Entry<String, NonNullList<ItemStack>> entry : state.getNamedInventories().entrySet()) {
            if (entry.getKey().equals(TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString())) {
                entry.getValue().set(0, (Object)ItemStack.field_190927_a);
            }
            for (ItemStack itemStack : entry.getValue()) {
                if (itemStack.func_190926_b()) continue;
                itemStacks.add(itemStack);
            }
        }
        state.clearNamedInventories();
        super.addDrops(target, (IPartState)state, itemStacks, dropMainElement, saveState);
    }

    public static class State
    extends PartStateEmpty<PartTypeTerminalStorage> {
        private final Map<String, NonNullList<ItemStack>> namedInventories = Maps.newHashMap();

        public void clearNamedInventories() {
            this.namedInventories.clear();
        }

        public void setNamedInventory(String name, NonNullList<ItemStack> inventory) {
            this.namedInventories.put(name, inventory);
            this.onDirty();
        }

        public Map<String, NonNullList<ItemStack>> getNamedInventories() {
            return this.namedInventories;
        }

        @Nullable
        public NonNullList<ItemStack> getNamedInventory(String name) {
            return this.namedInventories.get(name);
        }

        public void loadNamedInventory(String name, IInventory inventory) {
            NonNullList<ItemStack> tabItems = this.getNamedInventory(name);
            if (tabItems != null) {
                for (int i = 0; i < tabItems.size(); ++i) {
                    inventory.func_70299_a(i, (ItemStack)tabItems.get(i));
                }
            }
        }

        public void saveNamedInventory(String name, IInventory inventory) {
            NonNullList latestItems = NonNullList.func_191196_a();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                latestItems.add((Object)inventory.func_70301_a(i));
            }
            this.setNamedInventory(name, (NonNullList<ItemStack>)latestItems);
        }

        public void writeToNBT(NBTTagCompound tag) {
            super.writeToNBT(tag);
            NBTTagList list = new NBTTagList();
            for (Map.Entry<String, NonNullList<ItemStack>> entry : this.namedInventories.entrySet()) {
                NBTTagCompound listEntry = new NBTTagCompound();
                listEntry.func_74778_a("tabName", entry.getKey());
                listEntry.func_74768_a("itemCount", entry.getValue().size());
                ItemStackHelper.func_191282_a((NBTTagCompound)listEntry, entry.getValue());
                list.func_74742_a((NBTBase)listEntry);
            }
            tag.func_74782_a("namedInventories", (NBTBase)list);
        }

        public void readFromNBT(NBTTagCompound tag) {
            super.readFromNBT(tag);
            for (NBTBase listEntry : tag.func_150295_c("namedInventories", 10)) {
                NonNullList list = NonNullList.func_191197_a((int)((NBTTagCompound)listEntry).func_74762_e("itemCount"), (Object)ItemStack.field_190927_a);
                String tabName = ((NBTTagCompound)listEntry).func_74779_i("tabName");
                ItemStackHelper.func_191283_b((NBTTagCompound)((NBTTagCompound)listEntry), (NonNullList)list);
                this.namedInventories.put(tabName, (NonNullList<ItemStack>)list);
            }
        }
    }
}

