/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.api.terminalstorage.TerminalClickType;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorage;

public class TerminalStorageIngredientSlotClickPacket<T>
extends PacketCodec {
    @CodecField
    private String tabId;
    @CodecField
    private String ingredientName;
    @CodecField
    private int clickType;
    @CodecField
    private int channel;
    @CodecField
    private NBTTagCompound hoveringStorageInstanceData;
    @CodecField
    private int hoveredContainerSlot;
    @CodecField
    private long moveQuantityPlayerSlot;
    @CodecField
    private NBTTagCompound activeStorageInstanceData;
    @CodecField
    private boolean transferFullSelection;

    public TerminalStorageIngredientSlotClickPacket() {
    }

    public TerminalStorageIngredientSlotClickPacket(String tabId, IngredientComponent<T, ?> component, TerminalClickType clickType, int channel, T hoveringStorageInstance, int hoveredContainerSlot, long moveQuantityPlayerSlot, T activeStorageInstance, boolean transferFullSelection) {
        this.tabId = tabId;
        this.clickType = clickType.ordinal();
        this.ingredientName = component.getName().toString();
        this.channel = channel;
        this.hoveringStorageInstanceData = new NBTTagCompound();
        IIngredientSerializer serializer = this.getComponent().getSerializer();
        this.hoveringStorageInstanceData.func_74782_a("i", serializer.serializeInstance(hoveringStorageInstance));
        this.hoveredContainerSlot = hoveredContainerSlot;
        this.moveQuantityPlayerSlot = moveQuantityPlayerSlot;
        this.activeStorageInstanceData = new NBTTagCompound();
        this.activeStorageInstanceData.func_74782_a("i", serializer.serializeInstance(activeStorageInstance));
        this.transferFullSelection = transferFullSelection;
    }

    public boolean isAsync() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
    }

    public void actionServer(World world, EntityPlayerMP player) {
        if (player.field_71070_bA instanceof ContainerTerminalStorage) {
            ContainerTerminalStorage container = (ContainerTerminalStorage)player.field_71070_bA;
            TerminalStorageTabIngredientComponentServer tab = (TerminalStorageTabIngredientComponentServer)container.getTabServer(this.tabId);
            IIngredientSerializer serializer = this.getComponent().getSerializer();
            Object hoveringStorageInstance = serializer.deserializeInstance(this.hoveringStorageInstanceData.func_74781_a("i"));
            Object activeInstance = serializer.deserializeInstance(this.activeStorageInstanceData.func_74781_a("i"));
            tab.handleStorageSlotClick((Container)container, player, this.getClickType(), this.getChannel(), hoveringStorageInstance, this.hoveredContainerSlot, this.moveQuantityPlayerSlot, activeInstance, this.transferFullSelection);
        }
    }

    public TerminalClickType getClickType() {
        return TerminalClickType.values()[this.clickType];
    }

    public IngredientComponent<T, ?> getComponent() {
        IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(this.ingredientName));
        if (ingredientComponent == null) {
            throw new IllegalArgumentException("No ingredient component with the given name was found: " + this.ingredientName);
        }
        return ingredientComponent;
    }

    public int getChannel() {
        return this.channel;
    }
}

