/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;

public abstract class TerminalStorageIngredientCraftingOptionDataPacketAbstract<T, M>
extends PacketCodec {
    @CodecField
    private String ingredientComponent;
    @CodecField
    private BlockPos pos;
    @CodecField
    private EnumFacing side;
    @CodecField
    private String tabName;
    @CodecField
    private int channel;
    @CodecField
    private NBTTagCompound craftingOption;
    @CodecField
    private int amount;
    @CodecField
    private NBTTagCompound craftingPlan;

    public TerminalStorageIngredientCraftingOptionDataPacketAbstract() {
    }

    public TerminalStorageIngredientCraftingOptionDataPacketAbstract(CraftingOptionGuiData<T, M> craftingOptionData) {
        this.ingredientComponent = craftingOptionData.getComponent().getName().toString();
        this.pos = craftingOptionData.getPos();
        this.side = craftingOptionData.getSide();
        this.tabName = craftingOptionData.getTabName();
        this.channel = craftingOptionData.getChannel();
        this.craftingOption = craftingOptionData.getCraftingOption() != null ? HandlerWrappedTerminalCraftingOption.serialize(craftingOptionData.getCraftingOption()) : new NBTTagCompound();
        this.amount = craftingOptionData.getAmount();
        this.craftingPlan = craftingOptionData.getCraftingPlan() != null ? HandlerWrappedTerminalCraftingPlan.serialize(craftingOptionData.getCraftingPlan()) : new NBTTagCompound();
    }

    public boolean isAsync() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
    }

    @Nullable
    protected HandlerWrappedTerminalCraftingOption<T> getCraftingOption(IngredientComponent<T, M> ingredientComponent) {
        try {
            return HandlerWrappedTerminalCraftingOption.deserialize(ingredientComponent, this.craftingOption);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    protected HandlerWrappedTerminalCraftingPlan getCraftingPlan() {
        try {
            return HandlerWrappedTerminalCraftingPlan.deserialize(this.craftingPlan);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public IngredientComponent<T, M> getIngredientComponent() {
        IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(this.ingredientComponent));
        if (component == null) {
            throw new IllegalArgumentException("Could not find the ingredient component type " + this.ingredientComponent);
        }
        return component;
    }

    public int getChannel() {
        return this.channel;
    }

    public String getTabName() {
        return this.tabName;
    }

    public int getAmount() {
        return this.amount;
    }

    public CraftingOptionGuiData<T, M> getCraftingOptionData() {
        IngredientComponent<T, M> ingredientComponent = this.getIngredientComponent();
        return new CraftingOptionGuiData<T, M>(this.pos, this.side, ingredientComponent, this.tabName, this.channel, this.getCraftingOption(ingredientComponent), this.amount, this.getCraftingPlan());
    }
}

