/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingJobGuiData;
import org.cyclops.integratedterminals.proxy.guiprovider.GuiProviders;

public class ContainerTerminalCraftingJobsPlan
extends ExtendedInventoryContainer {
    private final World world;
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final IPartType partType;
    private final CraftingJobGuiData craftingJobGuiData;
    private final int craftingPlanNotifierId;
    private long lastUpdate;
    @Nullable
    private ITerminalCraftingPlan craftingPlan;

    public ContainerTerminalCraftingJobsPlan(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType, CraftingJobGuiData craftingJobGuiData) {
        super(player.field_71071_by, GuiProviders.GUI_TERMINAL_STORAGE_CRAFTNG_PLAN);
        this.world = target.getCenter().getPos().getWorld();
        this.target = target;
        this.partContainer = partContainer;
        this.partType = partType;
        this.craftingJobGuiData = craftingJobGuiData;
        this.craftingPlanNotifierId = this.getNextValueId();
    }

    public CraftingJobGuiData getCraftingJobGuiData() {
        return this.craftingJobGuiData;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    @Nullable
    public ITerminalCraftingPlan getCraftingPlan() {
        return this.craftingPlan;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.world.field_72995_K && this.lastUpdate < System.currentTimeMillis()) {
            this.lastUpdate = System.currentTimeMillis() + (long)GeneralConfig.guiTerminalCraftingJobsUpdateFrequency;
            this.updateCraftingPlan();
        }
    }

    public int getCraftingPlanNotifierId() {
        return this.craftingPlanNotifierId;
    }

    protected void updateCraftingPlan() {
        INetwork network = NetworkHelpers.getNetwork((PartPos)this.target.getCenter());
        this.craftingPlan = this.craftingJobGuiData.getHandler().getCraftingJob(network, this.craftingJobGuiData.getChannel(), this.craftingJobGuiData.getCraftingJob());
        if (this.craftingPlan != null) {
            this.setValue(this.craftingPlanNotifierId, this.craftingJobGuiData.getHandler().serializeCraftingPlan(this.craftingPlan));
        } else {
            this.setValue(this.craftingPlanNotifierId, new NBTTagCompound());
        }
    }

    protected int getSizeInventory() {
        return 0;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public void onUpdate(int valueId, NBTTagCompound value) {
        if (valueId == this.craftingPlanNotifierId) {
            try {
                this.craftingPlan = this.craftingJobGuiData.getHandler().deserializeCraftingPlan(value);
            }
            catch (IllegalArgumentException e) {
                this.craftingPlan = null;
            }
        }
        super.onUpdate(valueId, value);
    }
}

