/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.slot;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;
import org.cyclops.integratedterminals.client.gui.container.GuiTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.core.terminalstorage.slot.TerminalStorageSlotIngredient;

public class TerminalStorageSlotIngredientCraftingOption<T, M>
extends TerminalStorageSlotIngredient<T, M> {
    private final HandlerWrappedTerminalCraftingOption<T> craftingOption;

    public TerminalStorageSlotIngredientCraftingOption(IIngredientComponentTerminalStorageHandler<T, M> ingredientComponentViewHandler, T instance, HandlerWrappedTerminalCraftingOption<T> craftingOption) {
        super(ingredientComponentViewHandler, instance);
        this.craftingOption = craftingOption;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerLayer(GuiContainer gui, GuiTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, ITerminalStorageTabClient tab, int channel, @Nullable String label) {
        IIngredientComponentTerminalStorageHandler viewHandler = this.getIngredientComponentViewHandler();
        if (layer == GuiTerminalStorage.DrawLayer.BACKGROUND) {
            long maxQuantity = ((TerminalStorageTabIngredientComponentClient)tab).getMaxQuantity(channel);
            viewHandler.drawInstance(this.getInstance(), maxQuantity, null, gui, layer, partialTick, x, y, mouseX, mouseY, null);
            this.drawCraftLabel(x, y);
        } else {
            long maxQuantity = ((TerminalStorageTabIngredientComponentClient)tab).getMaxQuantity(channel);
            this.getIngredientComponentViewHandler().drawInstance(this.getInstance(), maxQuantity, label, gui, layer, partialTick, x, y, mouseX, mouseY, this.getTooltipLines());
        }
    }

    protected List<String> getTooltipLines() {
        ArrayList tooltipLines = Lists.newArrayList();
        tooltipLines.add(TextFormatting.YELLOW + L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.tooltip.requirements", (Object[])new Object[0]));
        ITerminalCraftingOption<T> option = this.getCraftingOption().getCraftingOption();
        for (IngredientComponent<?, ?> inputComponent : option.getInputComponents()) {
            IIngredientMatcher matcher = inputComponent.getMatcher();
            for (Object inputInstance : option.getInputs(inputComponent)) {
                if (matcher.isEmpty(inputInstance)) continue;
                tooltipLines.add(String.format("%s- %s (%s)", TextFormatting.GRAY, matcher.localize(inputInstance), matcher.getQuantity(inputInstance)));
            }
        }
        return tooltipLines;
    }

    public HandlerWrappedTerminalCraftingOption<T> getCraftingOption() {
        return this.craftingOption;
    }

    private void drawCraftLabel(int x, int y) {
        RenderItemExtendedSlotCount.drawSlotText((FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)(TextFormatting.GOLD + L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.craft", (Object[])new Object[0])), (int)x, (int)(y - 11));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
    }
}

