/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.button;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonImage;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridSetAutoRefill;

public class TerminalButtonItemStackCraftingGridAutoRefill<T>
implements ITerminalButton<TerminalStorageTabIngredientComponentClient<T, ?>, TerminalStorageTabIngredientComponentItemStackCraftingCommon, GuiButtonImage> {
    private final TerminalStorageState state;
    private final String buttonName;
    private AutoRefillType active;

    public TerminalButtonItemStackCraftingGridAutoRefill(TerminalStorageState state, ITerminalStorageTabClient<?> clientTab) {
        this.state = state;
        this.buttonName = "itemstack_grid_autorefill";
        if (state.hasButton(clientTab.getName().toString(), this.buttonName)) {
            NBTTagCompound data = (NBTTagCompound)state.getButton(clientTab.getName().toString(), this.buttonName);
            this.active = AutoRefillType.values()[data.func_74762_e("active")];
        } else {
            this.active = AutoRefillType.STORAGE;
        }
        this.notifyServer((TerminalStorageTabIngredientComponentClient)clientTab);
    }

    protected void notifyServer(TerminalStorageTabIngredientComponentClient<T, ?> clientTab) {
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridSetAutoRefill(clientTab.getName().toString(), this.active));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiButtonImage createButton(int x, int y) {
        return new GuiButtonImage(0, x, y, new IImage[]{this.active == AutoRefillType.DISABLED ? Images.BUTTON_BACKGROUND_INACTIVE : Images.BUTTON_BACKGROUND_ACTIVE, this.active.getImage()});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(TerminalStorageTabIngredientComponentClient<T, ?> clientTab, TerminalStorageTabIngredientComponentItemStackCraftingCommon commomTab, GuiButtonImage guiButton, int channel, int mouseButton) {
        this.active = mouseButton == 0 ? AutoRefillType.values()[(this.active.ordinal() + 1) % AutoRefillType.values().length] : AutoRefillType.DISABLED;
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("active", this.active.ordinal());
        this.state.setButton(clientTab.getName().toString(), this.buttonName, (NBTBase)data);
        this.notifyServer(clientTab);
    }

    @Override
    public String getTranslationKey() {
        return "gui.integratedterminals.terminal_storage.craftinggrid.autorefill";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getTooltip(EntityPlayer player, ITooltipFlag tooltipFlag, List<String> lines) {
        lines.add(L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.craftinggrid.autorefill.info", (Object[])new Object[0]));
        lines.add(L10NHelpers.localize((String)this.active.getLabel(), (Object[])new Object[0]));
    }

    public static enum AutoRefillType {
        DISABLED((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_DISABLED, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.disabled"),
        STORAGE((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_STORAGE, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.storage"),
        PLAYER((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_PLAYER, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.player"),
        STORAGE_PLAYER((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_STORAGEPLAYER, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.storage_player"),
        PLAYER_STORAGE((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_PLAYERSTORAGE, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.player_storage");

        @Nullable
        private final IImage image;
        private final String label;

        private AutoRefillType(IImage image, String label) {
            this.image = image;
            this.label = label;
        }

        @Nullable
        public IImage getImage() {
            return this.image;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

