/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridAutoRefill;
import org.cyclops.integratedterminals.inventory.InventoryCraftingDirtyable;
import org.cyclops.integratedterminals.inventory.SlotCraftingAutoRefill;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorage;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridSetResult;
import org.cyclops.integratedterminals.part.PartTypeTerminalStorage;

public class TerminalStorageTabIngredientComponentItemStackCraftingCommon
extends TerminalStorageTabIngredientComponentCommon<ItemStack, Integer> {
    private InventoryCrafting inventoryCrafting;
    private InventoryCraftResult inventoryCraftResult;
    private SlotCrafting slotCrafting;
    private List<Slot> slots;
    private TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType autoRefill = TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType.STORAGE;

    public TerminalStorageTabIngredientComponentItemStackCraftingCommon(ContainerTerminalStorage containerTerminalStorage, ResourceLocation name, IngredientComponent<ItemStack, Integer> ingredientComponent) {
        super(containerTerminalStorage, name, ingredientComponent);
    }

    public static int getCraftingResultSlotIndex(Container container, ResourceLocation name) {
        ITerminalStorageTabCommon tabCommon = ((ContainerTerminalStorage)container).getTabCommon(name.toString());
        TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabCommon;
        return tabCommonCrafting.getSlotCrafting().field_75222_d;
    }

    @Override
    public List<Slot> loadSlots(Container container, int startIndex, EntityPlayer player, PartTypeTerminalStorage.State partState) {
        this.slots = Lists.newArrayListWithCapacity((int)10);
        final IDirtyMarkListener dirtyListener = () -> this.updateCraftingResult(player, container, partState);
        this.inventoryCraftResult = new InventoryCraftResult(){

            public void func_70296_d() {
                dirtyListener.onDirty();
                super.func_70296_d();
            }
        };
        this.inventoryCrafting = new InventoryCraftingDirtyable(container, 3, 3, dirtyListener);
        this.slotCrafting = new SlotCraftingAutoRefill(player, this.inventoryCrafting, (IInventory)this.inventoryCraftResult, 0, 115, 76, this, (TerminalStorageTabIngredientComponentServer)((ContainerTerminalStorage)container).getTabServer(this.getName().toString()), (ContainerTerminalStorage)container);
        this.slots.add((Slot)this.slotCrafting);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.slots.add(new Slot((IInventory)this.inventoryCrafting, j + i * 3, 31 + j * 18, 58 + i * 18));
            }
        }
        NonNullList<ItemStack> tabItems = partState.getNamedInventory(this.getName().toString());
        if (tabItems != null) {
            int i = 0;
            for (ItemStack tabItem : tabItems) {
                if (i == 0) {
                    this.inventoryCraftResult.func_70299_a(i++, tabItem);
                    continue;
                }
                this.inventoryCrafting.func_70299_a(i++ - 1, tabItem);
            }
        }
        ArrayList returnSlots = Lists.newArrayList(this.slots);
        for (Triple<Slot, Integer, Integer> slot : ((ContainerTerminalStorage)container).getTabSlots(this.ingredientComponent.getName().toString())) {
            returnSlots.add(slot.getLeft());
        }
        return returnSlots;
    }

    public InventoryCrafting getInventoryCrafting() {
        return this.inventoryCrafting;
    }

    public InventoryCraftResult getInventoryCraftResult() {
        return this.inventoryCraftResult;
    }

    public SlotCrafting getSlotCrafting() {
        return this.slotCrafting;
    }

    public TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType getAutoRefill() {
        return this.autoRefill;
    }

    public void setAutoRefill(TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType autoRefill) {
        this.autoRefill = autoRefill;
    }

    public void updateCraftingResult(EntityPlayer player, Container container, PartTypeTerminalStorage.State partState) {
        if (!player.field_70170_p.field_72995_K) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)player;
            ItemStack itemstack = ItemStack.field_190927_a;
            IRecipe recipe = CraftingHelpers.findMatchingRecipeCached((InventoryCrafting)this.inventoryCrafting, (World)player.field_70170_p, (boolean)false);
            if (recipe != null && (recipe.func_192399_d() || !player.field_70170_p.func_82736_K().func_82766_b("doLimitedCrafting") || entityplayermp.func_192037_E().func_193830_f(recipe))) {
                this.inventoryCraftResult.func_193056_a(recipe);
                itemstack = recipe.func_77572_b(this.inventoryCrafting);
            }
            this.inventoryCraftResult.func_70299_a(0, itemstack);
            IntegratedTerminals._instance.getPacketHandler().sendToPlayer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridSetResult(this.getName().toString(), itemstack), (EntityPlayerMP)player);
        }
        NonNullList latestItems = NonNullList.func_191196_a();
        for (Slot slot : this.slots) {
            latestItems.add((Object)slot.func_75211_c());
        }
        partState.setNamedInventory(this.getName().toString(), (NonNullList<ItemStack>)latestItems);
    }
}

