/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.client.gui.container.GuiTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridAutoRefill;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridBalance;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridClear;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorage;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridShiftClickOutput;
import org.lwjgl.input.Keyboard;

public class TerminalStorageTabIngredientComponentItemStackCraftingClient
extends TerminalStorageTabIngredientComponentClient<ItemStack, Integer> {
    private final ItemStack icon = new ItemStack(Blocks.field_150462_ai);

    public TerminalStorageTabIngredientComponentItemStackCraftingClient(ContainerTerminalStorage container, ResourceLocation name, IngredientComponent<?, ?> ingredientComponent) {
        super(container, name, ingredientComponent);
    }

    @Override
    protected void loadButtons(List<ITerminalButton<?, ?, ?>> buttons) {
        super.loadButtons(buttons);
        buttons.add(new TerminalButtonItemStackCraftingGridAutoRefill(this.container.getGuiState(), this));
        buttons.add(new TerminalButtonItemStackCraftingGridClear());
        buttons.add(new TerminalButtonItemStackCraftingGridBalance());
    }

    @Override
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public List<String> getTooltip() {
        return Lists.newArrayList((Object[])new String[]{L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.crafting_name", (Object[])new Object[]{L10NHelpers.localize((String)this.ingredientComponent.getTranslationKey(), (Object[])new Object[0])})});
    }

    @Override
    public int getSlotOffsetX() {
        return 139;
    }

    @Override
    public int getSlotRowLength() {
        return 3;
    }

    @Override
    @Nullable
    public ResourceLocation getBackgroundTexture() {
        return new ResourceLocation("integratedterminals", (String)IntegratedTerminals._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + "part_terminal_storage_crafting.png");
    }

    @Override
    public boolean handleClick(Container container, int channel, int hoveringStorageSlot, int mouseButton, boolean hasClickedOutside, boolean hasClickedInStorage, int hoveredContainerSlot) {
        boolean shift;
        int craftingResultSlotIndex = TerminalStorageTabIngredientComponentItemStackCraftingCommon.getCraftingResultSlotIndex(container, this.getName());
        boolean bl = shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        if (hoveredContainerSlot == craftingResultSlotIndex && shift) {
            IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridShiftClickOutput(this.getName().toString(), channel));
            return true;
        }
        if (hoveredContainerSlot > craftingResultSlotIndex && hoveredContainerSlot <= craftingResultSlotIndex + 9 && this.getActiveSlotId() < 0) {
            return false;
        }
        return super.handleClick(container, channel, hoveringStorageSlot, mouseButton, hasClickedOutside, hasClickedInStorage, hoveredContainerSlot);
    }

    @Override
    public void onCommonSlotRender(GuiContainer gui, GuiTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, int slot, ITerminalStorageTabCommon tabCommon) {
        String name = this.ingredientComponent.getName().toString();
        ITerminalStorageTabClient tabClient = this.container.getTabClient(name);
        tabCommon = this.container.getTabCommon(name);
        tabClient.onCommonSlotRender(gui, layer, partialTick, x, y, mouseX, mouseY, slot, tabCommon);
    }
}

