/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.part.event.PartVariableDrivenVariableContentsUpdatedEvent;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorage;
import org.cyclops.integratedterminals.part.PartTypeTerminalStorage;

public class TerminalStorageTabIngredientComponentCommon<T, M>
implements ITerminalStorageTabCommon,
IVariableFacade.IValidator {
    private final ContainerTerminalStorage containerTerminalStorage;
    private final ResourceLocation name;
    protected final IngredientComponent<T, M> ingredientComponent;
    private final int errorsValueId;
    private SimpleInventory inventory = null;
    private boolean dirtyInv;
    private final List<InventoryVariableEvaluator<ValueTypeOperator.ValueOperator>> variableEvaluators = Lists.newArrayList();
    private final List<IVariable<ValueTypeOperator.ValueOperator>> variables = Lists.newArrayList();
    private int variableSlotNumberStart;
    private int variableSlotNumberEnd;

    public TerminalStorageTabIngredientComponentCommon(ContainerTerminalStorage containerTerminalStorage, ResourceLocation name, IngredientComponent<T, M> ingredientComponent) {
        this.containerTerminalStorage = containerTerminalStorage;
        this.name = name;
        this.ingredientComponent = ingredientComponent;
        this.errorsValueId = containerTerminalStorage.getNextValueId();
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public List<Slot> loadSlots(Container container, int startIndex, EntityPlayer player, PartTypeTerminalStorage.State partState) {
        ArrayList slots = Lists.newArrayList();
        this.variableSlotNumberStart = startIndex;
        this.inventory = new SimpleInventory(3, "inv", 1);
        partState.loadNamedInventory(this.getName().toString(), (IInventory)this.inventory);
        this.variableEvaluators.clear();
        int i = 0;
        while (i < this.inventory.func_70302_i_()) {
            final int slot = i++;
            this.variableEvaluators.add(new InventoryVariableEvaluator<ValueTypeOperator.ValueOperator>((IInventory)this.inventory, slot, (IValueType)ValueTypes.OPERATOR){

                public void onErrorsChanged() {
                    super.onErrorsChanged();
                    TerminalStorageTabIngredientComponentCommon.this.setLocalErrors(slot, this.getErrors());
                }
            });
        }
        this.variableSlotNumberEnd = startIndex + this.inventory.func_70302_i_();
        this.inventory.addDirtyMarkListener(() -> {
            this.dirtyInv = true;
        });
        slots.add(new SlotVariable((IInventory)this.inventory, 0, 201, 136));
        slots.add(new SlotVariable((IInventory)this.inventory, 1, 201, 154));
        slots.add(new SlotVariable((IInventory)this.inventory, 2, 201, 172));
        this.dirtyInv = true;
        return slots;
    }

    public int getVariableSlotNumberStart() {
        return this.variableSlotNumberStart;
    }

    public int getVariableSlotNumberEnd() {
        return this.variableSlotNumberEnd;
    }

    @Override
    public void onUpdate(Container container, EntityPlayer player, PartTypeTerminalStorage.State partState) {
        if (this.dirtyInv && !player.field_70170_p.field_72995_K) {
            this.dirtyInv = false;
            ContainerTerminalStorage containerTerminalStorage = (ContainerTerminalStorage)container;
            partState.saveNamedInventory(this.getName().toString(), (IInventory)this.inventory);
            INetwork network = NetworkHelpers.getNetwork((PartPos)containerTerminalStorage.getTarget().getCenter());
            this.clearGlobalErrors();
            this.variables.clear();
            if (network == null) {
                this.addError(new L10NHelpers.UnlocalizedString("general.integrateddynamics.error.no_network", new Object[0]));
            } else {
                for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                    InventoryVariableEvaluator<ValueTypeOperator.ValueOperator> evaluator = this.variableEvaluators.get(i);
                    evaluator.refreshVariable(network, false);
                    IVariable variable = evaluator.getVariable(network);
                    if (variable != null) {
                        variable.addInvalidationListener(() -> this.inventory.func_70296_d());
                        this.variables.add((IVariable<ValueTypeOperator.ValueOperator>)variable);
                    }
                    try {
                        IPartNetwork partNetwork = NetworkHelpers.getPartNetwork((INetwork)network);
                        MinecraftForge.EVENT_BUS.post((Event)new PartVariableDrivenVariableContentsUpdatedEvent(network, partNetwork, containerTerminalStorage.getTarget(), (IPartType)containerTerminalStorage.getPartType(), (IPartState)partState, player, variable, variable != null ? variable.getValue() : null));
                        continue;
                    }
                    catch (EvaluationException evaluationException) {
                        // empty catch block
                    }
                }
            }
            TerminalStorageTabIngredientComponentServer tabServer = (TerminalStorageTabIngredientComponentServer)containerTerminalStorage.getTabServer(this.getName().toString());
            tabServer.updateFilter(this.variables, this);
            tabServer.reApplyFilter();
        }
    }

    public void addError(L10NHelpers.UnlocalizedString error) {
        List<L10NHelpers.UnlocalizedString> errors = this.getGlobalErrors();
        errors.add(error);
        NBTTagCompound tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        tag = tag == null ? new NBTTagCompound() : tag.func_74737_b();
        NBTClassType.writeNbt(List.class, (String)(this.getName().toString() + ":globalErrors"), errors, (NBTTagCompound)tag);
        this.containerTerminalStorage.setValue(this.errorsValueId, tag);
    }

    public List<L10NHelpers.UnlocalizedString> getGlobalErrors() {
        NBTTagCompound tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        if (tag == null) {
            return Lists.newArrayList();
        }
        return (List)NBTClassType.readNbt(List.class, (String)(this.getName().toString() + ":globalErrors"), (NBTTagCompound)tag);
    }

    public void clearGlobalErrors() {
        NBTTagCompound tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        tag = tag == null ? new NBTTagCompound() : tag.func_74737_b();
        NBTClassType.writeNbt(List.class, (String)(this.getName().toString() + ":globalErrors"), (Object)Lists.newArrayList(), (NBTTagCompound)tag);
        this.containerTerminalStorage.setValue(this.errorsValueId, tag);
    }

    public void setLocalErrors(int slot, List<L10NHelpers.UnlocalizedString> errors) {
        NBTTagCompound tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        tag = tag == null ? new NBTTagCompound() : tag.func_74737_b();
        NBTClassType.writeNbt(List.class, (String)(this.getName().toString() + ":localErrors" + slot), errors, (NBTTagCompound)tag);
        this.containerTerminalStorage.setValue(this.errorsValueId, tag);
    }

    public List<L10NHelpers.UnlocalizedString> getLocalErrors(int slot) {
        NBTTagCompound tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        if (tag == null) {
            return Lists.newArrayList();
        }
        return (List)NBTClassType.readNbt(List.class, (String)(this.getName().toString() + ":localErrors" + slot), (NBTTagCompound)tag);
    }

    public boolean hasErrors() {
        return !this.getGlobalErrors().isEmpty();
    }
}

