/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientArrayList;
import org.cyclops.cyclopscore.ingredient.collection.diff.IngredientCollectionDiff;
import org.cyclops.cyclopscore.ingredient.collection.diff.IngredientCollectionDiffHelpers;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.api.terminalstorage.TerminalClickType;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientLoadButtonsEvent;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientSearchFieldUpdateEvent;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerConfig;
import org.cyclops.integratedterminals.client.gui.container.GuiTerminalStorage;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.core.client.gui.ExtendedGuiHandler;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentCommon;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonFilterCrafting;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonSort;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;
import org.cyclops.integratedterminals.core.terminalstorage.query.IIngredientQuery;
import org.cyclops.integratedterminals.core.terminalstorage.slot.TerminalStorageSlotIngredient;
import org.cyclops.integratedterminals.core.terminalstorage.slot.TerminalStorageSlotIngredientCraftingOption;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorage;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientOpenCraftingJobAmountGuiPacket;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientOpenCraftingPlanGuiPacket;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientSlotClickPacket;
import org.lwjgl.input.Keyboard;

public class TerminalStorageTabIngredientComponentClient<T, M>
implements ITerminalStorageTabClient<TerminalStorageSlotIngredient<T, M>> {
    private final ResourceLocation name;
    protected final IngredientComponent<T, M> ingredientComponent;
    private final IIngredientComponentTerminalStorageHandler<T, M> ingredientComponentViewHandler;
    private final ItemStack icon;
    protected final ContainerTerminalStorage container;
    private final List<ITerminalButton<?, ?, ?>> buttons;
    private final Int2ObjectMap<List<InstanceWithMetadata<T>>> ingredientsViews;
    private final Int2ObjectMap<List<InstanceWithMetadata<T>>> filteredIngredientsViews;
    private final Int2ObjectMap<Collection<HandlerWrappedTerminalCraftingOption<T>>> craftingOptions;
    private final Int2LongMap maxQuantities;
    private final Int2LongMap totalQuantities;
    private final IntSet channels;
    private boolean enabled;
    private int activeSlotId;
    private int activeSlotQuantity;
    private int activeChannel;

    @SubscribeEvent
    public static void onToolTip(ItemTooltipEvent event) {
        IIngredientComponentTerminalStorageHandler handler;
        Object instance;
        ContainerTerminalStorage container;
        ITerminalStorageTabClient<?> tab;
        if (event.getEntityPlayer() != null && event.getEntityPlayer().field_71070_bA instanceof ContainerTerminalStorage && (tab = (container = (ContainerTerminalStorage)event.getEntityPlayer().field_71070_bA).getTabsClient().get(container.getSelectedTab())) instanceof TerminalStorageTabIngredientComponentClient && !((instance = (handler = ((TerminalStorageTabIngredientComponentClient)tab).ingredientComponentViewHandler).getInstance(event.getItemStack())) instanceof ItemStack)) {
            handler.addQuantityTooltip(event.getToolTip(), instance);
        }
    }

    public TerminalStorageTabIngredientComponentClient(ContainerTerminalStorage container, ResourceLocation name, IngredientComponent<?, ?> ingredientComponent) {
        this.name = name;
        this.ingredientComponent = ingredientComponent;
        this.ingredientComponentViewHandler = (IIngredientComponentTerminalStorageHandler)Objects.requireNonNull(this.ingredientComponent.getCapability(IngredientComponentTerminalStorageHandlerConfig.CAPABILITY));
        this.icon = this.ingredientComponentViewHandler.getIcon();
        this.container = container;
        ArrayList buttons = Lists.newArrayList();
        this.loadButtons(buttons);
        TerminalStorageTabClientLoadButtonsEvent event = new TerminalStorageTabClientLoadButtonsEvent(container, this, buttons);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.buttons = event.getButtons();
        this.ingredientsViews = new Int2ObjectOpenHashMap();
        this.filteredIngredientsViews = new Int2ObjectOpenHashMap();
        this.craftingOptions = new Int2ObjectOpenHashMap();
        this.maxQuantities = new Int2LongOpenHashMap();
        this.totalQuantities = new Int2LongOpenHashMap();
        this.enabled = false;
        this.channels = new IntOpenHashSet();
        this.resetActiveSlot();
    }

    protected void loadButtons(List<ITerminalButton<?, ?, ?>> buttons) {
        for (IIngredientInstanceSorter<T> instanceSorter : this.ingredientComponentViewHandler.getInstanceSorters()) {
            buttons.add(new TerminalButtonSort<T>(instanceSorter, this.container.getGuiState(), this));
        }
        if (!TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandlers().isEmpty()) {
            buttons.add(new TerminalButtonFilterCrafting(this.container.getGuiState(), this));
        }
    }

    public IngredientComponent<T, M> getIngredientComponent() {
        return this.ingredientComponent;
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public List<String> getTooltip() {
        return Lists.newArrayList((Object[])new String[]{L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.storage_name", (Object[])new Object[]{L10NHelpers.localize((String)this.ingredientComponent.getTranslationKey(), (Object[])new Object[0])})});
    }

    @Override
    public String getInstanceFilter(int channel) {
        if (this.container.getGuiState().hasSearch(this.getName().toString(), channel)) {
            return this.container.getGuiState().getSearch(this.getName().toString(), channel);
        }
        return "";
    }

    public Predicate<InstanceWithMetadata<T>> getInstanceFilterMetadata() {
        for (ITerminalButton<?, ?, ?> button : this.buttons) {
            if (!(button instanceof TerminalButtonFilterCrafting)) continue;
            return ((TerminalButtonFilterCrafting)button).getEffectiveFilter();
        }
        return Predicates.alwaysTrue();
    }

    public void resetFilteredIngredientsViews(int channel) {
        this.filteredIngredientsViews.remove(channel);
    }

    @Override
    public void setInstanceFilter(int channel, String filter) {
        TerminalStorageTabClientSearchFieldUpdateEvent event = new TerminalStorageTabClientSearchFieldUpdateEvent(this, filter);
        MinecraftForge.EVENT_BUS.post((Event)event);
        filter = event.getSearchString();
        this.resetFilteredIngredientsViews(channel);
        this.container.getGuiState().setSearch(this.getName().toString(), channel, filter.toLowerCase(Locale.ENGLISH));
    }

    public List<InstanceWithMetadata<T>> getRawUnfilteredIngredientsView(int channel) {
        List ingredientsView = (List)this.ingredientsViews.get(channel);
        if (ingredientsView == null) {
            ingredientsView = Lists.newArrayList();
            this.ingredientsViews.put(channel, (Object)ingredientsView);
        }
        return ingredientsView;
    }

    @Nullable
    public Collection<HandlerWrappedTerminalCraftingOption<T>> getCraftingOptions(int channel) {
        return (Collection)this.craftingOptions.get(channel);
    }

    public List<InstanceWithMetadata<T>> getUnfilteredIngredientsView(int channel) {
        Collection<HandlerWrappedTerminalCraftingOption<T>> craftingOptions = this.getCraftingOptions(channel);
        if (craftingOptions == null) {
            return this.getRawUnfilteredIngredientsView(channel);
        }
        ArrayList enrichedIngredients = Lists.newArrayList();
        enrichedIngredients.addAll(this.getRawUnfilteredIngredientsView(channel));
        for (HandlerWrappedTerminalCraftingOption<T> craftingOption : craftingOptions) {
            for (T output : this.getUniqueCraftingOptionOutputs(craftingOption.getCraftingOption())) {
                enrichedIngredients.add(new InstanceWithMetadata<T>(output, craftingOption));
            }
        }
        return enrichedIngredients;
    }

    protected Collection<T> getUniqueCraftingOptionOutputs(ITerminalCraftingOption<T> craftingOption) {
        TreeSet uniqueOutputs = Sets.newTreeSet((Comparator)this.ingredientComponent.getMatcher());
        Iterator<T> it = craftingOption.getOutputs();
        while (it.hasNext()) {
            uniqueOutputs.add(it.next());
        }
        return uniqueOutputs;
    }

    protected List<InstanceWithMetadata<T>> getFilteredIngredientsView(int channel) {
        ArrayList ingredientsView = (ArrayList)this.filteredIngredientsViews.get(channel);
        if (ingredientsView == null) {
            ingredientsView = this.getUnfilteredIngredientsView(channel);
            ingredientsView = Lists.newArrayList((Iterable)this.transformIngredientsView(ingredientsView.stream()).filter(im -> IIngredientQuery.parse(this.ingredientComponent, this.getInstanceFilter(channel)).test(im.getInstance())).filter(this.getInstanceFilterMetadata()).collect(Collectors.toList()));
            Comparator<T> sorter = this.getInstanceSorter();
            if (sorter != null) {
                ingredientsView.sort(InstanceWithMetadata.createComparator(sorter));
            }
            this.filteredIngredientsViews.put(channel, (Object)ingredientsView);
        }
        return ingredientsView;
    }

    protected Stream<InstanceWithMetadata<T>> transformIngredientsView(Stream<InstanceWithMetadata<T>> ingredientStream) {
        return ingredientStream;
    }

    @Override
    public List<TerminalStorageSlotIngredient<T, M>> getSlots(int channel, int offset, int limit) {
        List<InstanceWithMetadata<T>> ingredients = this.getFilteredIngredientsView(channel);
        int size = ingredients.size();
        if (offset >= size) {
            return Lists.newArrayList();
        }
        return ingredients.subList(offset, Math.min(offset + limit, size)).stream().map(instanceWithMetadata -> {
            Object instance = instanceWithMetadata.getInstance();
            HandlerWrappedTerminalCraftingOption craftingOption = instanceWithMetadata.getCraftingOption();
            if (craftingOption == null) {
                return new TerminalStorageSlotIngredient<T, M>(this.ingredientComponentViewHandler, instance);
            }
            return new TerminalStorageSlotIngredientCraftingOption<T, M>(this.ingredientComponentViewHandler, instance, craftingOption);
        }).collect(Collectors.toList());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public Optional<T> getSlotInstance(int channel, int index) {
        return this.getSlot(channel, index).map(TerminalStorageSlotIngredient::getInstance);
    }

    public Optional<TerminalStorageSlotIngredient<T, M>> getSlot(int channel, int index) {
        List<TerminalStorageSlotIngredient<T, M>> lastSlots;
        if (index >= 0 && !(lastSlots = this.getSlots(channel, index, 1)).isEmpty()) {
            return Optional.of(lastSlots.get(0));
        }
        return Optional.empty();
    }

    @Override
    public int getSlotCount(int channel) {
        return this.getFilteredIngredientsView(channel).size();
    }

    @Override
    public String getStatus(int channel) {
        return String.format("%,d / %,d", this.getTotalQuantity(channel), this.getMaxQuantity(channel));
    }

    public synchronized void onChange(int channel, IIngredientComponentStorageObservable.Change changeType, IngredientArrayList<T, M> ingredients, boolean enabled) {
        boolean bl = this.enabled = enabled || this.craftingOptions.containsKey(channel);
        if (channel != -1) {
            this.channels.add(channel);
        }
        Optional<T> lastInstance = this.getSlotInstance(channel, this.activeSlotId);
        if (channel != -1) {
            this.onChange(-1, changeType, ingredients, enabled);
        }
        long quantity = 0L;
        IIngredientMatcher matcher = ingredients.getComponent().getMatcher();
        for (Object ingredient : ingredients) {
            quantity += matcher.getQuantity(ingredient);
        }
        if (changeType != IIngredientComponentStorageObservable.Change.ADDITION) {
            quantity = -quantity;
        }
        long newQuantity = this.totalQuantities.get(channel) + quantity;
        this.totalQuantities.put(channel, newQuantity);
        List<InstanceWithMetadata<T>> rawPersistedIngredients = this.getRawUnfilteredIngredientsView(channel);
        IngredientArrayList persistedIngredients = new IngredientArrayList(this.ingredientComponent, (Iterable)rawPersistedIngredients.stream().map(InstanceWithMetadata::getInstance).collect(Collectors.toList()));
        IngredientCollectionDiff diff = new IngredientCollectionDiff(changeType == IIngredientComponentStorageObservable.Change.ADDITION ? ingredients : null, changeType == IIngredientComponentStorageObservable.Change.DELETION ? ingredients : null, false);
        IngredientCollectionDiffHelpers.applyDiff(this.ingredientComponent, (IngredientCollectionDiff)diff, (IIngredientCollectionMutable)persistedIngredients);
        rawPersistedIngredients.clear();
        for (Object persistedIngredient : persistedIngredients) {
            rawPersistedIngredients.add(new InstanceWithMetadata(persistedIngredient, null));
        }
        this.resetFilteredIngredientsViews(channel);
        this.updateActiveInstance(lastInstance, channel);
    }

    protected void updateActiveInstance(Optional<T> lastInstance, int channel) {
        if (lastInstance.isPresent() && this.activeChannel == channel) {
            this.activeSlotId = this.findActiveSlotId(channel, lastInstance.get());
            Optional<Object> slotIngredient = this.getSlotInstance(channel, this.activeSlotId);
            this.activeSlotQuantity = slotIngredient.map(t -> Math.min(this.activeSlotQuantity, Helpers.castSafe((long)this.ingredientComponent.getMatcher().getQuantity(t)))).orElse(0);
        }
    }

    public synchronized void addCraftingOptions(int channel, List<HandlerWrappedTerminalCraftingOption<T>> craftingOptions, boolean reset, boolean firstChannel) {
        Collection existingOptions;
        Optional<T> lastInstance = this.getSlotInstance(channel, this.activeSlotId);
        if (channel != -1) {
            this.addCraftingOptions(-1, craftingOptions, reset && firstChannel, firstChannel);
        }
        this.enabled = true;
        if (channel != -1) {
            this.channels.add(channel);
        }
        if ((existingOptions = (Collection)this.craftingOptions.get(channel)) == null || reset) {
            this.craftingOptions.put(channel, (Object)Lists.newArrayList(craftingOptions));
        } else {
            existingOptions.addAll(craftingOptions);
        }
        this.resetFilteredIngredientsViews(channel);
        this.updateActiveInstance(lastInstance, channel);
    }

    protected int findActiveSlotId(int channel, T instance) {
        IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
        int newActiveSlot = 0;
        Object matchCondition = matcher.getExactMatchNoQuantityCondition();
        List<TerminalStorageSlotIngredient<T, M>> slots = this.getSlots(channel, 0, Integer.MAX_VALUE);
        for (TerminalStorageSlotIngredient<T, M> slot : slots) {
            T ingredient = slot.getInstance();
            if (matcher.matches(ingredient, instance, matchCondition)) {
                return newActiveSlot;
            }
            ++newActiveSlot;
        }
        return -1;
    }

    public synchronized void handleActiveIngredientUpdate(int channel, T activeInstance) {
        IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
        this.activeChannel = channel;
        if (!matcher.isEmpty(activeInstance)) {
            this.activeSlotId = this.findActiveSlotId(channel, activeInstance);
            Optional<Object> slotIngredient = this.getSlotInstance(channel, this.activeSlotId);
            this.activeSlotQuantity += slotIngredient.map(t -> Helpers.castSafe((long)matcher.getQuantity(activeInstance))).orElse(0).intValue();
        }
    }

    public long getMaxQuantity(int channel) {
        if (channel == -1) {
            return Arrays.stream(this.getChannels()).mapToLong(this::getMaxQuantity).sum();
        }
        return this.maxQuantities.get(channel);
    }

    public void setMaxQuantity(int channel, long maxQuantity) {
        this.maxQuantities.put(channel, maxQuantity);
    }

    public long getTotalQuantity(int channel) {
        return this.totalQuantities.get(channel);
    }

    @Override
    public int[] getChannels() {
        int[] channels = this.channels.toIntArray();
        Arrays.sort(channels);
        return channels;
    }

    @Override
    public void resetActiveSlot() {
        this.activeSlotId = -1;
        this.activeSlotQuantity = 0;
        this.activeChannel = -2;
    }

    @Override
    public boolean handleClick(Container container, int channel, int hoveringStorageSlot, int mouseButton, boolean hasClickedOutside, boolean hasClickedInStorage, int hoveredContainerSlot) {
        this.activeChannel = channel;
        IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
        Optional<TerminalStorageSlotIngredient<TerminalStorageSlotIngredient, M>> hoveringStorageSlotObject = this.getSlot(channel, hoveringStorageSlot);
        Optional<Object> hoveringStorageInstance = hoveringStorageSlotObject.map(TerminalStorageSlotIngredient::getInstance);
        boolean validHoveringStorageSlot = hoveringStorageInstance.isPresent();
        boolean isCraftingOption = hoveringStorageSlotObject.isPresent() && hoveringStorageSlotObject.get() instanceof TerminalStorageSlotIngredientCraftingOption;
        IIngredientComponentTerminalStorageHandler viewHandler = (IIngredientComponentTerminalStorageHandler)this.ingredientComponent.getCapability(IngredientComponentTerminalStorageHandlerConfig.CAPABILITY);
        boolean shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        boolean transferFullSelection = true;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean initiateCraftingOption = false;
        if (mouseButton == 0 || mouseButton == 1 || mouseButton == 2) {
            TerminalClickType clickType = null;
            long moveQuantity = this.activeSlotQuantity;
            long movePlayerQuantity = 0L;
            boolean reset = false;
            if (validHoveringStorageSlot && player.field_71071_by.func_70445_o().func_190926_b() && this.activeSlotId < 0) {
                if (isCraftingOption) {
                    initiateCraftingOption = true;
                } else if (shift) {
                    clickType = TerminalClickType.STORAGE_QUICK_MOVE;
                } else {
                    this.activeSlotId = hoveringStorageSlot;
                    this.activeSlotQuantity = Math.min((int)this.ingredientComponent.getMatcher().getQuantity(hoveringStorageInstance.orElse(matcher.getEmptyInstance())), viewHandler.getInitialInstanceMovementQuantity());
                    if (mouseButton == 1) {
                        this.activeSlotQuantity = (int)Math.ceil((double)this.activeSlotQuantity / 2.0);
                    } else if (mouseButton == 2) {
                        this.activeSlotQuantity = 1;
                    }
                }
            } else if (hoveredContainerSlot >= 0 && !container.func_75139_a(hoveredContainerSlot).func_75211_c().func_190926_b() && shift) {
                clickType = TerminalClickType.PLAYER_QUICK_MOVE;
            } else if (hasClickedInStorage && !player.field_71071_by.func_70445_o().func_190926_b()) {
                clickType = TerminalClickType.PLAYER_PLACE_STORAGE;
                movePlayerQuantity = mouseButton == 0 ? viewHandler.getActivePlayerStackQuantity(player.field_71071_by) : (mouseButton == 1 ? (long)viewHandler.getIncrementalInstanceMovementQuantity() : (long)((int)Math.ceil((double)viewHandler.getActivePlayerStackQuantity(player.field_71071_by) / 2.0)));
                viewHandler.drainActivePlayerStackQuantity(player.field_71071_by, movePlayerQuantity);
                this.resetActiveSlot();
            } else if (this.activeSlotId >= 0) {
                if (hasClickedOutside) {
                    clickType = TerminalClickType.STORAGE_PLACE_WORLD;
                    reset = true;
                } else if (hoveredContainerSlot >= 0) {
                    clickType = TerminalClickType.STORAGE_PLACE_PLAYER;
                    if (mouseButton == 0) {
                        reset = true;
                        moveQuantity = this.activeSlotQuantity;
                    } else if (mouseButton == 1) {
                        transferFullSelection = false;
                        moveQuantity = viewHandler.getIncrementalInstanceMovementQuantity();
                    } else {
                        transferFullSelection = false;
                        moveQuantity = (int)Math.ceil((double)this.activeSlotQuantity / 2.0);
                    }
                    this.activeSlotQuantity = (int)((long)this.activeSlotQuantity - moveQuantity);
                } else if (hasClickedInStorage) {
                    if (mouseButton == 0 && this.activeSlotId == hoveringStorageSlot) {
                        this.activeSlotQuantity = (int)Math.min(this.ingredientComponent.getMatcher().getQuantity(hoveringStorageInstance.get()), (long)(this.activeSlotQuantity + (shift ? viewHandler.getInitialInstanceMovementQuantity() : viewHandler.getIncrementalInstanceMovementQuantity())));
                    } else if (mouseButton == 1) {
                        this.activeSlotQuantity = Math.max(0, this.activeSlotQuantity - (shift ? viewHandler.getInitialInstanceMovementQuantity() : viewHandler.getIncrementalInstanceMovementQuantity()));
                        if (this.activeSlotQuantity == 0) {
                            this.activeSlotId = -1;
                        }
                    } else {
                        this.resetActiveSlot();
                    }
                } else {
                    this.resetActiveSlot();
                }
                if (moveQuantity == 0L) {
                    this.activeSlotId = -1;
                }
            }
            if (initiateCraftingOption) {
                ContainerTerminalStorage containerTerminalStorage = (ContainerTerminalStorage)container;
                PartPos pos = containerTerminalStorage.getTarget().getCenter();
                CraftingOptionGuiData<T, M> craftingOptionData = new CraftingOptionGuiData<T, M>(pos.getPos().getBlockPos(), pos.getSide(), this.ingredientComponent, this.getName().toString(), channel, ((TerminalStorageSlotIngredientCraftingOption)hoveringStorageSlotObject.get()).getCraftingOption(), 1, null);
                IntegratedTerminals._instance.getGuiHandler().setTemporaryData(ExtendedGuiHandler.CRAFTING_OPTION, (Object)Pair.of((Object)((ContainerTerminalStorage)container).getTarget().getCenter().getSide(), craftingOptionData));
                if (shift) {
                    IntegratedTerminals._instance.getPacketHandler().sendToServer(new TerminalStorageIngredientOpenCraftingPlanGuiPacket<T, M>(craftingOptionData));
                } else {
                    IntegratedTerminals._instance.getPacketHandler().sendToServer(new TerminalStorageIngredientOpenCraftingJobAmountGuiPacket<T, M>(craftingOptionData));
                }
            } else if (clickType != null) {
                Object activeInstance = matcher.getEmptyInstance();
                if (this.activeSlotId >= 0) {
                    activeInstance = matcher.withQuantity(this.getSlots(channel, this.activeSlotId, 1).get(0).getInstance(), moveQuantity);
                }
                IntegratedTerminals._instance.getPacketHandler().sendToServer(new TerminalStorageIngredientSlotClickPacket<Object>(this.getName().toString(), this.ingredientComponent, clickType, channel, hoveringStorageInstance.orElse(matcher.getEmptyInstance()), hoveredContainerSlot, movePlayerQuantity, activeInstance, transferFullSelection));
                if (reset) {
                    this.resetActiveSlot();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int getActiveSlotId() {
        return this.activeSlotId;
    }

    @Override
    public int getActiveSlotQuantity() {
        return this.activeSlotQuantity;
    }

    @Override
    public void setActiveSlotQuantity(int quantity) {
        this.activeSlotQuantity = quantity;
        if (quantity == 0) {
            this.activeSlotId = -1;
        }
    }

    @Override
    public List<ITerminalButton<?, ?, ?>> getButtons() {
        return this.buttons;
    }

    @Nullable
    public Comparator<T> getInstanceSorter() {
        Comparator sorter = null;
        for (ITerminalButton<?, ?, ?> button : this.buttons) {
            Comparator partSorter;
            if (!(button instanceof TerminalButtonSort) || (partSorter = ((TerminalButtonSort)button).getEffectiveSorter()) == null) continue;
            if (sorter == null) {
                sorter = partSorter;
                continue;
            }
            sorter = sorter.thenComparing(partSorter);
        }
        if (sorter != null) {
            sorter = sorter.thenComparing(this.ingredientComponent.getMatcher());
        }
        return sorter;
    }

    @Override
    public void onCommonSlotRender(GuiContainer gui, GuiTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, int slot, ITerminalStorageTabCommon tabCommon) {
        TerminalStorageTabIngredientComponentCommon tab = (TerminalStorageTabIngredientComponentCommon)tabCommon;
        if (slot >= tab.getVariableSlotNumberStart() && slot < tab.getVariableSlotNumberEnd()) {
            ArrayList errors = Lists.newArrayList();
            errors.addAll(tab.getGlobalErrors());
            errors.addAll(tab.getLocalErrors(slot));
            if (!errors.isEmpty()) {
                if (layer == GuiTerminalStorage.DrawLayer.BACKGROUND) {
                    Images.ERROR.draw((Gui)gui, x + 2, y + 2);
                } else if (RenderHelpers.isPointInRegion((int)x, (int)y, (int)GuiHelpers.SLOT_SIZE, (int)GuiHelpers.SLOT_SIZE, (int)mouseX, (int)mouseY)) {
                    GuiHelpers.drawTooltip((GuiContainer)gui, errors.stream().map(L10NHelpers.UnlocalizedString::localize).map(s -> StringHelpers.splitLines((String)s, (int)25, (String)TextFormatting.RED.toString())).flatMap(Collection::stream).collect(Collectors.toList()), (int)(x - gui.getGuiLeft() + 10), (int)(y - gui.getGuiTop()));
                }
            }
        }
    }

    protected IIngredientComponentTerminalStorageHandler<T, M> getViewHandler() {
        return (IIngredientComponentTerminalStorageHandler)this.ingredientComponent.getCapability(IngredientComponentTerminalStorageHandlerConfig.CAPABILITY);
    }

    @Override
    public boolean isSlotValidForDraggingInto(int channel, Slot slot) {
        ItemStack stack;
        IIngredientComponentTerminalStorageHandler<T, M> viewHandler = this.getViewHandler();
        if (!viewHandler.isInstance(stack = slot.func_75211_c())) {
            return false;
        }
        T stackInstance = viewHandler.getInstance(stack);
        Optional<T> activeInstance = this.getSlotInstance(channel, this.getActiveSlotId());
        IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
        return activeInstance.isPresent() && (matcher.isEmpty(stackInstance) || matcher.matches(stackInstance, activeInstance.get(), matcher.getExactMatchNoQuantityCondition())) && matcher.getQuantity(stackInstance) != viewHandler.getMaxQuantity(stack);
    }

    @Override
    public int computeDraggingQuantity(Set<Slot> dragSlots, int dragMode, ItemStack stack, int quantity) {
        int instanceQuantity = 0;
        switch (dragMode) {
            case 0: {
                instanceQuantity = MathHelper.func_76141_d((float)((float)quantity / (float)dragSlots.size()));
                break;
            }
            case 1: {
                instanceQuantity = this.getViewHandler().getIncrementalInstanceMovementQuantity();
                break;
            }
            case 2: {
                instanceQuantity = Helpers.castSafe((long)this.getViewHandler().getMaxQuantity(stack));
            }
        }
        return instanceQuantity;
    }

    @Override
    public int dragIntoSlot(Container container, int channel, Slot slot, int quantity, boolean simulate) {
        if (!simulate) {
            int oldActiveSlotId = this.activeSlotId;
            int activeSlotQuantityOld = this.activeSlotQuantity;
            this.activeSlotQuantity = quantity;
            this.handleClick(container, channel, this.getActiveSlotId(), 0, false, false, slot.field_75222_d);
            this.activeSlotId = oldActiveSlotId;
            this.activeSlotQuantity = activeSlotQuantityOld;
        }
        IIngredientComponentTerminalStorageHandler<T, M> viewHandler = this.getViewHandler();
        ItemStack stack = slot.func_75211_c();
        T stackInstance = viewHandler.getInstance(stack);
        IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
        int instanceQuantity = Helpers.castSafe((long)matcher.getQuantity(stackInstance));
        int maxQuantity = Helpers.castSafe((long)viewHandler.getMaxQuantity(stack));
        int freeQuantity = maxQuantity - instanceQuantity;
        return Math.min(Math.max(0, quantity), freeQuantity);
    }

    static {
        MinecraftForge.EVENT_BUS.register(TerminalStorageTabIngredientComponentClient.class);
    }

    public static class InstanceWithMetadata<T> {
        private final T instance;
        @Nullable
        private final HandlerWrappedTerminalCraftingOption<T> craftingOption;

        public InstanceWithMetadata(T instance, @Nullable HandlerWrappedTerminalCraftingOption<T> craftingOption) {
            this.instance = instance;
            this.craftingOption = craftingOption;
        }

        public T getInstance() {
            return this.instance;
        }

        @Nullable
        public HandlerWrappedTerminalCraftingOption<T> getCraftingOption() {
            return this.craftingOption;
        }

        public static <T> Comparator<InstanceWithMetadata<T>> createComparator(Comparator<T> comparator) {
            return (o1, o2) -> {
                int comp = comparator.compare(o1.getInstance(), o2.getInstance());
                if (comp == 0) {
                    HandlerWrappedTerminalCraftingOption c1 = o1.getCraftingOption();
                    HandlerWrappedTerminalCraftingOption c2 = o2.getCraftingOption();
                    if (c1 == null) {
                        if (c2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (c2 == null) {
                        return 1;
                    }
                    return c1.getCraftingOption().compareTo(c2.getCraftingOption());
                }
                return comp;
            };
        }
    }
}

