/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import com.google.common.collect.Lists;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonText;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingPlan;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientOpenPacket;

public class GuiTerminalStorageCraftingPlan
extends GuiContainerExtended {
    private final CraftingOptionGuiData<?, ?> craftingOptionGuiData;
    @Nullable
    private GuiCraftingPlan guiCraftingPlan;
    private ITerminalCraftingPlan craftingPlan;

    public GuiTerminalStorageCraftingPlan(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType, CraftingOptionGuiData craftingOptionGuiData) {
        super((ExtendedInventoryContainer)new ContainerTerminalStorageCraftingPlan(player, target, partContainer, partType, craftingOptionGuiData));
        this.craftingOptionGuiData = craftingOptionGuiData;
    }

    protected ResourceLocation constructResourceLocation() {
        return new ResourceLocation("integratedterminals", this.getGuiTexture());
    }

    public String getGuiTexture() {
        return (String)IntegratedTerminals._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + "crafting_plan.png";
    }

    public int getBaseXSize() {
        return 256;
    }

    public int getBaseYSize() {
        return 222;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiCraftingPlan = this.craftingPlan != null ? new GuiCraftingPlan((GuiContainer)this, this.craftingPlan, this.field_147003_i, this.field_147009_r, 9, 18, 10) : null;
        this.field_146292_n.clear();
        GuiButtonText button = new GuiButtonText(1, this.field_147003_i + 95, this.field_147009_r + 198, 50, 20, TextFormatting.BOLD + L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.step.craft", (Object[])new Object[0]), true);
        this.field_146292_n.addAll(Lists.newArrayList((Object[])new GuiButtonText[]{button}));
        button.field_146124_l = this.guiCraftingPlan != null && this.guiCraftingPlan.isValid();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.func_146983_a(keyCode)) {
            if (keyCode == 1) {
                this.returnToTerminalStorage();
            } else if (this.guiCraftingPlan != null && this.guiCraftingPlan.isValid() && (keyCode == 156 || keyCode == 28)) {
                this.func_146284_a((GuiButton)this.field_146292_n.get(0));
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }
    }

    private void returnToTerminalStorage() {
        TerminalStorageIngredientOpenPacket.send(this.craftingOptionGuiData.getPos(), this.craftingOptionGuiData.getSide(), this.craftingOptionGuiData.getTabName(), this.craftingOptionGuiData.getChannel());
    }

    public boolean requiresAction(int buttonId) {
        return true;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        } else {
            this.func_73732_a(this.field_146289_q, L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.step.crafting_plan_calculating", (Object[])new Object[0]), this.field_147003_i + this.getBaseXSize() / 2, this.field_147009_r + 23, 0xFFFFFF);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawGuiContainerForegroundLayer(mouseX, mouseY);
        }
    }

    protected void drawCurrentScreen(int mouseX, int mouseY, float partialTicks) {
        super.drawCurrentScreen(mouseX, mouseY, partialTicks);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawCurrentScreen(mouseX, mouseY, partialTicks);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.handleMouseInput();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    public void onUpdate(int valueId, NBTTagCompound value) {
        super.onUpdate(valueId, value);
        if (((ContainerTerminalStorageCraftingPlan)this.getContainer()).getCraftingPlanNotifierId() == valueId) {
            this.craftingPlan = this.craftingOptionGuiData.getCraftingOption().getHandler().deserializeCraftingPlan(value);
            this.func_73866_w_();
        }
    }
}

