/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.client.gui.component.GuiScrollBar;
import org.cyclops.cyclopscore.client.gui.component.input.GuiArrowedListField;
import org.cyclops.cyclopscore.client.gui.component.input.GuiTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.proxy.ClientProxy;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageSlot;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridClear;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorage;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridBalance;
import org.lwjgl.opengl.GL11;

public class GuiTerminalStorage
extends GuiContainerExtended {
    private static int TAB_OFFSET_X = 24;
    private static int TAB_WIDTH = 24;
    private static int TAB_UNSELECTED_HEIGHT = 21;
    private static int TAB_SELECTED_HEIGHT = 24;
    private static int TAB_ICON_OFFSET = 4;
    private static int TAB_UNSELECTED_TEXTURE_X = 0;
    private static int TAB_SELECTED_TEXTURE_X = 24;
    private static int TAB_UNSELECTED_TEXTURE_Y = 225;
    private static int TAB_SELECTED_TEXTURE_Y = 225;
    private static int SCROLL_X = 198;
    private static int SCROLL_Y = 39;
    private static int SCROLL_HEIGHT = 88;
    private static int SEARCH_X = 104;
    private static int SEARCH_Y = 27;
    private static int SEARCH_WIDTH = 80;
    private static int SEARCH_HEIGHT = 20;
    private static int CHANNEL_X = 58;
    private static int CHANNEL_Y = 25;
    private static int CHANNEL_WIDTH = 42;
    private static int CHANNEL_HEIGHT = 15;
    private static int BUTTONS_OFFSET_X = 0;
    private static int BUTTONS_OFFSET_Y = 22;
    private static int BUTTONS_OFFSET = 4;
    private GuiArrowedListField<String> fieldChannel;
    private GuiScrollBar scrollBar;
    private GuiTextFieldExtended fieldSearch;
    private int firstRow;
    private boolean initialized;
    protected final Set<Slot> terminalDragSplittingSlots = Sets.newHashSet();
    protected boolean terminalDragSplitting;
    private int terminalDragMode;
    private int terminalDragSplittingButton;
    private int terminalDragSplittingRemnant;
    private boolean clicked;

    public GuiTerminalStorage(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType) {
        super((ExtendedInventoryContainer)new ContainerTerminalStorage(player, target, partContainer, partType));
    }

    public GuiTerminalStorage(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType, ContainerTerminalStorage.InitTabData initTabData) {
        super((ExtendedInventoryContainer)new ContainerTerminalStorage(player, target, partContainer, partType, initTabData));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.fieldChannel = new GuiArrowedListField(0, Minecraft.func_71410_x().field_71466_p, this.field_147003_i + CHANNEL_X, this.field_147009_r + CHANNEL_Y, CHANNEL_WIDTH, CHANNEL_HEIGHT, true, true, this.getContainer().getChannelStrings());
        this.fieldChannel.func_146203_f(15);
        this.fieldChannel.func_146189_e(true);
        this.fieldChannel.func_146193_g(0xFFFFFF);
        this.fieldChannel.func_146205_d(true);
        this.fieldChannel.func_146184_c(true);
        int activeChannel = this.getContainer().getSelectedChannel();
        if (activeChannel != -1) {
            this.fieldChannel.func_146180_a(Integer.toString(activeChannel));
        }
        this.scrollBar = new GuiScrollBar(this.field_147003_i + SCROLL_X, this.field_147009_r + SCROLL_Y, SCROLL_HEIGHT, firstRow -> {
            this.firstRow = firstRow;
        }, 0){

            public int getTotalRows() {
                ContainerTerminalStorage container = GuiTerminalStorage.this.getContainer();
                Optional<ITerminalStorageTabClient<?>> tabOptional = GuiTerminalStorage.this.getSelectedClientTab();
                if (!tabOptional.isPresent()) {
                    return 0;
                }
                int totalSlots = tabOptional.get().getSlotCount(container.getSelectedChannel());
                return (int)Math.ceil((double)totalSlots / (double)GuiTerminalStorage.this.getSlotRowLength());
            }

            public int getVisibleRows() {
                return GuiTerminalStorage.this.getSlotVisibleRows();
            }
        };
        this.fieldSearch = new GuiTextFieldExtended(1, Minecraft.func_71410_x().field_71466_p, this.field_147003_i + SEARCH_X, this.field_147009_r + SEARCH_Y, SEARCH_WIDTH, SEARCH_HEIGHT);
        this.fieldSearch.func_146203_f(50);
        this.fieldSearch.func_146189_e(true);
        this.fieldSearch.func_146193_g(0xFFFFFF);
        this.fieldSearch.func_146205_d(true);
        this.fieldSearch.func_146184_c(true);
        this.fieldSearch.func_146185_a(false);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.initialized && this.getSelectedClientTab().isPresent()) {
            this.initialized = true;
            this.fieldSearch.func_146180_a(this.getSelectedClientTab().get().getInstanceFilter(this.getContainer().getSelectedChannel()));
        }
    }

    protected ResourceLocation constructResourceLocation() {
        return new ResourceLocation("integratedterminals", this.getGuiTexture());
    }

    public String getGuiTexture() {
        return (String)IntegratedTerminals._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + "part_terminal_storage.png";
    }

    public int getBaseXSize() {
        return 218;
    }

    public int getBaseYSize() {
        return 225;
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        this.fieldChannel.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
        this.fieldSearch.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
        this.drawTabsBackground();
        this.drawTabContents(this.getContainer().getSelectedTab(), this.getContainer().getSelectedChannel(), DrawLayer.BACKGROUND, f, this.getGuiLeftTotal() + this.getSlotsOffsetX(), this.getGuiTopTotal() + this.getSlotsOffsetY(), mouseX, mouseY);
        this.scrollBar.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        tabOptional.ifPresent(tab -> {
            int offset = 0;
            for (ITerminalButton<?, ?, ?> button : tab.getButtons()) {
                Object guiButton = button.createButton(button.getX(this.field_147003_i, BUTTONS_OFFSET_X), button.getY(this.field_147009_r, BUTTONS_OFFSET_Y + offset));
                guiButton.func_191745_a(this.field_146297_k, mouseX, mouseY, f);
                if (!button.isInLeftColumn()) continue;
                offset += BUTTONS_OFFSET + ((GuiButton)guiButton).field_146121_g;
            }
            String tabName = this.getContainer().getSelectedTab();
            Optional<ITerminalStorageTabCommon> tabCommonOptional = this.getCommonTab(tabName);
            tabCommonOptional.ifPresent(tabCommon -> {
                for (Triple<Slot, Integer, Integer> slot : this.getContainer().getTabSlots(tabName)) {
                    tab.onCommonSlotRender((GuiContainer)this, DrawLayer.BACKGROUND, 0.0f, this.field_147003_i + (Integer)slot.getMiddle(), this.field_147009_r + (Integer)slot.getRight(), mouseX, mouseY, ((Slot)slot.getLeft()).field_75222_d, (ITerminalStorageTabCommon)tabCommon);
                }
            });
        });
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.drawTabsForeground(mouseX, mouseY);
        this.drawTabContents(this.getContainer().getSelectedTab(), this.getContainer().getSelectedChannel(), DrawLayer.FOREGROUND, 0.0f, this.getSlotsOffsetX(), this.getSlotsOffsetY(), mouseX, mouseY);
        this.field_73735_i = 150.0f;
        RenderItemExtendedSlotCount.getInstance().field_77023_b = 150.0f;
        this.drawActiveStorageSlotItem(mouseX, mouseY);
        RenderItemExtendedSlotCount.getInstance().field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        tabOptional.ifPresent(tab -> {
            int offset = 0;
            for (ITerminalButton<?, ?, ?> button : tab.getButtons()) {
                Object guiButton = button.createButton(button.getX(this.field_147003_i, BUTTONS_OFFSET_X), button.getY(this.field_147009_r, BUTTONS_OFFSET_Y + offset));
                if (this.func_146978_c(button.getX(0, BUTTONS_OFFSET_X), button.getY(0, BUTTONS_OFFSET_Y + offset), ((GuiButton)guiButton).field_146120_f, ((GuiButton)guiButton).field_146121_g, mouseX, mouseY)) {
                    ArrayList lines = Lists.newArrayList();
                    lines.add(L10NHelpers.localize((String)button.getTranslationKey(), (Object[])new Object[0]));
                    button.getTooltip((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL, lines);
                    this.drawTooltip(lines, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
                }
                if (!button.isInLeftColumn()) continue;
                offset += BUTTONS_OFFSET + ((GuiButton)guiButton).field_146121_g;
            }
            String tabName = this.getContainer().getSelectedTab();
            Optional<ITerminalStorageTabCommon> tabCommonOptional = this.getCommonTab(tabName);
            tabCommonOptional.ifPresent(tabCommon -> {
                for (Triple<Slot, Integer, Integer> slot : this.getContainer().getTabSlots(tabName)) {
                    tab.onCommonSlotRender((GuiContainer)this, DrawLayer.FOREGROUND, 0.0f, this.field_147003_i + (Integer)slot.getMiddle(), this.field_147009_r + (Integer)slot.getRight(), mouseX, mouseY, ((Slot)slot.getLeft()).field_75222_d, (ITerminalStorageTabCommon)tabCommon);
                }
            });
        });
    }

    protected void drawCurrentScreen(int mouseX, int mouseY, float partialTicks) {
        this.scrollBar.drawCurrentScreen(mouseX, mouseY, partialTicks);
        ResourceLocation oldTexture = this.texture;
        this.getSelectedClientTab().ifPresent(tab -> {
            ResourceLocation texture = tab.getBackgroundTexture();
            if (texture != null) {
                this.texture = texture;
            }
        });
        super.drawCurrentScreen(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.field_73735_i = 0.0f;
        for (int i1 = 0; i1 < this.field_147002_h.field_75151_b.size(); ++i1) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i1);
            if (!slot.func_111238_b()) continue;
            this.drawSlotOverlay(slot);
        }
        this.field_73735_i = 0.0f;
        this.texture = oldTexture;
    }

    private void drawSlotOverlay(Slot slot) {
        this.getSelectedClientTab().ifPresent(tab -> {
            if (this.terminalDragSplitting && this.terminalDragSplittingSlots.contains(slot)) {
                if (tab.isSlotValidForDraggingInto(this.getContainer().getSelectedChannel(), slot)) {
                    if (this.terminalDragSplittingSlots.size() == 1) {
                        return;
                    }
                    int dragQuantity = tab.computeDraggingQuantity(this.terminalDragSplittingSlots, this.terminalDragMode, slot.func_75211_c(), tab.getActiveSlotQuantity());
                    if (dragQuantity > 0) {
                        String dragString = "+" + GuiHelpers.quantityToScaledString((long)dragQuantity);
                        RenderHelpers.drawScaledString((FontRenderer)this.field_146289_q, (String)dragString, (int)(this.field_147003_i + slot.field_75223_e), (int)(this.field_147009_r + slot.field_75221_f), (float)0.5f, (int)0xFFFF55, (boolean)true);
                    }
                } else {
                    this.terminalDragSplittingSlots.remove(slot);
                    this.updateTerminalDragSplitting((ITerminalStorageTabClient<?>)tab);
                }
            }
        });
    }

    public ContainerTerminalStorage getContainer() {
        return (ContainerTerminalStorage)super.getContainer();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.scrollBar.handleMouseInput();
    }

    protected Optional<ITerminalStorageTabClient<?>> getTabByIndex(int tabIndex) {
        Collection<ITerminalStorageTabClient<?>> tabsClientList = this.getContainer().getTabsClient().values();
        if (tabIndex >= 0 && tabIndex < tabsClientList.size()) {
            return Optional.of(Iterables.get(tabsClientList, (int)tabIndex));
        }
        return Optional.empty();
    }

    protected void setTabByIndex(int tabIndex) {
        this.getTabByIndex(tabIndex).ifPresent(tab -> {
            this.getContainer().setSelectedTab(tab.getName().toString());
            tab.resetActiveSlot();
            this.fieldSearch.func_146180_a(tab.getInstanceFilter(this.getContainer().getSelectedChannel()));
        });
        this.scrollBar.scrollTo(0.0f);
    }

    protected void playButtonClickSound() {
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        this.clicked = true;
        if (mouseButton == 0 && mouseY < this.getGuiTop() + TAB_UNSELECTED_HEIGHT && mouseX > this.getGuiLeft() + TAB_OFFSET_X && mouseX <= this.getGuiLeft() + TAB_OFFSET_X + (TAB_WIDTH * this.getContainer().getTabsClientCount() - 1)) {
            this.setTabByIndex((mouseX - TAB_OFFSET_X - this.getGuiLeft()) / TAB_WIDTH);
            this.playButtonClickSound();
            return;
        }
        if (this.fieldChannel.func_146192_a(mouseX, mouseY, mouseButton)) {
            int channel;
            try {
                channel = Integer.parseInt((String)this.fieldChannel.getActiveElement());
            }
            catch (NumberFormatException e) {
                channel = -1;
            }
            int finalChannel = channel;
            this.getContainer().setSelectedChannel(channel);
            this.scrollBar.scrollTo(0.0f);
            tabOptional.ifPresent(tab -> this.fieldSearch.func_146180_a(tab.getInstanceFilter(finalChannel)));
            this.playButtonClickSound();
            return;
        }
        if (tabOptional.isPresent()) {
            ITerminalStorageTabClient<?> tab2 = tabOptional.get();
            Slot playerSlot = this.getSlotUnderMouse();
            if (tab2.getActiveSlotId() >= 0 && (mouseButton == 0 || mouseButton == 1 || this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100)) && playerSlot != null && !this.terminalDragSplitting) {
                this.terminalDragSplitting = true;
                this.terminalDragSplittingButton = mouseButton;
                this.terminalDragSplittingSlots.clear();
                if (mouseButton == 0) {
                    this.terminalDragMode = 0;
                } else if (mouseButton == 1) {
                    this.terminalDragMode = 1;
                } else if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100)) {
                    this.terminalDragMode = 2;
                }
                return;
            }
        } else if (this.getSlotUnderMouse() != null) {
            return;
        }
        this.fieldSearch.func_146192_a(mouseX, mouseY, mouseButton);
        tabOptional.ifPresent(tab -> {
            int offset = 0;
            ITerminalStorageTabCommon tabCommon = this.getContainer().getTabCommon(tab.getName().toString());
            for (ITerminalButton<?, ?, ?> button : tab.getButtons()) {
                Object guiButton = button.createButton(button.getX(this.field_147003_i, BUTTONS_OFFSET_X), button.getY(this.field_147009_r, BUTTONS_OFFSET_Y + offset));
                if (this.func_146978_c(button.getX(0, BUTTONS_OFFSET_X), button.getY(0, BUTTONS_OFFSET_Y + offset), ((GuiButton)guiButton).field_146120_f, ((GuiButton)guiButton).field_146121_g, mouseX, mouseY)) {
                    button.onClick(tab, tabCommon, guiButton, this.getContainer().getSelectedChannel(), mouseButton);
                    this.playButtonClickSound();
                    return;
                }
                if (!button.isInLeftColumn()) continue;
                offset += BUTTONS_OFFSET + ((GuiButton)guiButton).field_146121_g;
            }
        });
        if (!GuiTerminalStorage.func_146272_n()) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        Slot slot = super.getSlotUnderMouse();
        if (slot != null && slot.field_75223_e < 0) {
            return null;
        }
        return slot;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.getSelectedClientTab().ifPresent(tab -> {
            Slot slot;
            if (this.terminalDragSplitting & tab.getActiveSlotId() >= 0 && (slot = this.getSlotUnderMouse()) != null && (tab.getActiveSlotQuantity() > this.terminalDragSplittingSlots.size() || this.terminalDragMode == 2) && tab.isSlotValidForDraggingInto(this.getContainer().getSelectedChannel(), slot)) {
                this.terminalDragSplittingSlots.add(slot);
                this.updateTerminalDragSplitting((ITerminalStorageTabClient<?>)tab);
                return;
            }
        });
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    private void updateTerminalDragSplitting(ITerminalStorageTabClient<?> tab) {
        if (this.terminalDragSplitting) {
            int quantityTotal = tab.getActiveSlotQuantity();
            this.terminalDragSplittingRemnant = tab.getActiveSlotQuantity();
            for (Slot slot : this.terminalDragSplittingSlots) {
                if (!tab.isSlotValidForDraggingInto(this.getContainer().getSelectedChannel(), slot)) continue;
                int dragQuantity = tab.computeDraggingQuantity(this.terminalDragSplittingSlots, this.terminalDragMode, slot.func_75211_c(), quantityTotal);
                this.terminalDragSplittingRemnant -= tab.dragIntoSlot((Container)this.container, this.getContainer().getSelectedChannel(), slot, dragQuantity, true);
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        if (this.terminalDragSplitting && (this.terminalDragSplittingSlots.size() <= 1 || this.terminalDragSplittingButton != mouseButton)) {
            this.terminalDragSplitting = false;
            this.terminalDragSplittingSlots.clear();
            if (this.terminalDragSplittingButton != mouseButton) {
                return;
            }
        }
        boolean dragged = false;
        if (this.terminalDragSplitting) {
            dragged = true;
            this.getSelectedClientTab().ifPresent(tab -> {
                if (tab.getActiveSlotQuantity() > 0) {
                    int quantityTotal;
                    int quantity = quantityTotal = tab.getActiveSlotQuantity();
                    for (Slot slot : this.terminalDragSplittingSlots) {
                        if (!tab.isSlotValidForDraggingInto(this.getContainer().getSelectedChannel(), slot)) continue;
                        int dragQuantity = tab.computeDraggingQuantity(this.terminalDragSplittingSlots, this.terminalDragMode, slot.func_75211_c(), quantityTotal);
                        quantity -= tab.dragIntoSlot((Container)this.container, this.getContainer().getSelectedChannel(), slot, dragQuantity, false);
                    }
                    tab.setActiveSlotQuantity(quantity);
                }
            });
        }
        this.terminalDragSplitting = false;
        this.terminalDragSplittingSlots.clear();
        this.terminalDragSplittingButton = -1;
        this.terminalDragMode = -1;
        this.terminalDragSplittingRemnant = 0;
        if (!dragged && this.clicked) {
            this.clicked = false;
            Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
            if (tabOptional.isPresent()) {
                int slot = this.getStorageSlotIndexAtPosition(mouseX, mouseY);
                Slot playerSlot = this.getSlotUnderMouse();
                boolean hasClickedOutside = this.func_193983_c(mouseX, mouseY, this.field_147003_i, this.field_147009_r);
                boolean hasClickedInStorage = this.hasClickedInStorage(mouseX, mouseY);
                if (tabOptional.get().handleClick((Container)this.getContainer(), this.getContainer().getSelectedChannel(), slot, mouseButton, hasClickedOutside, hasClickedInStorage, playerSlot != null ? playerSlot.field_75222_d : -1)) {
                    return;
                }
            }
        }
        super.func_146286_b(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (ClientProxy.FOCUS_LP_SEARCH.isActiveAndMatches(keyCode)) {
            this.fieldSearch.func_146195_b(true);
        } else if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_TAB_NEXT.isActiveAndMatches(keyCode)) {
            if (this.getContainer().getTabsClientCount() > 0) {
                this.setTabByIndex((this.getSelectedClientTabIndex() + 1) % this.getContainer().getTabsClientCount());
                this.playButtonClickSound();
            }
        } else if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_TAB_PREVIOUS.isActiveAndMatches(keyCode)) {
            if (this.getContainer().getTabsClientCount() > 0) {
                this.setTabByIndex((this.getContainer().getTabsClientCount() + this.getSelectedClientTabIndex() - 1) % this.getContainer().getTabsClientCount());
                this.playButtonClickSound();
            }
        } else if (this.fieldSearch.func_146201_a(typedChar, keyCode)) {
            this.getSelectedClientTab().ifPresent(tab -> tab.setInstanceFilter(this.getContainer().getSelectedChannel(), this.fieldSearch.func_146179_b()));
        } else if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_CRAFTINGGRID_CLEARPLAYER.isActiveAndMatches(keyCode)) {
            this.clearCraftingGrid(false);
            this.playButtonClickSound();
        } else if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_CRAFTINGGRID_CLEARSTORAGE.isActiveAndMatches(keyCode)) {
            this.clearCraftingGrid(true);
            this.playButtonClickSound();
        } else if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_CRAFTINGGRID_BALANCE.isActiveAndMatches(keyCode)) {
            this.balanceCraftingGrid();
            this.playButtonClickSound();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void clearCraftingGrid(boolean toStorage) {
        ITerminalStorageTabCommon commonTab = this.getContainer().getTabCommon(this.getContainer().getSelectedTab());
        if (commonTab instanceof TerminalStorageTabIngredientComponentItemStackCraftingCommon) {
            TerminalButtonItemStackCraftingGridClear.clearGrid((TerminalStorageTabIngredientComponentItemStackCraftingCommon)commonTab, this.getContainer().getSelectedChannel(), toStorage);
        }
    }

    protected void balanceCraftingGrid() {
        ITerminalStorageTabCommon commonTab = this.getContainer().getTabCommon(this.getContainer().getSelectedTab());
        if (commonTab instanceof TerminalStorageTabIngredientComponentItemStackCraftingCommon) {
            IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridBalance(commonTab.getName().toString()));
        }
    }

    private boolean hasClickedInStorage(int mouseX, int mouseY) {
        return mouseX >= this.getGuiLeftTotal() + this.getSlotsOffsetX() && mouseX < this.getGuiLeftTotal() + this.getSlotsOffsetX() + this.getSlotRowLength() * GuiHelpers.SLOT_SIZE - 1 && mouseY >= this.getGuiTopTotal() + this.getSlotsOffsetY() && mouseY < this.getGuiTopTotal() + this.getSlotsOffsetY() + this.getSlotVisibleRows() * GuiHelpers.SLOT_SIZE;
    }

    public int getStorageSlotIndexAtPosition(int mouseX, int mouseY) {
        if (this.hasClickedInStorage(mouseX, mouseY) && (mouseX - this.getGuiLeftTotal() - this.getSlotsOffsetX()) % GuiHelpers.SLOT_SIZE < GuiHelpers.SLOT_SIZE_INNER && (mouseY - this.getGuiTopTotal() - this.getSlotsOffsetY()) % GuiHelpers.SLOT_SIZE < GuiHelpers.SLOT_SIZE_INNER) {
            int rowLength = this.getSlotRowLength();
            int offset = this.getSelectedFirstRow() * rowLength;
            return offset + (mouseX - this.getGuiLeftTotal() - this.getSlotsOffsetX()) / GuiHelpers.SLOT_SIZE + (mouseY - this.getGuiTopTotal() - this.getSlotsOffsetY()) / GuiHelpers.SLOT_SIZE * this.getSlotRowLength();
        }
        return -1;
    }

    protected void drawTabsBackground() {
        int offsetX = TAB_OFFSET_X;
        this.func_73731_b(this.field_146289_q, L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.channel", (Object[])new Object[0]), this.getGuiLeft() + 30, this.getGuiTop() + 26, 0xFFFFFF);
        for (ITerminalStorageTabClient<?> tab : this.getContainer().getTabsClient().values()) {
            boolean selected = tab.getName().toString().equals(this.getContainer().getSelectedTab());
            int x = this.getGuiLeft() + offsetX;
            int y = this.getGuiTop();
            int width = TAB_WIDTH;
            int height = selected ? TAB_SELECTED_HEIGHT : TAB_UNSELECTED_HEIGHT;
            int textureX = selected ? TAB_SELECTED_TEXTURE_X : TAB_UNSELECTED_TEXTURE_X;
            int textureY = selected ? TAB_SELECTED_TEXTURE_Y : TAB_UNSELECTED_TEXTURE_Y;
            this.field_146297_k.field_71446_o.func_110577_a(this.texture);
            this.func_73729_b(x, y, textureX, textureY, width, height);
            ItemStack icon = tab.getIcon();
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            RenderHelper.func_74520_c();
            GlStateManager.func_179091_B();
            GL11.glEnable((int)2929);
            renderItem.func_180450_b(icon, x + TAB_ICON_OFFSET, y + TAB_ICON_OFFSET);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
            GL11.glDisable((int)2929);
            offsetX += width;
        }
    }

    protected int getSlotsOffsetX() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotOffsetX).orElse(31);
    }

    protected int getSlotsOffsetY() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotOffsetY).orElse(39);
    }

    protected int getSlotVisibleRows() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotVisibleRows).orElse(5);
    }

    protected int getSlotRowLength() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotRowLength).orElse(9);
    }

    protected int getSelectedFirstRow() {
        return this.firstRow;
    }

    protected void drawTabContents(String tabId, int channel, DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY) {
        Optional<ITerminalStorageTabClient<?>> optionalTab = this.getClientTab(tabId);
        if (optionalTab.isPresent()) {
            ITerminalStorageTabClient<?> tab = optionalTab.get();
            if (layer == DrawLayer.BACKGROUND) {
                this.func_73732_a(this.field_146289_q, tab.getStatus(channel), this.field_147003_i + 31 + GuiHelpers.SLOT_SIZE * 9 / 2, y + 2 + this.getSlotVisibleRows() * GuiHelpers.SLOT_SIZE, 0xFFFFFF);
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            }
            int rowLength = this.getSlotRowLength();
            int limit = this.getSlotVisibleRows() * rowLength;
            int offset = this.getSelectedFirstRow() * rowLength;
            List<?> slots = tab.getSlots(channel, offset, limit);
            int slotX = x;
            int slotY = y;
            int slotI = 0;
            for (ITerminalStorageSlot slot : slots) {
                if (layer == DrawLayer.BACKGROUND) {
                    RenderHelpers.bindTexture((ResourceLocation)this.texture);
                    if (RenderHelpers.isPointInRegion((int)slotX, (int)slotY, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)mouseX, (int)mouseY)) {
                        GuiTerminalStorage.func_73734_a((int)slotX, (int)slotY, (int)(slotX + GuiHelpers.SLOT_SIZE_INNER), (int)(slotY + GuiHelpers.SLOT_SIZE_INNER), (int)-2130706433);
                    }
                }
                this.field_73735_i = 200.0f;
                slot.drawGuiContainerLayer((GuiContainer)this, layer, partialTick, slotX, slotY, mouseX, mouseY, tab, channel, null);
                this.field_73735_i = 0.0f;
                if (++slotI >= rowLength) {
                    slotX = x;
                    slotY += GuiHelpers.SLOT_SIZE;
                    slotI = 0;
                    continue;
                }
                slotX += GuiHelpers.SLOT_SIZE;
            }
        } else {
            GlStateManager.func_179131_c((float)0.3f, (float)0.3f, (float)0.3f, (float)0.3f);
            GuiTerminalStorage.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x - 1 + GuiHelpers.SLOT_SIZE * this.getSlotRowLength()), (int)(y - 1 + GuiHelpers.SLOT_SIZE * this.getSlotVisibleRows()), (int)Helpers.RGBAToInt((int)50, (int)50, (int)50, (int)100));
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void drawActiveStorageSlotItem(int mouseX, int mouseY) {
        Optional<ITerminalStorageTabClient<?>> optionalTab = this.getSelectedClientTab();
        optionalTab.ifPresent(tab -> {
            int slotId = tab.getActiveSlotId();
            if (slotId >= 0) {
                int quantity = tab.getActiveSlotQuantity();
                List slots = tab.getSlots(this.getContainer().getSelectedChannel(), slotId, 1);
                if (!slots.isEmpty()) {
                    ITerminalStorageSlot slot = (ITerminalStorageSlot)slots.get(0);
                    RenderHelpers.bindTexture((ResourceLocation)this.texture);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (this.terminalDragSplitting && this.terminalDragSplittingSlots.size() > 1) {
                        quantity = this.terminalDragSplittingRemnant;
                    }
                    String quantityString = GuiHelpers.quantityToScaledString((long)quantity);
                    if (quantity == 0) {
                        quantityString = TextFormatting.YELLOW + quantityString;
                    }
                    slot.drawGuiContainerLayer((GuiContainer)this, DrawLayer.BACKGROUND, 0.0f, mouseX - this.field_147003_i - GuiHelpers.SLOT_SIZE_INNER / 4, mouseY - this.field_147009_r - GuiHelpers.SLOT_SIZE_INNER / 4, mouseX, mouseY, (ITerminalStorageTabClient)tab, this.getContainer().getSelectedChannel(), quantityString);
                }
            }
        });
    }

    protected Optional<ITerminalStorageTabClient<?>> getClientTab(String tab) {
        return Optional.ofNullable(this.getContainer().getTabsClient().get(tab));
    }

    protected Optional<ITerminalStorageTabCommon> getCommonTab(String tab) {
        return Optional.ofNullable(this.getContainer().getTabsCommon().get(tab));
    }

    public Optional<ITerminalStorageTabClient<?>> getSelectedClientTab() {
        return this.getClientTab(this.getContainer().getSelectedTab());
    }

    protected int getSelectedClientTabIndex() {
        Optional<ITerminalStorageTabClient<?>> selectedTab = this.getSelectedClientTab();
        if (selectedTab.isPresent()) {
            int tabIndex = 0;
            for (ITerminalStorageTabClient<?> tabClient : this.getContainer().getTabsClient().values()) {
                if (tabClient == selectedTab.get()) {
                    return tabIndex;
                }
                ++tabIndex;
            }
        }
        return -1;
    }

    protected void drawTabsForeground(int mouseX, int mouseY) {
        if (mouseY < this.getGuiTop() + TAB_UNSELECTED_HEIGHT && mouseX > this.getGuiLeft() + TAB_OFFSET_X && mouseX <= this.getGuiLeft() + TAB_OFFSET_X + (TAB_WIDTH * this.getContainer().getTabsClientCount() - 1)) {
            int tabIndex = (mouseX - TAB_OFFSET_X - this.getGuiLeft()) / TAB_WIDTH;
            this.getTabByIndex(tabIndex).ifPresent(tab -> this.drawTooltip(tab.getTooltip(), mouseX - this.getGuiLeft(), mouseY - this.getGuiTop()));
        }
    }

    public GuiTextFieldExtended getFieldSearch() {
        return this.fieldSearch;
    }

    public static enum DrawLayer {
        BACKGROUND,
        FOREGROUND;

    }
}

