/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integrateddynamics.block.BlockEnergyBattery;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.client.gui.container.GuiTerminalStorage;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;

public class IngredientComponentTerminalStorageHandlerEnergy
implements IIngredientComponentTerminalStorageHandler<Integer, Boolean> {
    private final IngredientComponent<Integer, Boolean> ingredientComponent;

    public IngredientComponentTerminalStorageHandlerEnergy(IngredientComponent<Integer, Boolean> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    @Override
    public IngredientComponent<Integer, Boolean> getComponent() {
        return this.ingredientComponent;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((Block)BlockEnergyBattery.getInstance());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInstance(Integer instance, long maxQuantity, @Nullable String label, GuiContainer gui, GuiTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, @Nullable List<String> additionalTooltipLines) {
        if (instance > 0) {
            if (layer == GuiTerminalStorage.DrawLayer.BACKGROUND) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderHelper.func_74520_c();
                RenderHelpers.bindTexture((ResourceLocation)Images.ICONS);
                gui.func_73729_b(x, y, 0, 240, GuiHelpers.SLOT_SIZE_INNER, GuiHelpers.SLOT_SIZE_INNER);
                GuiHelpers.renderProgressBar((Gui)gui, (int)x, (int)y, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)16, (int)240, (GuiHelpers.ProgressDirection)GuiHelpers.ProgressDirection.UP, (int)instance, (int)((int)maxQuantity));
                RenderItemExtendedSlotCount.drawSlotText((FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)(label != null ? label : GuiHelpers.quantityToScaledString((long)instance.intValue())), (int)x, (int)y);
                RenderHelper.func_74518_a();
            } else {
                GuiHelpers.renderTooltip((GuiContainer)gui, (int)x, (int)y, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)mouseX, (int)mouseY, () -> {
                    ArrayList lines = Lists.newArrayList();
                    lines.add(L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.tooltip.energy", (Object[])new Object[0]));
                    this.addQuantityTooltip(lines, instance);
                    if (additionalTooltipLines != null) {
                        lines.addAll(additionalTooltipLines);
                    }
                    return lines;
                });
            }
        }
    }

    @Override
    public String formatQuantity(Integer instance) {
        return L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.tooltip.energy.amount", (Object[])new Object[]{String.format("%,d", instance)});
    }

    @Override
    public boolean isInstance(ItemStack itemStack) {
        return itemStack.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    @Override
    public Integer getInstance(ItemStack itemStack) {
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage != null) {
            return energyStorage.getEnergyStored();
        }
        return 0;
    }

    @Override
    public long getMaxQuantity(ItemStack itemStack) {
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage != null) {
            return energyStorage.getMaxEnergyStored();
        }
        return 0L;
    }

    @Override
    public int getInitialInstanceMovementQuantity() {
        return GeneralConfig.guiStorageEnergyInitialQuantity;
    }

    @Override
    public int getIncrementalInstanceMovementQuantity() {
        return GeneralConfig.guiStorageEnergyIncrementalQuantity;
    }

    @Override
    public int throwIntoWorld(IIngredientComponentStorage<Integer, Boolean> storage, Integer maxInstance, EntityPlayer player) {
        return 0;
    }

    protected IIngredientComponentStorage<Integer, Boolean> getEnergyStorage(IngredientComponent<Integer, Boolean> component, IEnergyStorage energyStorage) {
        return component.getStorageWrapperHandler(CapabilityEnergy.ENERGY).wrapComponentStorage((Object)energyStorage);
    }

    @Override
    public Integer insertIntoContainer(IIngredientComponentStorage<Integer, Boolean> storage, Container container, int containerSlot, Integer maxInstance, @Nullable EntityPlayer player, boolean transferFullSelection) {
        ItemStack stack = container.func_75139_a(containerSlot).func_75211_c();
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage != null) {
            IIngredientComponentStorage<Integer, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Integer, Boolean>)storage.getComponent(), energyStorage);
            Integer ret = 0;
            try {
                ret = (Integer)IngredientStorageHelpers.moveIngredientsIterative(storage, itemStorage, (long)maxInstance.intValue(), (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.func_75142_b();
            return ret;
        }
        return 0;
    }

    @Override
    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<Integer, Boolean> storage, InventoryPlayer playerInventory, long moveQuantityPlayerSlot) {
        ItemStack playerStack = playerInventory.func_70445_o();
        IEnergyStorage energyStorage = (IEnergyStorage)playerStack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage != null) {
            IIngredientComponentStorage<Integer, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Integer, Boolean>)storage.getComponent(), energyStorage);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, storage, (long)moveQuantityPlayerSlot, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
        }
    }

    @Override
    public void extractMaxFromContainerSlot(IIngredientComponentStorage<Integer, Boolean> storage, Container container, int containerSlot, InventoryPlayer playerInventory) {
        ItemStack toMoveStack = container.func_75139_a(containerSlot).func_75211_c();
        IEnergyStorage energyStorage = (IEnergyStorage)toMoveStack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage != null) {
            IIngredientComponentStorage<Integer, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Integer, Boolean>)storage.getComponent(), energyStorage);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, storage, (long)Long.MAX_VALUE, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
        }
    }

    @Override
    public long getActivePlayerStackQuantity(InventoryPlayer playerInventory) {
        ItemStack toMoveStack = playerInventory.func_70445_o();
        IEnergyStorage energyStorage = (IEnergyStorage)toMoveStack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage != null) {
            return energyStorage.getEnergyStored();
        }
        return 0L;
    }

    @Override
    public void drainActivePlayerStackQuantity(InventoryPlayer playerInventory, long quantity) {
        ItemStack toMoveStack = playerInventory.func_70445_o();
        IEnergyStorage energyStorage = (IEnergyStorage)toMoveStack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage != null) {
            int drained;
            while (quantity > 0L && (drained = energyStorage.extractEnergy((int)quantity, false)) > 0) {
                quantity -= (long)drained;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Predicate<Integer> getInstanceFilterPredicate(SearchMode searchMode, String query) {
        return integer -> true;
    }

    @Override
    public Collection<IIngredientInstanceSorter<Integer>> getInstanceSorters() {
        return Collections.emptyList();
    }
}

