/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.terminalstorage.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;

public class TerminalCraftingPlanStatic<I>
implements ITerminalCraftingPlan<I> {
    private final I id;
    private final List<ITerminalCraftingPlan<I>> dependencies;
    private final List<IPrototypedIngredient<?, ?>> outputs;
    private TerminalCraftingJobStatus status;
    private final long craftingQuantity;
    private final List<IPrototypedIngredient<?, ?>> storageIngredients;
    private final List<List<IPrototypedIngredient<?, ?>>> lastMissingIngredients;
    private String unlocalizedLabel;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;

    public TerminalCraftingPlanStatic(I id, List<ITerminalCraftingPlan<I>> dependencies, List<IPrototypedIngredient<?, ?>> outputs, TerminalCraftingJobStatus status, long craftingQuantity, List<IPrototypedIngredient<?, ?>> storageIngredients, List<List<IPrototypedIngredient<?, ?>>> lastMissingIngredients, String unlocalizedLabel, long tickDuration, int channel, @Nullable String initiatorName) {
        this.id = id;
        this.dependencies = dependencies;
        this.outputs = outputs;
        this.status = status;
        this.craftingQuantity = craftingQuantity;
        this.storageIngredients = storageIngredients;
        this.lastMissingIngredients = lastMissingIngredients;
        this.unlocalizedLabel = unlocalizedLabel;
        this.tickDuration = tickDuration;
        this.channel = channel;
        this.initiatorName = initiatorName;
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public List<ITerminalCraftingPlan<I>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getOutputs() {
        return this.outputs;
    }

    @Override
    public TerminalCraftingJobStatus getStatus() {
        return this.status;
    }

    @Override
    public long getCraftingQuantity() {
        return this.craftingQuantity;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getStorageIngredients() {
        return this.storageIngredients;
    }

    @Override
    public List<List<IPrototypedIngredient<?, ?>>> getLastMissingIngredients() {
        return this.lastMissingIngredients;
    }

    @Override
    public String getUnlocalizedLabel() {
        return this.unlocalizedLabel;
    }

    @Override
    public long getTickDuration() {
        return this.tickDuration;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public void setError(String unlocalizedError) {
        this.status = TerminalCraftingJobStatus.ERROR;
        this.unlocalizedLabel = unlocalizedError;
    }

    public static <I> NBTTagCompound serialize(TerminalCraftingPlanStatic<I> plan, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("id", handler.serializeCraftingJobId(plan.getId()));
        NBTTagList dependencies = new NBTTagList();
        for (ITerminalCraftingPlan<I> iTerminalCraftingPlan : plan.getDependencies()) {
            dependencies.func_74742_a((NBTBase)TerminalCraftingPlanStatic.serialize((TerminalCraftingPlanStatic)iTerminalCraftingPlan, handler));
        }
        tag.func_74782_a("dependencies", (NBTBase)dependencies);
        NBTTagList outputs = new NBTTagList();
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getOutputs()) {
            outputs.func_74742_a((NBTBase)IPrototypedIngredient.serialize((IPrototypedIngredient)((PrototypedIngredient)iPrototypedIngredient)));
        }
        tag.func_74782_a("outputs", (NBTBase)outputs);
        tag.func_74768_a("status", plan.getStatus().ordinal());
        tag.func_74772_a("craftingQuantity", plan.getCraftingQuantity());
        NBTTagList nBTTagList = new NBTTagList();
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getStorageIngredients()) {
            nBTTagList.func_74742_a((NBTBase)IPrototypedIngredient.serialize((IPrototypedIngredient)((PrototypedIngredient)iPrototypedIngredient)));
        }
        tag.func_74782_a("storageIngredients", (NBTBase)nBTTagList);
        NBTTagList nBTTagList2 = new NBTTagList();
        for (List<IPrototypedIngredient<?, ?>> lastMissingIngredient : plan.getLastMissingIngredients()) {
            NBTTagList lastMissingIngredientTag = new NBTTagList();
            for (IPrototypedIngredient<?, ?> prototypedIngredient : lastMissingIngredient) {
                lastMissingIngredientTag.func_74742_a((NBTBase)IPrototypedIngredient.serialize((IPrototypedIngredient)((PrototypedIngredient)prototypedIngredient)));
            }
            nBTTagList2.func_74742_a((NBTBase)lastMissingIngredientTag);
        }
        tag.func_74782_a("lastMissingIngredients", (NBTBase)nBTTagList2);
        tag.func_74778_a("unlocalizedLabel", plan.getUnlocalizedLabel());
        tag.func_74772_a("tickDuration", plan.getTickDuration());
        tag.func_74768_a("channel", plan.getChannel());
        if (plan.getInitiatorName() != null) {
            tag.func_74778_a("initiatorName", plan.getInitiatorName());
        }
        return tag;
    }

    public static <I> TerminalCraftingPlanStatic<I> deserialize(NBTTagCompound tag, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        if (!tag.func_74764_b("id")) {
            throw new IllegalArgumentException("Could not find an id entry in the given tag");
        }
        if (!tag.func_150297_b("dependencies", 9)) {
            throw new IllegalArgumentException("Could not find a dependencies entry in the given tag");
        }
        if (!tag.func_150297_b("outputs", 9)) {
            throw new IllegalArgumentException("Could not find a outputs entry in the given tag");
        }
        if (!tag.func_150297_b("status", 3)) {
            throw new IllegalArgumentException("Could not find a status entry in the given tag");
        }
        if (!tag.func_150297_b("craftingQuantity", 4)) {
            throw new IllegalArgumentException("Could not find a craftingQuantity entry in the given tag");
        }
        if (!tag.func_150297_b("storageIngredients", 9)) {
            throw new IllegalArgumentException("Could not find a storageIngredients entry in the given tag");
        }
        if (!tag.func_150297_b("lastMissingIngredients", 9)) {
            throw new IllegalArgumentException("Could not find a lastMissingIngredients entry in the given tag");
        }
        if (!tag.func_150297_b("unlocalizedLabel", 8)) {
            throw new IllegalArgumentException("Could not find a unlocalizedLabel entry in the given tag");
        }
        if (!tag.func_150297_b("tickDuration", 4)) {
            throw new IllegalArgumentException("Could not find a tickDuration entry in the given tag");
        }
        if (!tag.func_150297_b("channel", 3)) {
            throw new IllegalArgumentException("Could not find a channel entry in the given tag");
        }
        I id = handler.deserializeCraftingJobId(tag.func_74781_a("id"));
        NBTTagList dependenciesTag = tag.func_150295_c("dependencies", 10);
        ArrayList dependencies = Lists.newArrayListWithExpectedSize((int)dependenciesTag.func_74745_c());
        for (NBTBase nbtBase : dependenciesTag) {
            dependencies.add(TerminalCraftingPlanStatic.deserialize((NBTTagCompound)nbtBase, handler));
        }
        NBTTagList outputsTag = tag.func_150295_c("outputs", 10);
        ArrayList outputs = Lists.newArrayListWithExpectedSize((int)outputsTag.func_74745_c());
        for (NBTBase nbtBase : outputsTag) {
            outputs.add(IPrototypedIngredient.deserialize((NBTTagCompound)((NBTTagCompound)nbtBase)));
        }
        TerminalCraftingJobStatus status = TerminalCraftingJobStatus.values()[tag.func_74762_e("status")];
        long craftingQuantity = tag.func_74763_f("craftingQuantity");
        NBTTagList storageIngredientsTag = tag.func_150295_c("storageIngredients", 10);
        ArrayList storageIngredients = Lists.newArrayListWithExpectedSize((int)storageIngredientsTag.func_74745_c());
        for (NBTBase nbtBase : storageIngredientsTag) {
            storageIngredients.add(IPrototypedIngredient.deserialize((NBTTagCompound)((NBTTagCompound)nbtBase)));
        }
        NBTTagList lastMissingIngredientsTag = tag.func_150295_c("lastMissingIngredients", 9);
        ArrayList lastMissingIngredients = Lists.newArrayListWithExpectedSize((int)lastMissingIngredientsTag.func_74745_c());
        for (NBTBase nbtBase : lastMissingIngredientsTag) {
            NBTTagList list = (NBTTagList)nbtBase;
            ArrayList lastMissingIngredient = Lists.newArrayListWithExpectedSize((int)list.func_74745_c());
            for (NBTBase base : list) {
                lastMissingIngredient.add(IPrototypedIngredient.deserialize((NBTTagCompound)((NBTTagCompound)base)));
            }
            lastMissingIngredients.add(lastMissingIngredient);
        }
        String unlocalizedLabel = tag.func_74779_i("unlocalizedLabel");
        long tickDuration = tag.func_74763_f("tickDuration");
        int channel = tag.func_74762_e("channel");
        String initiatorName = null;
        if (tag.func_150297_b("initiatorName", 8)) {
            initiatorName = tag.func_74779_i("initiatorName");
        }
        return new TerminalCraftingPlanStatic<I>(id, dependencies, outputs, status, craftingQuantity, storageIngredients, lastMissingIngredients, unlocalizedLabel, tickDuration, channel, initiatorName);
    }
}

