/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.ingredient;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.client.gui.container.GuiTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;

public interface IIngredientComponentTerminalStorageHandler<T, M> {
    public IngredientComponent<T, M> getComponent();

    public ItemStack getIcon();

    @SideOnly(value=Side.CLIENT)
    public void drawInstance(T var1, long var2, @Nullable String var4, GuiContainer var5, GuiTerminalStorage.DrawLayer var6, float var7, int var8, int var9, int var10, int var11, @Nullable List<String> var12);

    default public void addQuantityTooltip(List<String> lines, T instance) {
        String line = TextFormatting.DARK_GRAY + L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.tooltip.quantity", (Object[])new Object[]{this.formatQuantity(instance)});
        if (lines.size() <= 1) {
            lines.add(line);
        } else {
            lines.add(1, line);
        }
    }

    public String formatQuantity(T var1);

    public boolean isInstance(ItemStack var1);

    public T getInstance(ItemStack var1);

    public long getMaxQuantity(ItemStack var1);

    public int getInitialInstanceMovementQuantity();

    public int getIncrementalInstanceMovementQuantity();

    public int throwIntoWorld(IIngredientComponentStorage<T, M> var1, T var2, EntityPlayer var3);

    default public void insertMaxIntoContainer(IIngredientComponentStorage<T, M> storage, Container container, int containerSlotStart, int containerSlotEnd, T instance) {
        IIngredientMatcher matcher = storage.getComponent().getMatcher();
        Object toAdd = instance;
        int slot = containerSlotStart;
        while (!matcher.isEmpty(toAdd) && slot < containerSlotEnd) {
            T moved;
            if (matcher.isEmpty(moved = this.insertIntoContainer(storage, container, slot++, toAdd, null, true))) continue;
            toAdd = matcher.withQuantity(toAdd, Math.max(0L, matcher.getQuantity(toAdd) - matcher.getQuantity(moved)));
        }
    }

    public T insertIntoContainer(IIngredientComponentStorage<T, M> var1, Container var2, int var3, T var4, @Nullable EntityPlayer var5, boolean var6);

    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<T, M> var1, InventoryPlayer var2, long var3);

    public void extractMaxFromContainerSlot(IIngredientComponentStorage<T, M> var1, Container var2, int var3, InventoryPlayer var4);

    public long getActivePlayerStackQuantity(InventoryPlayer var1);

    public void drainActivePlayerStackQuantity(InventoryPlayer var1, long var2);

    @SideOnly(value=Side.CLIENT)
    public Predicate<T> getInstanceFilterPredicate(SearchMode var1, String var2);

    public Collection<IIngredientInstanceSorter<T>> getInstanceSorters();
}

