/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals;

import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.DummyConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.IModVersion;
import org.cyclops.cyclopscore.tracking.Versions;
import org.cyclops.integratedterminals.IntegratedTerminals;

public class GeneralConfig
extends DummyConfig {
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Config version for Integrated Terminals.\nDO NOT EDIT MANUALLY!")
    public static String version = "1.0.14";
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Set 'true' to enable development debug mode. This will result in a lower performance!", requiresMcRestart=true)
    public static boolean debug = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the recipe loader should crash when finding invalid recipes.", requiresMcRestart=true)
    public static boolean crashOnInvalidRecipe = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If mod compatibility loader should crash hard if errors occur in that process.", requiresMcRestart=true)
    public static boolean crashOnModCompatCrash = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If an anonymous mod startup analytics request may be sent to our analytics service.")
    public static boolean analytics = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the version checker should be enabled.")
    public static boolean versionChecker = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="The maximum number of terminal storage instances that can be sent in a single packet. Reduce this when you have packet overflows.", isCommandable=true)
    public static int terminalStoragePacketMaxInstances = 1024;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The number of items that should be selected when clicking on an item in the storage terminal.", isCommandable=true)
    public static int guiStorageItemInitialQuantity = 64;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The number of items that should be removed when right-clicking when an item is selected in the storage terminal.", isCommandable=true)
    public static int guiStorageItemIncrementalQuantity = 1;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The number of items that should be selected when clicking on a fluid in the storage terminal.", isCommandable=true)
    public static int guiStorageFluidInitialQuantity = 100000;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The number of items that should be removed when right-clicking when a fluid is selected in the storage terminal.", isCommandable=true)
    public static int guiStorageFluidIncrementalQuantity = 1000;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The number of items that should be selected when clicking on energy in the storage terminal.", isCommandable=true)
    public static int guiStorageEnergyInitialQuantity = 100000;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The number of items that should be removed when right-clicking when energy is selected in the storage terminal.", isCommandable=true)
    public static int guiStorageEnergyIncrementalQuantity = 1000;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The update frequency in milliseconds for the crafting jobs gui.", isCommandable=true)
    public static int guiTerminalCraftingJobsUpdateFrequency = 1000;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="The number of threads that the crafting plan calculator can use.", minimalValue=1, requiresMcRestart=true)
    public static int craftingPlannerThreads = 2;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the crafting planners can work on separate thread.", isCommandable=true)
    public static boolean craftingPlannerEnableMultithreading = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="The base energy usage for the crafting terminal.", minimalValue=0)
    public static int terminalCraftingBaseConsumption = 1;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="The base energy usage for the storage terminal.", minimalValue=0)
    public static int terminalStorageBaseConsumption = 2;
    public static ConfigurableType TYPE = ConfigurableType.DUMMY;

    public GeneralConfig() {
        super((ModBase)IntegratedTerminals._instance, true, "general", null, GeneralConfig.class);
    }

    public void onRegistered() {
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_INVALID_RECIPE, (Object)crashOnInvalidRecipe);
        this.getMod().putGenericReference(ModBase.REFKEY_DEBUGCONFIG, (Object)debug);
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_MODCOMPAT_CRASH, (Object)crashOnModCompatCrash);
        if (analytics) {
            Analytics.registerMod((ModBase)this.getMod(), (String)"UA-65307010-18");
        }
        if (versionChecker) {
            Versions.registerMod((ModBase)this.getMod(), (IModVersion)IntegratedTerminals._instance, (String)"https://raw.githubusercontent.com/CyclopsMC/Versions/master/1.12/IntegratedTerminals.txt");
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

