/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import com.google.common.base.Predicate;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.apache.commons.io.FileUtils;
import reborncore.common.misc.ChunkCoord;
import techreborn.Core;
import techreborn.init.ModBlocks;
import techreborn.world.RubberTreeGenerator;
import techreborn.world.TechRebornRetroGen;
import techreborn.world.config.OreConfig;
import techreborn.world.config.WorldGenConfig;

public class TechRebornWorldGen
implements IWorldGenerator {
    public static RubberTreeGenerator treeGenerator = new RubberTreeGenerator();
    public final TechRebornRetroGen retroGen = new TechRebornRetroGen();
    public File configFile;
    public boolean jsonInvalid = false;
    public WorldGenConfig config;
    WorldGenConfig defaultConfig;

    private void init() {
        this.defaultConfig = new WorldGenConfig();
        this.defaultConfig.overworldOres = new ArrayList<OreConfig>();
        this.defaultConfig.endOres = new ArrayList<OreConfig>();
        this.defaultConfig.neatherOres = new ArrayList<OreConfig>();
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Galena"), 8, 16, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Iridium"), 3, 3, 5, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Ruby"), 6, 3, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Sapphire"), 6, 3, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Bauxite"), 6, 10, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Lead"), 6, 16, 20, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Silver"), 6, 16, 20, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("copper"), 8, 16, 20, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("tin"), 8, 16, 20, 60));
        this.defaultConfig.neatherOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Pyrite"), 6, 3, 10, 126));
        this.defaultConfig.neatherOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Cinnabar"), 6, 3, 10, 126));
        this.defaultConfig.neatherOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Sphalerite"), 6, 3, 10, 126));
        this.defaultConfig.endOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Tungsten"), 6, 3, 10, 250));
        this.defaultConfig.endOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Sheldonite"), 6, 3, 10, 250));
        this.defaultConfig.endOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Peridot"), 6, 3, 10, 250));
        this.defaultConfig.endOres.add(new OreConfig(ModBlocks.ORE.getBlockStateFromName("Sodalite"), 6, 3, 10, 250));
    }

    public void load() {
        this.init();
        if (this.configFile.exists()) {
            this.loadFromJson();
        } else {
            this.config = this.defaultConfig;
            this.jsonInvalid = true;
        }
        this.config.overworldOres.addAll(this.getMissingOres(this.config.overworldOres, this.defaultConfig.overworldOres));
        this.config.neatherOres.addAll(this.getMissingOres(this.config.neatherOres, this.defaultConfig.neatherOres));
        this.config.endOres.addAll(this.getMissingOres(this.config.endOres, this.defaultConfig.endOres));
        if (this.jsonInvalid) {
            this.save();
        }
    }

    private List<OreConfig> getMissingOres(List<OreConfig> config, List<OreConfig> defaultOres) {
        ArrayList<OreConfig> missingOres = new ArrayList<OreConfig>();
        for (OreConfig defaultOre : defaultOres) {
            boolean hasFoundOre = false;
            for (OreConfig ore : config) {
                if (!ore.blockName.replaceAll(":", ".").equals(defaultOre.blockName.replaceAll(":", ".")) || ore.meta != defaultOre.meta) continue;
                hasFoundOre = true;
                ore.state = defaultOre.state;
                break;
            }
            if (hasFoundOre) continue;
            missingOres.add(defaultOre);
        }
        return missingOres;
    }

    private void loadFromJson() {
        try {
            Gson gson = new Gson();
            String jsonString = FileUtils.readFileToString((File)this.configFile, (Charset)Charset.defaultCharset());
            this.config = (WorldGenConfig)gson.fromJson(jsonString, WorldGenConfig.class);
        }
        catch (Exception e) {
            Core.logHelper.error((Object)"The ores.json file was invalid, bad things are about to happen, I will try and save the world now :");
            this.config = this.defaultConfig;
            this.jsonInvalid = true;
            Core.logHelper.error((Object)"The ores.json file was ignored and the default values loaded, you file will NOT be over written");
            e.printStackTrace();
        }
    }

    public void printError(String string) {
        Core.logHelper.error((Object)"###############-ERROR-####################");
        Core.logHelper.error((Object)"");
        Core.logHelper.error((Object)string);
        Core.logHelper.error((Object)"");
        Core.logHelper.error((Object)"###############-ERROR-####################");
    }

    private void save() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)this.config);
        try {
            FileUtils.writeStringToFile((File)this.configFile, (String)json, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<OreConfig> getAllGenOresFromList(List<OreConfig> configList) {
        ArrayList<OreConfig> list = new ArrayList<OreConfig>();
        for (OreConfig config : configList) {
            if (config.veinSize == 0 || config.veinsPerChunk == 0 || !config.shouldSpawn) continue;
            list.add(config);
        }
        return list;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!this.config.generateTechRebornFeatures) {
            return;
        }
        boolean genTree = false;
        ArrayList<OreConfig> list = new ArrayList<OreConfig>();
        BlockMatcher predicate = BlockMatcher.func_177642_a((Block)Blocks.field_150348_b);
        if (world.field_73011_w.getDimension() == -1) {
            list.addAll(this.getAllGenOresFromList(this.config.neatherOres));
            predicate = BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL);
        } else if (world.field_73011_w.getDimension() == 1) {
            list.addAll(this.getAllGenOresFromList(this.config.endOres));
            predicate = BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs);
        } else if (this.config.overworldOresInModdedDims || world.field_73011_w.getDimension() == 0) {
            list.addAll(this.getAllGenOresFromList(this.config.overworldOres));
            genTree = true;
        }
        if (!list.isEmpty() && this.config.generateOres) {
            for (OreConfig ore : list) {
                WorldGenMinable worldGenMinable = new WorldGenMinable(ore.state, ore.veinSize, (Predicate)predicate);
                if (ore.state == null) continue;
                for (int i = 0; i < ore.veinsPerChunk; ++i) {
                    int xPos = chunkX * 16 + random.nextInt(16);
                    if (ore.maxYHeight == -1 || ore.minYHeight == -1) continue;
                    int yPos = ore.minYHeight + random.nextInt(ore.maxYHeight - ore.minYHeight);
                    int zPos = chunkZ * 16 + random.nextInt(16);
                    BlockPos pos = new BlockPos(xPos, yPos, zPos);
                    if (ore.veinSize < 4) {
                        for (int j = 1; j < ore.veinSize; ++j) {
                            BlockPos smallVeinPos = pos.func_177982_a(8, 0, 8);
                            smallVeinPos.func_177982_a(random.nextInt(2), random.nextInt(2), random.nextInt(2));
                            IBlockState blockState = world.func_180495_p(smallVeinPos);
                            if (!blockState.func_177230_c().isReplaceableOreGen(blockState, (IBlockAccess)world, smallVeinPos, (Predicate)predicate)) continue;
                            world.func_180501_a(smallVeinPos, ore.state, 2);
                        }
                        continue;
                    }
                    try {
                        worldGenMinable.func_180709_b(world, random, pos);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        Core.logHelper.error((Object)("Something bad is happening during world gen the ore " + ore.blockNiceName + " caused a crash when generating. Report this to the TechReborn devs with a log"));
                    }
                }
            }
        }
        if (genTree && this.config.rubberTreeConfig.shouldSpawn) {
            int chance = this.config.rubberTreeConfig.chance;
            boolean isValidSpawn = false;
            Biome biomeGenBase = world.getBiomeForCoordsBody(new BlockPos(chunkX * 16, 72, chunkZ * 16));
            if (biomeGenBase.getRegistryName() != null && Arrays.asList(this.config.rubberTreeConfig.rubberTreeBiomeBlacklist).contains(biomeGenBase.getRegistryName().toString())) {
                return;
            }
            if (BiomeDictionary.hasType((Biome)biomeGenBase, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                chance -= random.nextInt(10) + 10;
                isValidSpawn = true;
            }
            if (BiomeDictionary.hasType((Biome)biomeGenBase, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biomeGenBase, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                chance -= random.nextInt(5) + 3;
                isValidSpawn = true;
            }
            if (!isValidSpawn) {
                return;
            }
            if (chance <= 0) {
                chance = 1;
            }
            if (random.nextInt(chance) == 0) {
                int x = chunkX * 16;
                int z = chunkZ * 16;
                for (int i = 0; i < this.config.rubberTreeConfig.clusterSize; ++i) {
                    treeGenerator.func_180709_b(world, random, new BlockPos(x, 72, z));
                }
            }
        }
        this.retroGen.markChunk(ChunkCoord.of((int)chunkX, (int)chunkZ));
    }
}

