/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier0;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import reborncore.api.IToolDrop;
import reborncore.api.praescriptum.Utils.IngredientUtils;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.api.praescriptum.recipes.RecipeHandler;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.tile.RebornMachineTile;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.recipe.Recipes;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileIronAlloyFurnace
extends RebornMachineTile
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(4, "TileIronAlloyFurnace", 64, (TileEntity)this);
    public int burnTime;
    public int burnTimeTotal;
    public int cookTime;
    private int cookTimeTotal = 200;
    protected final int[] inputSlots;
    int outputSlot = 2;
    int fuel = 3;
    protected Recipe recipe = null;
    public final RecipeHandler recipeHandler = Recipes.alloySmelter;

    public TileIronAlloyFurnace() {
        this.inputSlots = new int[]{0, 1};
    }

    private void reset() {
        this.cookTime = 0;
        this.recipe = null;
    }

    private boolean canWork() {
        Recipe temp;
        boolean canUse;
        ImmutableList inputs = (ImmutableList)Arrays.stream(this.inputSlots).mapToObj(arg_0 -> ((Inventory)this.inventory).func_70301_a(arg_0)).filter(contents -> !contents.func_190926_b()).collect(ImmutableList.toImmutableList());
        if (this.recipe != null && !(canUse = this.recipeHandler.apply(this.recipe, (Collection)inputs, true))) {
            this.reset();
        }
        if ((temp = this.recipe) != null) {
            return Arrays.stream(this.recipe.getItemOutputs()).allMatch(output -> this.addToOutputs(output.func_77946_l(), true) == output.func_190916_E());
        }
        temp = this.recipeHandler.findRecipe((Collection)inputs);
        if (temp == null) {
            return false;
        }
        this.updateRecipe(temp);
        return Arrays.stream(this.recipe.getItemOutputs()).allMatch(output -> this.addToOutputs(output.func_77946_l(), true) == output.func_190916_E());
    }

    private void smeltItem() {
        ImmutableList inputs = (ImmutableList)Arrays.stream(this.inputSlots).mapToObj(arg_0 -> ((Inventory)this.inventory).func_70301_a(arg_0)).filter(contents -> !contents.func_190926_b()).collect(ImmutableList.toImmutableList());
        if (inputs.isEmpty()) {
            return;
        }
        this.recipeHandler.apply(this.recipe, (Collection)inputs, false);
        Arrays.stream(this.recipe.getItemOutputs()).forEach(output -> this.addToOutputs(output.func_77946_l(), false));
        this.cookTime = 0;
    }

    private int addToOutputs(ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int remaining = stack.func_190916_E();
        if (remaining <= 0) {
            return 0;
        }
        ItemStack contents = this.inventory.func_70301_a(this.outputSlot);
        int transfered = Math.min(remaining, Math.min(this.inventory.func_70297_j_(), stack.func_77976_d()) - contents.func_190916_E());
        if (!contents.func_190926_b() && ItemUtils.isItemEqual((ItemStack)contents, (ItemStack)stack, (boolean)true, (boolean)true)) {
            if (!simulate) {
                this.inventory.func_70299_a(this.outputSlot, ItemUtils.increaseSize((ItemStack)contents, (int)transfered));
            }
            remaining -= transfered;
        } else if (contents.func_190926_b()) {
            if (!simulate) {
                ItemStack temp = ItemUtils.setSize((ItemStack)stack.func_77946_l(), (int)transfered);
                this.inventory.func_70299_a(this.outputSlot, temp);
            }
            remaining -= transfered;
        }
        return stack.func_190916_E() - remaining;
    }

    private void updateRecipe(Recipe recipe) {
        this.reset();
        this.recipe = recipe;
    }

    public int getItemBurnTime(ItemStack stack) {
        return stack.func_190926_b() ? 0 : (int)((double)TileEntityFurnace.func_145952_a((ItemStack)stack) * 1.25);
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.burnTimeTotal == 0) {
            this.burnTimeTotal = this.getItemBurnTime(this.func_70301_a(this.fuel));
        }
        return this.burnTime * scale / this.burnTimeTotal;
    }

    public int getCookProgressScaled(int scale) {
        return this.cookTime * scale / this.cookTimeTotal;
    }

    public void func_73660_a() {
        super.func_73660_a();
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (burning) {
            --this.burnTime;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack fuelStack = this.func_70301_a(this.fuel);
        if (this.burnTime != 0 || !this.func_70301_a(this.inputSlots[0]).func_190926_b() && !fuelStack.func_190926_b()) {
            if (this.burnTime == 0 && this.canWork()) {
                this.burnTimeTotal = this.burnTime = this.getItemBurnTime(fuelStack);
                if (this.burnTime > 0) {
                    updateInventory = true;
                    if (!fuelStack.func_190926_b()) {
                        this.func_70298_a(this.fuel, 1);
                    }
                }
            }
            if (this.isBurning() && this.canWork()) {
                if (!this.isActive()) {
                    this.setActive(true);
                }
                ++this.cookTime;
                if (this.cookTime == this.cookTimeTotal) {
                    this.cookTime = 0;
                    this.smeltItem();
                    updateInventory = true;
                    this.setActive(false);
                }
            } else {
                this.cookTime = 0;
                this.setActive(false);
            }
        }
        if (burning != this.isBurning()) {
            updateInventory = true;
        }
        if (updateInventory) {
            this.func_70296_d();
        }
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound data = tag.func_74775_l("TileIronAlloyFurnace");
        this.cookTime = data.func_74764_b("cooktime") ? data.func_74762_e("cooktime") : 0;
        this.burnTime = data.func_74764_b("burntime") ? data.func_74762_e("burntime") : 0;
        this.burnTimeTotal = data.func_74764_b("burntimetotal") ? data.func_74762_e("burntimetotal") : 0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("cooktime", this.cookTime);
        data.func_74768_a("burntime", this.burnTime);
        data.func_74768_a("burntimetotal", this.burnTimeTotal);
        tag.func_74782_a("TileIronAlloyFurnace", (NBTBase)data);
        return tag;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.IRON_ALLOY_FURNACE, 1);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("alloyfurnace").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).filterSlot(0, 47, 17, IngredientUtils.isPartOfRecipe((RecipeHandler)this.recipeHandler)).filterSlot(1, 65, 17, IngredientUtils.isPartOfRecipe((RecipeHandler)this.recipeHandler)).outputSlot(2, 116, 35).fuelSlot(3, 56, 53).syncIntegerValue(this::getBurnTime, this::setBurnTime).syncIntegerValue(this::getCookTime, this::setCookTime).syncIntegerValue(this::getCurrentItemBurnTime, this::setCurrentItemBurnTime).addInventory().create((RebornMachineTile)this);
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getCurrentItemBurnTime() {
        return this.burnTimeTotal;
    }

    public void setCurrentItemBurnTime(int currentItemBurnTime) {
        this.burnTimeTotal = currentItemBurnTime;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(int cookTime) {
        this.cookTime = cookTime;
    }
}

