/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.processing;

import java.util.ArrayDeque;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.api.scriba.RegisterTile;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.RebornMachineTile;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.init.IC2Duplicates;
import techreborn.init.ModBlocks;
import techreborn.items.ingredients.ItemParts;

@RebornRegistry(modID="techreborn")
@RegisterTile(name="recycler")
public class TileRecycler
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="recycler", key="RecyclerInput", comment="Recycler Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="recycler", key="RecyclerMaxEnergy", comment="Recycler Max Energy (Value in EU)")
    public static int maxEnergy = 1000;
    @ConfigRegistry(config="machines", category="recycler", key="produceIC2Scrap", comment="When enabled and when ic2 is installed the recycler will make ic2 scrap")
    public static boolean produceIC2Scrap = false;
    private final int chance = 6;
    public final String name;
    public final Inventory inventory;
    public final Block drop;
    protected final int energySlot = 2;
    protected final int[] inputSlots = new int[]{0};
    protected final int[] outputSlots = new int[]{1};
    protected int progress = 0;
    protected int operationLength = 45;

    public TileRecycler() {
        this.name = "TileRecycler";
        this.inventory = new Inventory(3, this.name, 64, (TileEntity)this);
        this.drop = ModBlocks.RECYCLER;
        this.checkTeir();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound data = tag.func_74775_l("TileRecycler");
        this.progress = data.func_74764_b("progress") ? data.func_74762_e("progress") : 0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("progress", this.progress);
        tag.func_74782_a("TileRecycler", (NBTBase)data);
        return tag;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.charge(2);
        boolean needsInventoryUpdate = false;
        if (this.canWork()) {
            int progressNeeded;
            if (!this.isActive()) {
                this.setActive(true);
            }
            if (this.progress == 0) {
                needsInventoryUpdate = true;
            }
            if (this.progress < (progressNeeded = Math.max((int)((double)this.operationLength * (1.0 - this.getSpeedMultiplier())), 1))) {
                this.useEnergy(this.getEuPerTick(1.0));
                ++this.progress;
            }
            if (this.progress >= progressNeeded) {
                this.finishWork();
                needsInventoryUpdate = true;
            }
        } else if (this.isActive()) {
            this.setActive(false);
        }
        if (needsInventoryUpdate) {
            super.func_70296_d();
        }
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    protected boolean canWork() {
        ArrayDeque<ItemStack> inputs = new ArrayDeque<ItemStack>();
        for (int index : this.inputSlots) {
            ItemStack input = this.inventory.func_70301_a(index);
            if (ItemUtils.isEmpty((ItemStack)input)) continue;
            inputs.add(input);
        }
        if (inputs.isEmpty()) {
            this.reset();
            return false;
        }
        if (!this.canUseEnergy(this.getEuPerTick(1.0))) {
            return false;
        }
        ItemStack scrap = ItemParts.getPartByName("scrap");
        if (produceIC2Scrap && IC2Duplicates.SCRAP.hasIC2Stack()) {
            scrap = IC2Duplicates.SCRAP.getIc2Stack();
        }
        return this.addToOutputs(scrap, true) == scrap.func_190916_E();
    }

    protected void finishWork() {
        int randomchance;
        ArrayDeque<ItemStack> inputs = new ArrayDeque<ItemStack>();
        for (int index : this.inputSlots) {
            ItemStack input = this.inventory.func_70301_a(index);
            if (ItemUtils.isEmpty((ItemStack)input)) continue;
            inputs.add(input);
        }
        if (inputs.isEmpty()) {
            return;
        }
        for (int index : this.inputSlots) {
            this.inventory.func_70298_a(index, 1);
        }
        ItemStack scrap = ItemParts.getPartByName("scrap");
        if (produceIC2Scrap && IC2Duplicates.SCRAP.hasIC2Stack()) {
            scrap = IC2Duplicates.SCRAP.getIc2Stack();
        }
        if ((randomchance = this.field_145850_b.field_73012_v.nextInt(6)) == 1) {
            this.addToOutputs(scrap, false);
        }
        this.progress = 0;
    }

    protected void reset() {
        this.progress = 0;
        this.operationLength = 0;
    }

    public ItemStack getToolDrop(EntityPlayer player) {
        return new ItemStack(this.drop, 1);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("recycler").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).filterSlot(0, 55, 45, stack -> true).outputSlot(1, 101, 45).energySlot(2, 8, 72).syncEnergyValue().syncIntegerValue(this::getProgress, this::setProgress).syncIntegerValue(this::getOperationLength, this::setOperationLength).addInventory().create((RebornMachineTile)this);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getOperationLength() {
        return this.operationLength;
    }

    public void setOperationLength(int operationLength) {
        this.operationLength = operationLength;
    }

    public int getProgressScaled(int scale) {
        return this.progress == 0 || this.operationLength == 0 ? 0 : this.progress * scale / this.operationLength;
    }

    public int addToOutputs(ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int remaining = stack.func_190916_E();
        for (int index : this.outputSlots) {
            if (remaining <= 0) break;
            ItemStack contents = this.inventory.func_70301_a(index);
            int transferred = Math.min(remaining, Math.min(this.inventory.func_70297_j_(), stack.func_77976_d()) - contents.func_190916_E());
            if (!contents.func_190926_b() && ItemUtils.isItemEqual((ItemStack)contents, (ItemStack)stack, (boolean)true, (boolean)true)) {
                if (!simulate) {
                    this.inventory.func_70299_a(index, ItemUtils.increaseSize((ItemStack)contents, (int)transferred));
                }
                remaining -= transferred;
                continue;
            }
            if (!contents.func_190926_b()) continue;
            if (!simulate) {
                ItemStack temp = ItemUtils.setSize((ItemStack)stack.func_77946_l(), (int)transferred);
                this.inventory.func_70299_a(index, temp);
            }
            remaining -= transferred;
        }
        return stack.func_190916_E() - remaining;
    }
}

