/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.RebornMachineTile;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileGenericMachine;
import techreborn.tiles.multiblock.MultiblockChecker;

@RebornRegistry(modID="techreborn")
public class TileVacuumFreezer
extends TileGenericMachine
implements IContainerProvider {
    @ConfigRegistry(config="machines", category="vacuumfreezer", key="VacuumFreezerInput", comment="Vacuum Freezer Max Input (Value in EU)")
    public static int maxInput = 64;
    @ConfigRegistry(config="machines", category="vacuumfreezer", key="VacuumFreezerMaxEnergy", comment="Vacuum Freezer Max Energy (Value in EU)")
    public static int maxEnergy = 64000;
    @ConfigRegistry(config="machines", category="vacuumfreezer", key="VacuumFreezerBigMultiblock", comment="Vacuum Freezer requires big multiblock")
    public static boolean bigMultiblock = false;
    public MultiblockChecker multiblockChecker;

    public TileVacuumFreezer() {
        super("VacuumFreezer", maxInput, maxEnergy, ModBlocks.VACUUM_FREEZER, 2);
        int[] inputs = new int[]{0};
        int[] outputs = new int[]{1};
        this.inventory = new Inventory(3, "TileVacuumFreezer", 64, (TileEntity)this);
        this.crafter = new RecipeCrafter(Reference.VACUUM_FREEZER_RECIPE, (TileEntity)this, 2, 1, this.inventory, inputs, outputs);
    }

    public boolean getMultiBlock() {
        if (this.multiblockChecker == null) {
            return false;
        }
        boolean up = this.multiblockChecker.checkRectY(1, 1, "reinforced", MultiblockChecker.ZERO_OFFSET);
        boolean down = this.multiblockChecker.checkRectY(1, 1, "reinforced", new BlockPos(0, -2, 0));
        boolean chamber = this.multiblockChecker.checkRingYHollow(1, 1, "advanced", new BlockPos(0, -1, 0));
        if (bigMultiblock) {
            return down && chamber && up;
        }
        return up;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.getMultiBlock()) {
            super.func_73660_a();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.multiblockChecker = new MultiblockChecker(this.field_145850_b, this.field_174879_c.func_177977_b());
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("vacuumfreezer").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 55, 45).outputSlot(1, 101, 45).energySlot(2, 8, 72).syncEnergyValue().syncCrafterValue().addInventory().create((RebornMachineTile)this);
    }
}

