/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init.recipes;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.common.util.OreUtil;
import reborncore.common.util.StringUtils;
import techreborn.blocks.BlockMachineCasing;
import techreborn.blocks.BlockMachineFrames;
import techreborn.blocks.BlockOre;
import techreborn.blocks.cable.BlockCable;
import techreborn.init.IC2Duplicates;
import techreborn.init.recipes.IngredientCell;
import techreborn.items.ItemCells;
import techreborn.items.ItemUpgrades;
import techreborn.items.ingredients.ItemDusts;
import techreborn.items.ingredients.ItemDustsSmall;
import techreborn.items.ingredients.ItemGems;
import techreborn.items.ingredients.ItemIngots;
import techreborn.items.ingredients.ItemNuggets;
import techreborn.items.ingredients.ItemParts;
import techreborn.items.ingredients.ItemPlates;

public abstract class RecipeMethods {
    public static ItemStack getMaterial(String name, int count, Type type) {
        if (type == Type.DUST) {
            return ItemDusts.getDustByName(name, count);
        }
        if (type == Type.SMALL_DUST) {
            return ItemDustsSmall.getSmallDustByName(name, count);
        }
        if (type == Type.INGOT) {
            return ItemIngots.getIngotByName(name, count);
        }
        if (type == Type.GEM) {
            return ItemGems.getGemByName(name, count);
        }
        if (type == Type.PLATE) {
            return ItemPlates.getPlateByName(name, count);
        }
        if (type == Type.NUGGET) {
            return ItemNuggets.getNuggetByName(name, count);
        }
        if (type == Type.CELL) {
            return ItemCells.getCellByName(name, count);
        }
        if (type == Type.PART) {
            return ItemParts.getPartByName(name, count);
        }
        if (type == Type.CABLE) {
            return BlockCable.getCableByName(name, count);
        }
        if (type == Type.MACHINE_FRAME) {
            return BlockMachineFrames.getFrameByName(name, count);
        }
        if (type == Type.MACHINE_CASING) {
            return BlockMachineCasing.getStackByName(name, count);
        }
        if (type == Type.UPGRADE) {
            return ItemUpgrades.getUpgradeByName(name, count);
        }
        if (type == Type.ORE) {
            return BlockOre.getOreByName(name, count);
        }
        return ItemStack.field_190927_a;
    }

    static Object getMaterialObjectFromType(String name, Type type) {
        String object = null;
        if (type == Type.DUST) {
            object = "dust" + StringUtils.toFirstCapital((String)name);
        } else if (type == Type.SMALL_DUST) {
            object = "smallDust" + StringUtils.toFirstCapital((String)name);
        } else if (type == Type.INGOT) {
            object = "ingot" + StringUtils.toFirstCapital((String)name);
        } else if (type == Type.GEM) {
            object = "gem" + StringUtils.toFirstCapital((String)name);
        } else if (type == Type.PLATE) {
            object = "plate" + StringUtils.toFirstCapital((String)name);
        } else if (type == Type.NUGGET) {
            object = "nugget" + StringUtils.toFirstCapital((String)name);
        } else if (type == Type.ORE) {
            object = "ore" + StringUtils.toFirstCapital((String)name);
        }
        if (object != null) {
            if (object instanceof String) {
                if (OreUtil.doesOreExistAndValid((String)object)) {
                    return object;
                }
            } else {
                return object;
            }
        }
        return RecipeMethods.getMaterial(name, type);
    }

    public static ItemStack getMaterial(String name, Type type) {
        return RecipeMethods.getMaterial(name, 1, type);
    }

    public static Object getMaterialObject(String name, Type type) {
        return RecipeMethods.getMaterialObjectFromType(name, type);
    }

    public static ItemStack getOre(String name, int count) {
        return OreUtil.getStackFromName((String)name, (int)count).func_77946_l();
    }

    public static ItemStack getOre(String name) {
        return RecipeMethods.getOre(name, 1);
    }

    public static boolean oreExists(String entry) {
        return OreDictionary.doesOreNameExist((String)entry) && !OreDictionary.getOres((String)entry).isEmpty();
    }

    public static boolean oresExist(String ... entries) {
        return Arrays.stream(entries).allMatch(entry -> OreDictionary.doesOreNameExist((String)entry) && !OreDictionary.getOres((String)entry).isEmpty());
    }

    public static ItemStack getStack(Item item) {
        return RecipeMethods.getStack(item, 1);
    }

    public static ItemStack getStack(Item item, int count) {
        return RecipeMethods.getStack(item, count, 0);
    }

    public static ItemStack getStack(Item item, boolean wildcard) {
        return RecipeMethods.getStack(item, 1, wildcard);
    }

    public static ItemStack getStack(Item item, int count, boolean wildcard) {
        return RecipeMethods.getStack(item, count, wildcard ? Short.MAX_VALUE : 0);
    }

    public static ItemStack getStack(Item item, int count, int metadata) {
        return new ItemStack(item, count, metadata);
    }

    public static ItemStack getStack(Block block) {
        return RecipeMethods.getStack(block, 1);
    }

    public static ItemStack getStack(Block block, int count) {
        return RecipeMethods.getStack(block, count, 0);
    }

    public static ItemStack getStack(Block block, boolean wildcard) {
        return RecipeMethods.getStack(block, 1, true);
    }

    public static ItemStack getStack(Block block, int count, boolean wildcard) {
        return RecipeMethods.getStack(block, count, wildcard ? Short.MAX_VALUE : 0);
    }

    public static ItemStack getStack(Block block, int count, int metadata) {
        return RecipeMethods.getStack(Item.func_150898_a((Block)block), count, metadata);
    }

    public static ItemStack getStack(IC2Duplicates ic2Duplicates) {
        return RecipeMethods.getStack(ic2Duplicates, 1);
    }

    public static ItemStack getStack(IC2Duplicates ic2Duplicates, int count) {
        ItemStack stack = ic2Duplicates.getStackBasedOnConfig();
        stack.func_190920_e(count);
        return stack;
    }

    public static Ingredient getCell(String name, int count) {
        return new IngredientCell(ItemCells.getCellByName(name, count));
    }

    public static Ingredient getCell(String name) {
        return RecipeMethods.getCell(name, 1);
    }

    public static enum Type {
        DUST,
        SMALL_DUST,
        INGOT,
        NUGGET,
        PLATE,
        GEM,
        CELL,
        PART,
        CABLE,
        MACHINE_FRAME,
        MACHINE_CASING,
        UPGRADE,
        ORE;

    }
}

