/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei.generators.fluid;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import reborncore.common.util.StringUtils;
import techreborn.api.generator.EFluidGenerator;
import techreborn.compat.jei.RecipeUtil;
import techreborn.compat.jei.generators.fluid.FluidGeneratorRecipeWrapper;

public class FluidGeneratorRecipeCategory
implements IRecipeCategory<FluidGeneratorRecipeWrapper> {
    public static final ResourceLocation texture = new ResourceLocation("techreborn", "textures/gui/jei2.png");
    private static final int[] INPUT_TANKS = new int[]{0};
    private static final int[] INPUT_SLOTS = new int[]{0};
    private static final int[] OUTPUT_SLOTS = new int[]{1};
    private final IDrawable background;
    private final String title;
    private final IDrawable tankOverlay;
    private final EFluidGenerator generatorType;

    public FluidGeneratorRecipeCategory(EFluidGenerator generatorType, IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(texture, 0, 224, 116, 84).setTextureSize(256, 512).build();
        this.tankOverlay = guiHelper.createDrawable(texture, 176, 72, 12, 47);
        this.title = StringUtils.t((String)("techreborn.jei.category.generator." + generatorType.name().toLowerCase()));
        this.generatorType = generatorType;
    }

    public String getModName() {
        return "Tech Reborn";
    }

    public String getUid() {
        return this.generatorType.getRecipeID();
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, FluidGeneratorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiFluidStacks.init(INPUT_TANKS[0], true, 27, 7, 14, 48, 10000, true, this.tankOverlay);
        RecipeUtil.setRecipeItems(recipeLayout, ingredients, INPUT_SLOTS, OUTPUT_SLOTS, INPUT_TANKS, null);
    }
}

