/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.tier1;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.IToolDrop;
import reborncore.api.ToolManager;
import reborncore.api.tile.IMachineGuiHandler;
import reborncore.common.blocks.PropertyString;
import reborncore.common.blocks.RebornMachineBlock;
import reborncore.common.util.ArrayUtils;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.StringUtils;
import techreborn.init.ModBlocks;
import techreborn.lib.MessageIDs;
import techreborn.tiles.tier1.TilePlayerDectector;
import techreborn.utils.TechRebornCreativeTab;

public class BlockPlayerDetector
extends RebornMachineBlock {
    public static final String[] types = new String[]{"all", "others", "you"};
    static List<String> typeNamesList = Lists.newArrayList((Object[])ArrayUtils.arrayToLowercase((String[])types));
    public static PropertyString TYPE;

    public BlockPlayerDetector() {
        super(true);
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_180632_j(this.func_176203_a(0));
        for (int i = 0; i < types.length; ++i) {
            ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, i, "machines/tier1_machines", new IProperty[0]).setInvVariant("type=" + types[i]));
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TilePlayerDectector();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TilePlayerDectector) {
            ((TilePlayerDectector)tile).owenerUdid = placer.func_110124_au().toString();
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        String type;
        ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
        }
        String newType = type = (String)((Object)state.func_177229_b((IProperty)TYPE));
        TextFormatting color = TextFormatting.GREEN;
        if (!stack.func_190926_b() && ToolManager.INSTANCE.canHandleTool(stack) && ToolManager.INSTANCE.handleTool(stack, pos, worldIn, playerIn, side, false)) {
            if (playerIn.func_70093_af()) {
                if (tileEntity instanceof IToolDrop) {
                    ItemStack drop = ((IToolDrop)tileEntity).getToolDrop(playerIn);
                    if (drop == null) {
                        return false;
                    }
                    if (!drop.func_190926_b()) {
                        BlockPlayerDetector.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
                    }
                    if (!worldIn.field_72995_K) {
                        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                    return true;
                }
            } else {
                if (type.equals("all")) {
                    newType = "others";
                    color = TextFormatting.RED;
                } else if (type.equals("others")) {
                    newType = "you";
                    color = TextFormatting.BLUE;
                } else if (type.equals("you")) {
                    newType = "all";
                }
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)TYPE, (Comparable)((Object)newType)));
            }
        }
        if (worldIn.field_72995_K) {
            ChatUtils.sendNoSpamMessages((int)MessageIDs.playerDetectorID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.detects", (Object[])new Object[0]) + " " + color + StringUtils.toFirstCapital((String)newType)));
        }
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        TYPE = new PropertyString("type", types);
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > types.length) {
            meta = 0;
        }
        return this.func_176194_O().func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)typeNamesList.get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return typeNamesList.indexOf(state.func_177229_b((IProperty)TYPE));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    public IMachineGuiHandler getGui() {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModBlocks.PLAYER_DETECTOR, 1, typeNamesList.indexOf(state.func_177229_b((IProperty)TYPE)));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity entity = blockAccess.func_175625_s(pos);
        if (entity instanceof TilePlayerDectector) {
            return ((TilePlayerDectector)entity).isProvidingPower() ? 15 : 0;
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity entity = blockAccess.func_175625_s(pos);
        if (entity instanceof TilePlayerDectector) {
            return ((TilePlayerDectector)entity).isProvidingPower() ? 15 : 0;
        }
        return 0;
    }
}

