/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wit.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.wit.api.IWirelessInterfaceTerminalItem;
import p455w0rd.wit.api.WITApi;
import p455w0rd.wit.container.ContainerWIT;
import p455w0rd.wit.init.ModKeybindings;
import p455w0rdslib.LibGlobals;

public class WITUtils {
    public static final String INFINITY_ENERGY_NBT = "InfinityEnergy";
    public static final String BOOSTER_SLOT_NBT = "BoosterSlot";
    public static final String IN_RANGE_NBT = "IsInRange";
    public static final String AUTOCONSUME_BOOSTER_NBT = "AutoConsumeBoosters";

    public static NonNullList<ItemStack> getInterfaceTerminals(EntityPlayer player) {
        NonNullList terminalList = NonNullList.func_191196_a();
        InventoryPlayer playerInventory = player.field_71071_by;
        for (ItemStack fluidTerm : playerInventory.field_70462_a) {
            if (!WITUtils.isAnyWIT(fluidTerm)) continue;
            terminalList.add((Object)fluidTerm);
        }
        if (LibGlobals.Mods.BAUBLES.isLoaded()) {
            Set pairSet = WTApi.instance().getBaublesUtility().getAllWTBaublesByType(player, IWirelessInterfaceTerminalItem.class);
            for (Pair pair : pairSet) {
                terminalList.add(pair.getRight());
            }
        }
        return terminalList;
    }

    @Nonnull
    public static ItemStack getInterfaceTerm(InventoryPlayer playerInv) {
        ArrayList baubleList;
        if (!playerInv.field_70458_d.func_184614_ca().func_190926_b() && (playerInv.field_70458_d.func_184614_ca().func_77973_b() instanceof IWirelessInterfaceTerminalItem || WTApi.instance().getWUTUtility().doesWUTSupportType(playerInv.field_70458_d.func_184614_ca(), IWirelessInterfaceTerminalItem.class))) {
            return playerInv.field_70458_d.func_184614_ca();
        }
        ItemStack fluidTerm = ItemStack.field_190927_a;
        if (LibGlobals.Mods.BAUBLES.isLoaded() && (baubleList = Lists.newArrayList((Iterable)WTApi.instance().getBaublesUtility().getAllWTBaublesByType(playerInv.field_70458_d, IWirelessInterfaceTerminalItem.class))).size() > 0) {
            fluidTerm = (ItemStack)((Pair)baubleList.get(0)).getRight();
        }
        if (fluidTerm.func_190926_b()) {
            int invSize = playerInv.func_70302_i_();
            if (invSize <= 0) {
                return ItemStack.field_190927_a;
            }
            for (int i = 0; i < invSize; ++i) {
                ItemStack item = playerInv.func_70301_a(i);
                if (item.func_190926_b() || !(item.func_77973_b() instanceof IWirelessInterfaceTerminalItem) && !WTApi.instance().getWUTUtility().doesWUTSupportType(item, IWirelessInterfaceTerminalItem.class)) continue;
                fluidTerm = item;
                break;
            }
        }
        return fluidTerm;
    }

    public static ItemStack getWITBySlot(EntityPlayer player, int slot) {
        if (slot >= 0) {
            return WTApi.instance().getWTBySlot(player, slot, IWirelessInterfaceTerminalItem.class);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static Pair<Boolean, Pair<Integer, ItemStack>> getFirstWirelessInterfaceTerminal(InventoryPlayer playerInv) {
        boolean isBauble = false;
        int slotID = -1;
        ItemStack wirelessTerm = ItemStack.field_190927_a;
        if (!playerInv.field_70458_d.func_184614_ca().func_190926_b() && (playerInv.field_70458_d.func_184614_ca().func_77973_b() instanceof IWirelessInterfaceTerminalItem || WTApi.instance().getWUTUtility().doesWUTSupportType(playerInv.field_70458_d.func_184614_ca(), IWirelessInterfaceTerminalItem.class))) {
            slotID = playerInv.field_70461_c;
            wirelessTerm = playerInv.field_70458_d.func_184614_ca();
        } else {
            int invSize;
            Pair bauble;
            if (LibGlobals.Mods.BAUBLES.isLoaded() && !((ItemStack)(bauble = WTApi.instance().getBaublesUtility().getFirstWTBaubleByType(playerInv.field_70458_d, IWirelessInterfaceTerminalItem.class)).getRight()).func_190926_b()) {
                wirelessTerm = (ItemStack)bauble.getRight();
                slotID = (Integer)bauble.getLeft();
                if (!wirelessTerm.func_190926_b()) {
                    isBauble = true;
                }
            }
            if (wirelessTerm.func_190926_b() && (invSize = playerInv.func_70302_i_()) > 0) {
                for (int i = 0; i < invSize; ++i) {
                    ItemStack item = playerInv.func_70301_a(i);
                    if (item.func_190926_b() || !(item.func_77973_b() instanceof IWirelessInterfaceTerminalItem) && !WTApi.instance().getWUTUtility().doesWUTSupportType(item, IWirelessInterfaceTerminalItem.class)) continue;
                    wirelessTerm = item;
                    slotID = i;
                    break;
                }
            }
        }
        return Pair.of((Object)isBauble, (Object)Pair.of((Object)slotID, (Object)wirelessTerm));
    }

    public static boolean isAnyWIT(@Nonnull ItemStack interfaceTerm) {
        return interfaceTerm.func_77973_b() instanceof IWirelessInterfaceTerminalItem || WTApi.instance().getWUTUtility().doesWUTSupportType(interfaceTerm, IWirelessInterfaceTerminalItem.class);
    }

    public static boolean isWITCreative(ItemStack interfaceTerm) {
        return !interfaceTerm.func_190926_b() && ((ICustomWirelessTerminalItem)interfaceTerm.func_77973_b()).isCreative();
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer player() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static EntityPlayer player(InventoryPlayer playerInv) {
        return playerInv.field_70458_d;
    }

    @SideOnly(value=Side.CLIENT)
    public static World world() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static World world(EntityPlayer player) {
        return player.func_130014_f_();
    }

    public static void chatMessage(EntityPlayer player, ITextComponent message) {
        player.func_145747_a(message);
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleKeybind() {
        EntityPlayer p = WITUtils.player();
        if (p.field_71070_bA == null) {
            return;
        }
        if (ModKeybindings.openInterfaceTerminal.func_151463_i() != 0 && ModKeybindings.openInterfaceTerminal.func_151468_f()) {
            ItemStack is = WITUtils.getInterfaceTerm(p.field_71071_by);
            if (is.func_190926_b()) {
                return;
            }
            ICustomWirelessTerminalItem interfaceTerm = (ICustomWirelessTerminalItem)is.func_77973_b();
            if (interfaceTerm != null) {
                if (!(p.field_71070_bA instanceof ContainerWIT)) {
                    Pair<Boolean, Pair<Integer, ItemStack>> witPair = WITUtils.getFirstWirelessInterfaceTerminal(p.field_71071_by);
                    WITApi.instance().openWITGui(p, (Boolean)witPair.getLeft(), (Integer)((Pair)witPair.getRight()).getLeft());
                } else {
                    p.func_71053_j();
                }
            }
        }
    }
}

