/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.entity;

import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.items.ItemSpeedboat;
import flaxbeard.immersivepetroleum.common.network.ConsumeBoatFuelPacket;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Vector2f;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.client.CPacketSteerBoat;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpeedboat
extends EntityBoat {
    private static final DataParameter<Boolean>[] DATA_ID_PADDLE = new DataParameter[]{EntityDataManager.func_187226_a(EntityBoat.class, (DataSerializer)DataSerializers.field_187198_h), EntityDataManager.func_187226_a(EntityBoat.class, (DataSerializer)DataSerializers.field_187198_h)};
    private static final DataParameter<String> TANK_FLUID = EntityDataManager.func_187226_a(EntitySpeedboat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> TANK_AMOUNT = EntityDataManager.func_187226_a(EntitySpeedboat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> UPGRADE_0 = EntityDataManager.func_187226_a(EntitySpeedboat.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> UPGRADE_1 = EntityDataManager.func_187226_a(EntitySpeedboat.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> UPGRADE_2 = EntityDataManager.func_187226_a(EntitySpeedboat.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> UPGRADE_3 = EntityDataManager.func_187226_a(EntitySpeedboat.class, (DataSerializer)DataSerializers.field_187196_f);
    private final float[] paddlePositions = new float[2];
    private float momentum;
    private float outOfControlTicks;
    private float deltaRotation;
    private int lerpSteps;
    private double boatPitch;
    private double lerpY;
    private double lerpZ;
    private double boatYaw;
    private double lerpXRot;
    public boolean field_184480_az;
    public boolean field_184459_aA;
    private boolean forwardInputDown;
    private boolean backInputDown;
    public boolean isBoosting;
    private double waterLevel;
    private float boatGlide;
    private EntityBoat.Status status;
    private EntityBoat.Status previousStatus;
    private double lastYd;
    private float lastMoving;
    public float propellerRotation = 0.0f;
    public boolean inLava = false;
    public boolean isFireproof = false;
    public boolean hasIcebreaker = false;
    public boolean hasTank = false;
    public boolean hasRudders = false;
    public boolean hasPaddles = false;

    public EntitySpeedboat(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(1.375f, 0.5625f);
    }

    public EntitySpeedboat(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        for (DataParameter<Boolean> dataparameter : DATA_ID_PADDLE) {
            this.field_70180_af.func_187214_a(dataparameter, (Object)false);
        }
        this.field_70180_af.func_187214_a(TANK_FLUID, (Object)"");
        this.field_70180_af.func_187214_a(TANK_AMOUNT, (Object)0);
        this.field_70180_af.func_187214_a(UPGRADE_0, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(UPGRADE_1, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(UPGRADE_2, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(UPGRADE_3, (Object)ItemStack.field_190927_a);
        super.func_70088_a();
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return this.inLava ? 0.14375000596046447 : -0.1;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (source instanceof EntityDamageSourceIndirect && source.func_76364_f() != null && this.func_184196_w(source.func_76364_f())) {
                return false;
            }
            this.func_70269_c(-this.func_70267_i());
            this.func_70265_b(10);
            this.func_70266_a(this.func_70271_g() + amount * 10.0f);
            this.func_70018_K();
            boolean flag = source.func_76364_f() instanceof EntityPlayer && ((EntityPlayer)source.func_76364_f()).field_71075_bZ.field_75098_d;
            boolean flag2 = source.func_76364_f() instanceof EntityPlayer;
            if (flag || this.func_70271_g() > 40.0f && (!this.isFireproof || flag2) || this.func_70271_g() > 240.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    ItemSpeedboat item = (ItemSpeedboat)this.func_184455_j();
                    ItemStack stack = new ItemStack((Item)item, 1, 0);
                    NonNullList<ItemStack> contained = item.getContainedItems(stack);
                    NonNullList<ItemStack> upgrades = this.getUpgrades();
                    for (int i = 0; i < contained.size() && i < upgrades.size(); ++i) {
                        contained.set(i, upgrades.get(i));
                    }
                    stack.func_77982_d(new NBTTagCompound());
                    item.setContainedItems(stack, contained);
                    this.writeTank(stack.func_77978_p(), true);
                    if (source.func_76364_f() instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)source.func_76364_f();
                        if (!player.func_191521_c(stack)) {
                            EntityItem entityitem = new EntityItem(this.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
                            this.field_70170_p.func_72838_d((Entity)entityitem);
                        }
                    } else {
                        this.func_70099_a(stack, 0.0f);
                    }
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void readTank(NBTTagCompound nbt) {
        FluidTank tank = new FluidTank(this.getMaxFuel());
        if (nbt != null) {
            tank.readFromNBT(nbt.func_74775_l("tank"));
        }
        this.setContainedFluid(tank.getFluid());
    }

    public void writeTank(NBTTagCompound nbt, boolean toItem) {
        FluidTank tank = new FluidTank(this.getMaxFuel());
        FluidStack fs = this.getContainedFluid();
        tank.setFluid(fs);
        boolean write = tank.getFluidAmount() > 0;
        NBTTagCompound tankTag = tank.writeToNBT(new NBTTagCompound());
        if (!toItem || write) {
            nbt.func_74782_a("tank", (NBTBase)tankTag);
        }
    }

    public Item func_184455_j() {
        return IPContent.itemSpeedboat;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.func_70269_c(-this.func_70267_i());
        this.func_70265_b(10);
        this.func_70266_a(this.func_70271_g() * 11.0f);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.boatPitch = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.boatYaw = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    public EnumFacing func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    public static DataParameter<Byte> getFlags() {
        return field_184240_ax;
    }

    public void func_70071_h_() {
        block28: {
            block26: {
                block27: {
                    this.previousStatus = this.status;
                    this.status = this.getBoatStatus();
                    this.outOfControlTicks = this.status != EntityBoat.Status.UNDER_WATER && this.status != EntityBoat.Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
                    if (!this.field_70170_p.field_72995_K && this.outOfControlTicks >= 60.0f) {
                        this.func_184226_ay();
                    }
                    if (this.func_70268_h() > 0) {
                        this.func_70265_b(this.func_70268_h() - 1);
                    }
                    if (this.func_70271_g() > 0.0f) {
                        this.func_70266_a(this.func_70271_g() - 1.0f);
                    }
                    this.field_70169_q = this.field_70165_t;
                    this.field_70167_r = this.field_70163_u;
                    this.field_70166_s = this.field_70161_v;
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70052_a(6, this.func_184202_aL());
                    }
                    this.func_70030_z();
                    this.tickLerp();
                    if (this.func_184186_bw()) {
                        if (this.func_184188_bt().size() == 0 || !(this.func_184188_bt().get(0) instanceof EntityPlayer)) {
                            this.func_184445_a(false, false);
                        }
                        this.updateMotion();
                        if (this.field_70170_p.field_72995_K) {
                            this.controlBoat();
                            this.field_70170_p.func_184135_a((Packet)new CPacketSteerBoat(this.func_184457_a(0), this.func_184457_a(1)));
                        }
                        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    } else {
                        this.field_70159_w = 0.0;
                        this.field_70181_x = 0.0;
                        this.field_70179_y = 0.0;
                    }
                    if (this.field_70170_p.field_72995_K) {
                        if (!this.isEmergency()) {
                            float yO;
                            float zO;
                            float xO;
                            float moving;
                            float f = this.forwardInputDown || this.backInputDown ? (this.isBoosting ? 0.9f : 0.7f) : (moving = 0.5f);
                            if (this.lastMoving != moving) {
                                ImmersivePetroleum.proxy.handleEntitySound(IESounds.dieselGenerator, (Entity)this, false, 0.5f, 0.5f);
                            }
                            ImmersivePetroleum.proxy.handleEntitySound(IESounds.dieselGenerator, (Entity)this, this.func_184207_aI() && this.getContainedFluid() != null && this.getContainedFluid().amount > 0, this.forwardInputDown || this.backInputDown ? 0.5f : 0.3f, moving);
                            this.lastMoving = moving;
                            if (this.forwardInputDown && this.field_70170_p.field_73012_v.nextInt(2) == 0) {
                                if (this.inLava) {
                                    if (this.field_70170_p.field_73012_v.nextInt(3) == 0) {
                                        xO = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                                        zO = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                                        yO = 0.4f + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                                        this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, this.field_70165_t - (double)(xO * 1.5f), this.field_70163_u + (double)yO, this.field_70161_v - (double)(zO * 1.5f), -2.0 * this.field_70159_w, 0.0, -2.0 * this.field_70179_y, new int[]{5});
                                    }
                                } else {
                                    xO = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                                    zO = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                                    yO = 0.1f + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - (double)(xO * 1.5f), this.field_70163_u + (double)yO, this.field_70161_v - (double)(zO * 1.5f), 0.0, 0.0, 0.0, new int[]{5});
                                }
                            }
                            if (this.isBoosting && this.field_70170_p.field_73012_v.nextInt(2) == 0) {
                                xO = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                                zO = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                                yO = 0.8f + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.3f;
                                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t - (double)(xO * 1.3f), this.field_70163_u + (double)yO, this.field_70161_v - (double)(zO * 1.3f), 0.0, 0.0, 0.0, new int[]{5});
                            }
                        } else {
                            ImmersivePetroleum.proxy.handleEntitySound(IESounds.dieselGenerator, (Entity)this, false, 0.5f, 0.5f);
                        }
                    }
                    if (this.isEmergency()) break block26;
                    if (!this.func_184457_a(0)) break block27;
                    this.paddlePositions[0] = (float)((double)this.paddlePositions[0] + (this.isBoosting ? 0.02 : 0.01));
                    break block28;
                }
                if (!this.func_184457_a(1)) break block28;
                this.paddlePositions[0] = (float)((double)this.paddlePositions[0] - 0.01);
                break block28;
            }
            for (int i = 0; i <= 1; ++i) {
                this.paddlePositions[i] = this.func_184457_a(i) ? (float)((double)this.paddlePositions[i] + 0.01) : 0.0f;
            }
        }
        float xO = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180)));
        float zO = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
        Vector2f vec = new Vector2f(xO, zO);
        vec.normalize();
        if (this.hasIcebreaker && !this.isEmergency()) {
            AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g((double)0.1f);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72340_a + 0.001), (double)(axisalignedbb.field_72338_b + 0.001), (double)(axisalignedbb.field_72339_c + 0.001));
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos1 = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72336_d - 0.001), (double)(axisalignedbb.field_72337_e - 0.001), (double)(axisalignedbb.field_72334_f - 0.001));
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos2 = BlockPos.PooledMutableBlockPos.func_185346_s();
            if (this.field_70170_p.func_175707_a((BlockPos)blockpos$pooledmutableblockpos, (BlockPos)blockpos$pooledmutableblockpos1)) {
                for (int i = blockpos$pooledmutableblockpos.func_177958_n(); i <= blockpos$pooledmutableblockpos1.func_177958_n(); ++i) {
                    for (int j = blockpos$pooledmutableblockpos.func_177956_o(); j <= blockpos$pooledmutableblockpos1.func_177956_o(); ++j) {
                        for (int k = blockpos$pooledmutableblockpos.func_177952_p(); k <= blockpos$pooledmutableblockpos1.func_177952_p(); ++k) {
                            blockpos$pooledmutableblockpos2.func_181079_c(i, j, k);
                            IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos2);
                            Vector2f vec2 = new Vector2f((float)((double)((float)i + 0.5f) - this.field_70165_t), (float)((double)((float)k + 0.5f) - this.field_70161_v));
                            vec2.normalize();
                            float sim = vec2.dot(vec);
                            if (iblockstate.func_177230_c() != Blocks.field_150432_aD || !(sim > 0.3f)) continue;
                            this.field_70170_p.func_175655_b((BlockPos)blockpos$pooledmutableblockpos2, false);
                            this.field_70170_p.func_175656_a((BlockPos)blockpos$pooledmutableblockpos2, Blocks.field_150358_i.func_176223_P());
                        }
                    }
                }
            }
            blockpos$pooledmutableblockpos.func_185344_t();
            blockpos$pooledmutableblockpos1.func_185344_t();
            blockpos$pooledmutableblockpos2.func_185344_t();
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelectors.func_188442_a((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof EntityPlayer);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (this.func_184196_w(entity)) continue;
                if (flag && this.func_184188_bt().size() < 2 && !entity.func_184218_aH() && entity.field_70130_N < this.field_70130_N && entity instanceof EntityLivingBase && !(entity instanceof EntityWaterMob) && !(entity instanceof EntityPlayer)) {
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
                if (!this.hasIcebreaker || !(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer || !(this.func_184179_bs() instanceof EntityPlayer)) continue;
                Vector2f vec2 = new Vector2f((float)(entity.field_70165_t - this.field_70165_t), (float)(entity.field_70161_v - this.field_70161_v));
                vec2.normalize();
                float sim = vec2.dot(vec);
                if (!(sim > 0.5f)) continue;
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.func_184179_bs())), 4.0f);
                entity.field_70159_w += (double)(vec2.x * 0.75f);
                entity.field_70179_y += (double)(vec2.y * 0.75f);
            }
        }
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.boatPitch - this.field_70165_t) / (double)this.lerpSteps;
            double d1 = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double d2 = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpXRot - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_184445_a(boolean p_184445_1_, boolean p_184445_2_) {
        this.field_70180_af.func_187227_b(DATA_ID_PADDLE[0], (Object)p_184445_1_);
        this.field_70180_af.func_187227_b(DATA_ID_PADDLE[1], (Object)p_184445_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_184448_a(int p_184448_1_, float limbSwing) {
        if (this.isEmergency()) {
            return this.func_184457_a(p_184448_1_) ? (float)MathHelper.func_151238_b((double)((double)this.paddlePositions[p_184448_1_] - 0.01), (double)this.paddlePositions[p_184448_1_], (double)limbSwing) : 0.0f;
        }
        if (this.func_184457_a(0)) {
            return (float)MathHelper.func_151238_b((double)((double)this.paddlePositions[p_184448_1_] - (this.isBoosting ? 0.02 : 0.01)), (double)this.paddlePositions[p_184448_1_], (double)limbSwing);
        }
        return this.func_184457_a(1) ? (float)MathHelper.func_151238_b((double)((double)this.paddlePositions[p_184448_1_] + 0.01), (double)this.paddlePositions[p_184448_1_], (double)limbSwing) : this.paddlePositions[p_184448_1_];
    }

    private EntityBoat.Status getBoatStatus() {
        EntityBoat.Status entityboat$status = this.getUnderwaterStatus();
        if (entityboat$status != null) {
            this.waterLevel = this.func_174813_aQ().field_72337_e;
            return entityboat$status;
        }
        if (this.checkInWater()) {
            return EntityBoat.Status.IN_WATER;
        }
        float f = this.func_184441_l();
        if (f > 0.0f) {
            this.boatGlide = f;
            return EntityBoat.Status.ON_LAND;
        }
        return EntityBoat.Status.IN_AIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float func_184451_k() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.lastYd));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            float f1;
            block4: for (int k1 = k; k1 < l; ++k1) {
                float f = 0.0f;
                int l1 = i;
                while (true) {
                    if (l1 >= j) {
                        float f2;
                        if (!(f < 1.0f)) continue block4;
                        float f3 = f2 = (float)blockpos$pooledmutableblockpos.func_177956_o() + f;
                        return f3;
                    }
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(l1, k1, i2);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (iblockstate.func_185904_a() == Material.field_151586_h || this.isFireproof && iblockstate.func_185904_a() == Material.field_151587_i) {
                            f = Math.max(f, BlockLiquid.func_190973_f((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos));
                        }
                        if (f >= 1.0f) continue block4;
                    }
                    ++l1;
                }
            }
            float f = f1 = (float)(l + 1);
            return f;
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float func_184441_l() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b - 0.001, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        int i = MathHelper.func_76128_c((double)axisalignedbb1.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)axisalignedbb1.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)axisalignedbb1.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)axisalignedbb1.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)axisalignedbb1.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)axisalignedbb1.field_72334_f) + 1;
        ArrayList list = Lists.newArrayList();
        float f = 0.0f;
        int k1 = 0;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                    if (j2 == 2) continue;
                    for (int k2 = k; k2 < l; ++k2) {
                        if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                        blockpos$pooledmutableblockpos.func_181079_c(l1, k2, i2);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        iblockstate.func_185908_a(this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos, axisalignedbb1, (List)list, (Entity)this, false);
                        if (!list.isEmpty()) {
                            f += iblockstate.func_177230_c().field_149765_K;
                            ++k1;
                        }
                        list.clear();
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return f / (float)k1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        this.inLava = false;
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (iblockstate.func_185904_a() != Material.field_151586_h && (!this.isFireproof || iblockstate.func_185904_a() != Material.field_151587_i)) continue;
                        if (iblockstate.func_185904_a() == Material.field_151587_i) {
                            this.inLava = true;
                        }
                        float f = BlockLiquid.func_190972_g((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos);
                        this.waterLevel = Math.max((double)f, this.waterLevel);
                        flag |= axisalignedbb.field_72338_b < (double)f;
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private EntityBoat.Status getUnderwaterStatus() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (iblockstate.func_185904_a() != Material.field_151586_h && (!this.isFireproof || iblockstate.func_185904_a() != Material.field_151587_i) || !(d0 < (double)BlockLiquid.func_190972_g((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos))) continue;
                        if ((Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                            EntityBoat.Status entityboat$status;
                            EntityBoat.Status status = entityboat$status = EntityBoat.Status.UNDER_FLOWING_WATER;
                            return status;
                        }
                        flag = true;
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return flag ? EntityBoat.Status.UNDER_WATER : null;
    }

    private void updateMotion() {
        double d0 = -0.04f;
        double d1 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.momentum = 0.05f;
        if (this.previousStatus == EntityBoat.Status.IN_AIR && this.status != EntityBoat.Status.IN_AIR && this.status != EntityBoat.Status.ON_LAND) {
            this.waterLevel = this.func_174813_aQ().field_72338_b + (double)this.field_70131_O;
            this.func_70107_b(this.field_70165_t, (double)(this.func_184451_k() - this.field_70131_O) + 0.101, this.field_70161_v);
            this.field_70181_x = 0.0;
            this.lastYd = 0.0;
            this.status = EntityBoat.Status.IN_WATER;
        } else {
            if (this.status == EntityBoat.Status.IN_WATER) {
                d2 = (this.waterLevel - this.func_174813_aQ().field_72338_b) / (double)this.field_70131_O;
                this.momentum = 0.9f;
            } else if (this.status == EntityBoat.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.momentum = 0.9f;
            } else if (this.status == EntityBoat.Status.UNDER_WATER) {
                d2 = 0.01f;
                this.momentum = 0.45f;
            } else if (this.status == EntityBoat.Status.IN_AIR) {
                this.momentum = 0.9f;
            } else if (this.status == EntityBoat.Status.ON_LAND) {
                this.momentum = this.boatGlide;
                if (this.func_184179_bs() instanceof EntityPlayer) {
                    this.boatGlide /= 2.0f;
                }
            }
            this.field_70159_w *= (double)this.momentum;
            this.field_70179_y *= (double)this.momentum;
            this.deltaRotation *= this.momentum;
            this.field_70181_x += d1;
            if (d2 > 0.0) {
                double d3 = 0.65;
                this.field_70181_x += d2 * 0.06153846016296973;
                double d4 = 0.75;
                this.field_70181_x *= 0.75;
            }
        }
    }

    public boolean isEmergency() {
        FluidStack fluid = this.getContainedFluid();
        int consumeAmount = 0;
        if (fluid != null) {
            consumeAmount = FuelHandler.getBoatFuelUsedPerTick(fluid.getFluid());
            return fluid.amount <= consumeAmount && this.hasPaddles;
        }
        return this.hasPaddles;
    }

    private void controlBoat() {
        if (this.func_184207_aI()) {
            float f = 0.0f;
            if (this.isEmergency()) {
                if (this.field_184480_az) {
                    this.deltaRotation += -1.0f;
                }
                if (this.field_184459_aA) {
                    this.deltaRotation += 1.0f;
                }
                if (this.field_184459_aA != this.field_184480_az && !this.forwardInputDown && !this.backInputDown) {
                    f += 0.005f;
                }
                this.field_70177_z += this.deltaRotation;
                if (this.forwardInputDown) {
                    f += 0.04f;
                }
                if (this.backInputDown) {
                    f -= 0.005f;
                }
                this.field_70159_w += (double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f);
                this.field_70179_y += (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f);
                this.func_184445_a(this.field_184459_aA || this.forwardInputDown, this.field_184480_az || this.forwardInputDown);
            } else {
                this.field_70177_z += this.deltaRotation;
                FluidStack fluid = this.getContainedFluid();
                int consumeAmount = 0;
                if (fluid != null) {
                    consumeAmount = FuelHandler.getBoatFuelUsedPerTick(fluid.getFluid());
                }
                if (fluid != null && fluid.amount >= consumeAmount && (this.forwardInputDown || this.backInputDown)) {
                    int toConsume = consumeAmount;
                    if (this.forwardInputDown) {
                        f += 0.049999997f;
                        if (this.isBoosting && fluid.amount >= 3 * consumeAmount) {
                            f = (float)((double)f * 1.6);
                            toConsume *= 3;
                        }
                    }
                    if (this.backInputDown) {
                        f -= 0.01f;
                    }
                    fluid.amount = Math.max(0, fluid.amount - toConsume);
                    this.setContainedFluid(fluid);
                    IPPacketHandler.INSTANCE.sendToServer((IMessage)new ConsumeBoatFuelPacket(toConsume));
                    this.func_184445_a(this.forwardInputDown, this.backInputDown);
                } else {
                    this.func_184445_a(false, false);
                }
                this.field_70159_w += (double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f);
                this.field_70179_y += (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f);
                float speed = (float)Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                if (this.field_184480_az) {
                    this.deltaRotation += -1.1f * speed * (this.hasRudders ? 1.5f : 1.0f) * (this.isBoosting ? 0.5f : 1.0f) * (this.backInputDown && !this.forwardInputDown ? 2.0f : 1.0f);
                    if (this.propellerRotation > -1.0f) {
                        this.propellerRotation -= 0.2f;
                    }
                }
                if (this.field_184459_aA) {
                    this.deltaRotation += 1.1f * speed * (this.hasRudders ? 1.5f : 1.0f) * (this.isBoosting ? 0.5f : 1.0f) * (this.backInputDown && !this.forwardInputDown ? 2.0f : 1.0f);
                    if (this.propellerRotation < 1.0f) {
                        this.propellerRotation += 0.2f;
                    }
                }
                if (!this.field_184459_aA && !this.field_184480_az) {
                    this.propellerRotation *= 0.7f;
                }
            }
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof EntityAnimal) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)f1, this.field_70161_v + vec3d.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.func_184454_a(passenger);
            if (passenger instanceof EntityAnimal && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((EntityAnimal)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected void func_184454_a(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.func_184454_a(entityToUpdate);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74778_a("Type", this.func_184453_r().func_184980_a());
        FluidStack fs = this.getContainedFluid();
        compound.func_74778_a("tank_fluid", fs == null ? "" : fs.getFluid().getName());
        compound.func_74768_a("tank_amount", fs == null ? 0 : fs.amount);
        NBTTagList list = new NBTTagList();
        NonNullList<ItemStack> upgrades = this.getUpgrades();
        for (int i = 0; i < upgrades.size(); ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (!((ItemStack)upgrades.get(i)).func_190926_b()) {
                ((ItemStack)upgrades.get(i)).func_77955_b(nbt);
            }
            list.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("upgrades", (NBTBase)list);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("Type", 8)) {
            this.func_184458_a(EntityBoat.Type.func_184981_a((String)compound.func_74779_i("Type")));
        }
        String fluidName = compound.func_74779_i("tank_fluid");
        Fluid f = FluidRegistry.getFluid((String)fluidName);
        int amount = compound.func_74762_e("tank_amount");
        this.setContainedFluid(f == null ? null : new FluidStack(f, amount));
        NBTTagList list = (NBTTagList)compound.func_74781_a("upgrades");
        NonNullList upgrades = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            upgrades.set(i, (Object)new ItemStack(list.func_150305_b(i)));
        }
        this.setUpgrades((NonNullList<ItemStack>)upgrades);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (Utils.isFluidRelatedItemStack((ItemStack)stack)) {
            FluidTank tank = new FluidTank(this.getMaxFuel()){

                public int fill(FluidStack resource, boolean doFill) {
                    if (!EntitySpeedboat.this.isFluidValid(resource)) {
                        return 0;
                    }
                    return super.fill(resource, doFill);
                }
            };
            FluidStack fs = this.getContainedFluid();
            tank.setFluid(fs);
            FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)tank);
            this.setContainedFluid(tank.getFluid());
            return true;
        }
        if (!this.field_70170_p.field_72995_K && !player.func_70093_af() && this.outOfControlTicks < 60.0f && !player.func_184215_y((Entity)this)) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        this.lastYd = this.field_70181_x;
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.status != EntityBoat.Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_180430_e(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                            this.func_145778_a(this.func_184455_j(), 1, 0.0f);
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b()).func_185904_a() != Material.field_151586_h && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public boolean func_184457_a(int p_184457_1_) {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_ID_PADDLE[p_184457_1_]) != false && this.func_184179_bs() != null;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184442_a(boolean p_184442_1_, boolean p_184442_2_, boolean p_184442_3_, boolean p_184442_4_) {
        this.field_184480_az = p_184442_1_;
        this.field_184459_aA = p_184442_2_;
        this.forwardInputDown = p_184442_3_;
        this.backInputDown = p_184442_4_;
        this.isBoosting = this.isEmergency() ? false : this.forwardInputDown && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
    }

    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND))) {
            String s = null;
            FluidStack stack = this.getContainedFluid();
            s = stack != null && stack.getFluid() != null ? stack.getFluid().getLocalizedName(stack) + ": " + stack.amount + "mB" : I18n.func_135052_a((String)"gui.immersiveengineering.empty", (Object[])new Object[0]);
            return new String[]{s};
        }
        return null;
    }

    protected boolean isFluidValid(FluidStack resource) {
        return resource != null && resource.getFluid() != null && FuelHandler.isValidBoatFuel(resource.getFluid());
    }

    public int getMaxFuel() {
        return this.hasTank ? 16000 : 8000;
    }

    public FluidStack getContainedFluid() {
        String fluidName = (String)this.field_70180_af.func_187225_a(TANK_FLUID);
        Fluid f = FluidRegistry.getFluid((String)fluidName);
        if (f == null) {
            return null;
        }
        int amount = (Integer)this.field_70180_af.func_187225_a(TANK_AMOUNT);
        if (amount == 0) {
            return null;
        }
        return new FluidStack(f, amount);
    }

    public void setContainedFluid(FluidStack stack) {
        if (stack == null) {
            this.field_70180_af.func_187227_b(TANK_FLUID, (Object)"");
            this.field_70180_af.func_187227_b(TANK_AMOUNT, (Object)0);
        } else {
            this.field_70180_af.func_187227_b(TANK_FLUID, (Object)(stack.getFluid() == null ? "" : stack.getFluid().getName()));
            this.field_70180_af.func_187227_b(TANK_AMOUNT, (Object)stack.amount);
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public NonNullList<ItemStack> getUpgrades() {
        NonNullList stackList = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        ItemStack o0 = (ItemStack)this.field_70180_af.func_187225_a(UPGRADE_0);
        stackList.set(0, (Object)o0);
        ItemStack o1 = (ItemStack)this.field_70180_af.func_187225_a(UPGRADE_1);
        stackList.set(1, (Object)o1);
        ItemStack o2 = (ItemStack)this.field_70180_af.func_187225_a(UPGRADE_2);
        stackList.set(2, (Object)o2);
        ItemStack o3 = (ItemStack)this.field_70180_af.func_187225_a(UPGRADE_3);
        stackList.set(3, (Object)o3);
        return stackList;
    }

    public void setUpgrades(NonNullList<ItemStack> nonNullList) {
        if (nonNullList != null && nonNullList.size() >= 4) {
            ItemStack o0 = nonNullList.get(0) == null ? ItemStack.field_190927_a : (ItemStack)nonNullList.get(0);
            ItemStack o1 = nonNullList.get(1) == null ? ItemStack.field_190927_a : (ItemStack)nonNullList.get(1);
            ItemStack o2 = nonNullList.get(2) == null ? ItemStack.field_190927_a : (ItemStack)nonNullList.get(2);
            ItemStack o3 = nonNullList.get(3) == null ? ItemStack.field_190927_a : (ItemStack)nonNullList.get(3);
            this.field_70180_af.func_187227_b(UPGRADE_0, (Object)o0);
            this.field_70180_af.func_187227_b(UPGRADE_1, (Object)o1);
            this.field_70180_af.func_187227_b(UPGRADE_2, (Object)o2);
            this.field_70180_af.func_187227_b(UPGRADE_3, (Object)o3);
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key == UPGRADE_0 || key == UPGRADE_1 || key == UPGRADE_2 || key == UPGRADE_3) {
            NonNullList<ItemStack> upgrades = this.getUpgrades();
            this.isFireproof = false;
            this.hasIcebreaker = false;
            this.field_70178_ae = false;
            for (ItemStack upgrade : upgrades) {
                if (upgrade == null) continue;
                if (upgrade.func_77973_b() == IPContent.itemUpgrades && upgrade.func_77952_i() == 0) {
                    this.isFireproof = true;
                    this.field_70178_ae = true;
                    continue;
                }
                if (upgrade.func_77973_b() == IPContent.itemUpgrades && upgrade.func_77952_i() == 1) {
                    this.hasIcebreaker = true;
                    continue;
                }
                if (upgrade.func_77973_b() == IPContent.itemUpgrades && upgrade.func_77952_i() == 2) {
                    this.hasTank = true;
                    continue;
                }
                if (upgrade.func_77973_b() == IPContent.itemUpgrades && upgrade.func_77952_i() == 3) {
                    this.hasRudders = true;
                    continue;
                }
                if (upgrade.func_77973_b() != IPContent.itemUpgrades || upgrade.func_77952_i() != 4) continue;
                this.hasPaddles = true;
            }
        }
        super.func_184206_a(key);
    }
}

