/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.api.ToolManager;
import reborncore.api.tile.IWrenchable;
import reborncore.common.BaseTileBlock;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.items.WrenchHelper;

public abstract class RebornOrientableTileBlock
extends BaseTileBlock
implements IWrenchable {
    public static PropertyDirection FACING = BlockDirectional.field_176387_N;

    protected RebornOrientableTileBlock() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        BlockWrenchEventHandler.wrenableBlocks.add(this);
    }

    protected EnumFacing getFacingForPlacement(World worldIn, BlockPos pos, EntityLivingBase placer) {
        if (placer == null) {
            return EnumFacing.NORTH;
        }
        EnumFacing facing = placer.func_174811_aO().func_176734_d();
        if (placer.field_70125_A < -50.0f) {
            facing = EnumFacing.DOWN;
        } else if (placer.field_70125_A > 50.0f) {
            facing = EnumFacing.UP;
        }
        return facing;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        EnumFacing newFacing = this.getFacingForPlacement(worldIn, pos, placer);
        if (!this.canSetFacing(worldIn, pos, newFacing, null)) {
            return;
        }
        this.setFacing(worldIn, pos, newFacing, null);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        if (!stack.func_190926_b() && ToolManager.INSTANCE.canHandleTool(stack) && WrenchHelper.handleWrench(stack, worldIn, pos, playerIn, side)) {
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public int func_176201_c(IBlockState state) {
        int facingInt = this.getSideFromEnum((EnumFacing)state.func_177229_b((IProperty)FACING));
        return facingInt;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = this.getSideFromint(meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Override
    public EnumFacing getFacing(World world, BlockPos pos) {
        return (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
    }

    public abstract EnumFacing getSideFromint(int var1);

    public abstract int getSideFromEnum(EnumFacing var1);

    @Override
    public boolean setFacing(World world, BlockPos pos, EnumFacing newFacing, EntityPlayer player) {
        return world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FACING, (Comparable)newFacing));
    }
}

