/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.render;

import cofh.CoFHCore;
import cofh.core.init.CoreProps;
import gnu.trove.map.hash.TIntFloatHashMap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.ARBShaderObjects;

public final class ShaderHelper {
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    public static int gameTicks = 0;
    public static float midGameTick = 0.0f;
    private static TIntFloatHashMap prevTime = new TIntFloatHashMap();

    public static void initShaders() {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)new ShaderHelper());
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null || !gui.func_73868_f()) {
            ++gameTicks;
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        midGameTick = event.renderTickTime;
    }

    public static void useShader(int shader, ShaderCallback callback) {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0) {
            boolean newFrame;
            float frameTime = (float)gameTicks + midGameTick;
            boolean bl = newFrame = frameTime != prevTime.get(shader);
            if (newFrame) {
                int time = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time");
                ARBShaderObjects.glUniform1fARB((int)time, (float)frameTime);
                prevTime.put(shader, frameTime);
            }
            if (callback != null) {
                callback.call(shader, newFrame);
            }
        }
    }

    public static void useShader(int shader) {
        ShaderHelper.useShader(shader, null);
    }

    public static void releaseShader() {
        ShaderHelper.useShader(0);
    }

    public static boolean useShaders() {
        return OpenGlHelper.field_148824_g && CoreProps.enableShaderEffects;
    }

    public static int createProgram(String vert, String frag) {
        int vertId = 0;
        int fragId = 0;
        int program = 0;
        if (vert != null) {
            vertId = ShaderHelper.createShader(vert, 35633);
        }
        if (frag != null) {
            fragId = ShaderHelper.createShader(frag, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            CoFHCore.LOG.error(ShaderHelper.getLogInfo(program));
            ARBShaderObjects.glDeleteObjectARB((int)program);
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            CoFHCore.LOG.error(ShaderHelper.getLogInfo(program));
            ARBShaderObjects.glDeleteObjectARB((int)program);
            return 0;
        }
        prevTime.put(program, -1.0f);
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderHelper.readFileAsString(filename));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderHelper.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileAsString(String filename) throws Exception {
        StringBuilder source = new StringBuilder();
        InputStream in = ShaderHelper.class.getResourceAsStream(filename);
        Exception exception = null;
        BufferedReader reader = null;
        if (in == null) {
            return "";
        }
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        source.append(line).append('\n');
                    }
                }
                catch (Exception exc) {
                    exception = exc;
                }
            }
            catch (Exception exc) {
                exception = exc;
            }
            finally {
                in.close();
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            finally {
                if (exception != null) {
                    throw exception;
                }
            }
        }
        return source.toString();
    }

    public static abstract class ShaderCallback {
        public abstract void call(int var1, boolean var2);
    }
}

