/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wft.sync;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import p455w0rd.wft.sync.WFTPacket;
import p455w0rd.wft.sync.packets.PacketInventoryAction;
import p455w0rd.wft.sync.packets.PacketMEFluidInventoryUpdate;
import p455w0rd.wft.sync.packets.PacketOpenGui;
import p455w0rd.wft.sync.packets.PacketTargetFluidStack;
import p455w0rd.wft.sync.packets.PacketValueConfig;

public class WFTPacketHandlerBase {
    private static final Map<Class<? extends WFTPacket>, PacketTypes> REVERSE_LOOKUP = new HashMap<Class<? extends WFTPacket>, PacketTypes>();

    public static enum PacketTypes {
        PACKET_INVENTORY_ACTION(PacketInventoryAction.class),
        PACKET_VALUE_CONFIG(PacketValueConfig.class),
        PACKET_OPENWIRELESSTERM(PacketOpenGui.class),
        PACKET_ME_FLUID_INVENTORY_UPDATE(PacketMEFluidInventoryUpdate.class),
        PACKET_TARGET_FLUID(PacketTargetFluidStack.class);

        private final Class<? extends WFTPacket> packetClass;
        private final Constructor<? extends WFTPacket> packetConstructor;

        private PacketTypes(Class<? extends WFTPacket> c) {
            this.packetClass = c;
            Constructor<? extends WFTPacket> x = null;
            try {
                x = this.packetClass.getConstructor(ByteBuf.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (DecoderException decoderException) {
                // empty catch block
            }
            this.packetConstructor = x;
            REVERSE_LOOKUP.put(this.packetClass, this);
            if (this.packetConstructor == null) {
                throw new IllegalStateException("Invalid Packet Class " + c + ", must be constructable on DataInputStream");
            }
        }

        public static PacketTypes getPacket(int id) {
            return PacketTypes.values()[id];
        }

        static PacketTypes getID(Class<? extends WFTPacket> c) {
            return (PacketTypes)((Object)REVERSE_LOOKUP.get(c));
        }

        public WFTPacket parsePacket(ByteBuf in) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.packetConstructor.newInstance(in);
        }
    }
}

