/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.ic2.experimental;

import ic2.api.item.IC2Items;
import ic2.core.profile.ProfileManager;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornCraftingHelper;
import techreborn.api.Reference;
import techreborn.api.recipe.machines.BlastFurnaceRecipe;
import techreborn.api.recipe.machines.IndustrialGrinderRecipe;
import techreborn.compatmod.ic2.IC2Dict;
import techreborn.init.ModBlocks;
import techreborn.init.ModFluids;
import techreborn.init.ModItems;
import techreborn.init.recipes.RecipeMethods;
import techreborn.items.ingredients.ItemIngots;

public class IC2RecipesExperimental {
    private static FluidStack WATER = new FluidStack(FluidRegistry.WATER, 1000);
    private static FluidStack MERCURY = new FluidStack(ModFluids.MERCURY, 1000);
    private static FluidStack SODIUM_PERSULFATE = new FluidStack(ModFluids.SODIUMPERSULFATE, 1000);

    public static void registerRecipes() {
        RebornCraftingHelper.addShapelessRecipe((ItemStack)IC2Dict.getItem("electric_wrench"), (Object[])new Object[]{new ItemStack(ModItems.WRENCH), IC2Dict.getItem("crafting", "small_power_unit")});
        if (ProfileManager.selected.equals(ProfileManager.get((String)"Experimental"))) {
            RebornCraftingHelper.addShapedRecipe((ItemStack)IC2Dict.getItem("te", "nuclear_reactor"), (Object[])new Object[]{"PCP", "RRR", "PGP", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('R'), IC2Dict.getItem("te", "reactor_chamber"), Character.valueOf('G'), new ItemStack(ModBlocks.SOLID_FUEL_GENEREATOR), Character.valueOf('P'), IC2Dict.getItem("plating")});
            RebornCraftingHelper.addShapedRecipe((ItemStack)IC2Dict.getItem("te", "reactor_chamber"), (Object[])new Object[]{" P ", "PBP", " P ", Character.valueOf('P'), IC2Dict.getItem("plating"), Character.valueOf('B'), "machineBlockBasic"});
            RebornCraftingHelper.addShapelessRecipe((ItemStack)IC2Dict.getItem("plating"), (Object[])new Object[]{"plateLead", "plateAdvancedAlloy"});
        }
        if (ProfileManager.selected.equals(ProfileManager.get((String)"Experimental"))) {
            RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe((Object)"gemIridium", null, ItemIngots.getIngotByName((String)"iridium"), null, 1700, 128, 1700));
            IC2RecipesExperimental.removeRecipe(Reference.INDUSTRIAL_GRINDER_RECIPE, "oreIridium");
            ItemStack iridium = IC2Items.getItem((String)"misc_resource", (String)"iridium_ore");
            RecipeHandler.addRecipe((IBaseRecipeType)new IndustrialGrinderRecipe((Object)RecipeMethods.getOre((String)"oreIridium"), WATER, iridium.func_77946_l(), RecipeMethods.getMaterial((String)"iridium", (int)6, (RecipeMethods.Type)RecipeMethods.Type.SMALL_DUST), RecipeMethods.getMaterial((String)"platinum", (int)2, (RecipeMethods.Type)RecipeMethods.Type.SMALL_DUST), null, 100, 128));
            RecipeHandler.addRecipe((IBaseRecipeType)new IndustrialGrinderRecipe((Object)RecipeMethods.getOre((String)"oreIridium"), MERCURY, iridium.func_77946_l(), RecipeMethods.getMaterial((String)"iridium", (int)6, (RecipeMethods.Type)RecipeMethods.Type.SMALL_DUST), RecipeMethods.getMaterial((String)"platinum", (int)2, (RecipeMethods.Type)RecipeMethods.Type.DUST), null, 100, 128));
        }
    }

    public static void removeCraftingTableDuplicates(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)event.getRegistry();
        List<ResourceLocation> recipes = Stream.of(modRegistry.getKeys().toArray()).map(entry -> (ResourceLocation)entry).filter(entry -> entry.func_110624_b().equalsIgnoreCase("ic2")).collect(Collectors.toList());
        recipes.forEach(entry -> {
            ItemStack output;
            IRecipe recipe = (IRecipe)modRegistry.getValue(entry);
            if (recipe != null && ItemUtils.isItemEqual((ItemStack)(output = recipe.func_77571_b()), (ItemStack)IC2Dict.getItem("plating"), (boolean)true, (boolean)true)) {
                modRegistry.remove(entry);
            }
        });
    }

    public static void removeRecipe(String machine, String entry) {
        RecipeHandler.recipeList.removeIf(recipeType -> {
            if (!recipeType.getRecipeName().equals(machine)) {
                return false;
            }
            return recipeType.getInputs().stream().anyMatch(ingredient -> ingredient instanceof ItemStack && ItemUtils.isInputEqual((Object)entry, (ItemStack)((ItemStack)ingredient), (boolean)false, (boolean)false, (boolean)true));
        });
    }
}

