/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import lumien.randomthings.block.BlockLightRedirector;
import lumien.randomthings.network.MessageUtil;
import lumien.randomthings.network.messages.MessageLightRedirector;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileEntityLightRedirector
extends TileEntityBase {
    public static Set<TileEntityLightRedirector> redirectorSet = Collections.newSetFromMap(new WeakHashMap());
    public Map<BlockPos, BlockPos> targets;
    HashMap<EnumFacing, Boolean> enabledMap = new HashMap();
    public boolean established;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileEntityLightRedirector() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.enabledMap.put(facing, true);
        }
        Set<TileEntityLightRedirector> set = redirectorSet;
        synchronized (set) {
            redirectorSet.add(this);
            this.targets = new HashMap<BlockPos, BlockPos>();
        }
    }

    @Override
    public boolean renderAfterData() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        EnumFacing[] enumFacingArray = redirectorSet;
        synchronized (redirectorSet) {
            this.targets.clear();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (EnumFacing facing : EnumFacing.values()) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing));
                this.field_145850_b.func_184138_a(this.field_174879_c.func_177972_a(facing), state, state, 3);
            }
            return;
        }
    }

    public void onChunkUnload() {
        this.func_145843_s();
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b.field_72995_K) {
            this.established = true;
            for (EnumFacing facing : EnumFacing.values()) {
                this.field_145850_b.func_175646_b(this.field_174879_c.func_177972_a(facing), null);
            }
        }
    }

    public void broken() {
        this.func_145843_s();
        MessageLightRedirector message = new MessageLightRedirector(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
        MessageUtil.sendToAllWatchingPos(this.field_145850_b, this.field_174879_c, message);
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            compound.func_74757_a("enabled" + i, this.enabledMap.get(EnumFacing.field_82609_l[i]).booleanValue());
        }
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            if (!compound.func_74764_b("enabled" + i)) continue;
            this.enabledMap.put(EnumFacing.field_82609_l[i], compound.func_74767_n("enabled" + i));
        }
    }

    public IBlockState makeState(IBlockState state) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            state = state.func_177226_a((IProperty)BlockLightRedirector.enabledProperties[facing.ordinal()], (Comparable)this.enabledMap.get(facing));
        }
        return state;
    }

    public boolean isEnabled(EnumFacing facing) {
        return this.enabledMap.get(facing);
    }

    public void toggleSide(EnumFacing facing) {
        this.enabledMap.put(facing, this.enabledMap.get(facing) == false);
        this.syncTE();
    }
}

